$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $("#frm-reportes").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form) {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
                crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
                return false;
            }
            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val($("#txtFechaFin").val());

            var banco = ($("#slcBanco").val() > 0) ? $("#slcBanco").val() : "";
            $("#filtro_banco").val(banco);
            form.submit();
        }
    });

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $("#slcCliente").select2({
        placeholder: "Buscar Cliente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    $("#slcEmpleado").select2({
        placeholder: "Buscar Empleado",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_empleados_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (empleado) {
                return {
                    empleado: empleado
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.empleado,
                        'text': item.emp_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    $("#slcCliente").change(function () {
        var cliente = $(this).val();
        $("#slcOrden").html('<option></option>');
        $("#slcOrden").select2({placeholder: "Seleccione una opción"});
        if (cliente != '') {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('proyectos/procesos/cargar_select_ordenes_cliente/1'),
                data: {id: cliente},
                dataType: 'json',
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcOrden").html(result.ordenes_select);
                    $("#slcOrden").select2({placeholder: "Seleccione una opción"});
                }
            });
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var cliente = ($("#slcCliente").val() > 0) ? $("#slcCliente").val() : "";
        var orden = ($("#slcOrden").val() > 0) ? $("#slcOrden").val() : "";
        var empleado = ($("#slcEmpleado").val() > 0) ? $("#slcEmpleado").val() : "";
        var fecha_ini = $("#txtFechaInicio").val();
        var fecha_fin = $("#txtFechaFin").val();
        if (fecha_ini == '' || fecha_fin == '') {// || cliente == ''
            crear_alerta('error', 'Filtros', 'Verifique los filtros de búsqueda.');
            return false;
        }
        if (!validarPeriodo(fecha_ini, fecha_fin)) {
            crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
            return false;
        }
        $("#dv_contenedor_listado").hide('slide', { direction: 'right' }, 400, function () {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('proyectos/reportes/reporte_horas_extras/1'),
                data: {
                    cliente: cliente, 
                    orden: orden, 
                    empleado: empleado, 
                    fecha_ini: fecha_ini, 
                    fecha_fin: fecha_fin
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $(".print").show();
                    var cliente = ($("#slcCliente").val() > 0) ? $("#slcCliente").val() : "";
                    var orden = ($("#slcOrden").val() > 0) ? $("#slcOrden").val() : "";
                    var empleado = ($("#slcEmpleado").val() > 0) ? $("#slcEmpleado").val() : "";
                    var fecha_ini = $("#txtFechaInicio").val();
                    var fecha_fin = $("#txtFechaFin").val();
                    $("#filtro_cliente").val(cliente);
                    $("#filtro_orden").val(orden);
                    $("#filtro_empleado").val(empleado);
                    $("#filtro_fecha_inicio").val(fecha_ini);
                    $("#filtro_fecha_fin").val(fecha_fin);
                    var oTable = $('#tblListado').dataTable();
                    oTable.fnDestroy();
                    $("#tbContenedorListado").html(result);
                    aplicarDataTable('tblListado');
                    $("#dv_contenedor_listado").show("slide", { direction: 'left' }, 500);
                }
            });
        });
    });


    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}