$(document).ready(function () {    
    $('select').select2({placeholder: "Seleccione una opción"});
    $("#acciones").hide();
        
    $(document).on('change', '#slcCategoria', function () {
        $('#dv_contenedor_listado').html('');
        $('#dvpadre').hide();
        var idcategoria = $('#slcCategoria').val();
        $('#valCategoria').val($( "#slcCategoria option:selected" ).text());
        $("#slcProducto").select2('close');
        if($(this).val() > 0) {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('proyectos/reportes/get_producto_x_categoria'),
                data: {categoria: idcategoria
                    },
                dataType: 'json',
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    $("#slcProducto").html(data.productos);
                    $("#slcProducto").select2();                                   
                }
            });
        }else{                    
            $("#slcProducto").select2('val','');
            $("#slcProducto").html('<option value=""></option>');            
        }            
    });//Fin change slcCategoria
            
    $(document).on('click', '#btnConsultar', function (e) {
        e.preventDefault();
        $("#acciones").hide();
        var contador = validar_campo();
        if(contador >= 1){
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
            return false;
        }
        var idCategoria = $('#slcCategoria').val();        
        var idProducto = $('#slcProducto').val();
        idCategoria = (idCategoria) ? idCategoria : '';
        idProducto = (idProducto) ? idProducto : '';
        $.ajax({
            type: 'post',
            dataType: 'text',
            url: window.gSateliteWhite.baseUrl('proyectos/reportes/get_reporte_estandar_producto/1'),
            data: {
                slcCategoria: idCategoria, 
                slcProducto: idProducto                   
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#dv_contenedor_listado").html(data);
                $("#dvpadre").show();
                if ($.trim(data) != "") {
                    $("#acciones").show();
                }
                wait.close();
            }
        });
    });

    $(document).on( 'change', 'select', function() {//Quitar mensaje de error para select        
        $(this).parent().find('.error').html('');
    });
    
    $(document).on( 'click', '.print', function() {
        contador = validar_campo();
        if(contador >= 1){
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
            return false;
        }        
        $(this).submit();
    })

    $(document).on( 'change', '#slcProducto', function() {
        $('#dv_contenedor_listado').html('');
        $('#dvpadre').hide();
        $('#valProducto').val($( "#slcProducto option:selected" ).text());
        var idProducto = $('#slcProducto').val();
        $.ajax({
            type: 'post',
            url: window.gSateliteWhite.baseUrl('proyectos/reportes/get_data_producto'),
            data: {
                   slcProducto: idProducto                   
                },
            dataType: 'text',
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#descripcion").html(data);
                $('#valDescripcion').val(data);
                wait.close();
            }
        });
    });

});

function validar_campo(){
    var contador = 0;
    if($('#slcCategoria').val() == ''){
        $('#slcCategoria_error').html('Campo requerido');
        contador;            
    }    
    if($('#slcProducto').val() == ''){
        $('#slcProducto_error').html('Campo requerido');
        contador++;
    }    
    return contador;
}