$(document).ready(function () {

    $('select').select2();

    $("#slc_categoria").change(function () {
        var categoria = $(this).val();
        if (categoria != ""){
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {categoria: categoria},
                url: urlj + 'proyectos/reportes/get_articuloxcategoria',
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    $("#slc_producto").html(data.productos);
                    $("#slc_producto").select2();
                }
            });
        } else {
            $("#slc_producto").html('');
            $("#slc_producto").select2('destroy');
            $("#slc_producto").select2({placeholder: 'Seleccione'});
        }
    });

    $("#btn_consultar").click(function () {
        event.preventDefault();

        var slc_categoria   = $("#slc_categoria").val();
        var slc_producto    = $("#slc_producto").val();
        var error_text      = "Campo requerido";
        var error           = false;

        if ( slc_categoria == "" ){
            $("#slc_categoria_error").html(error_text);
            error   = true;
        }

        if ( slc_producto == "" ){
            $("#slc_producto_error").html(error_text);
            error   = true;
        }

        if ( error == true ) {
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
            return false;
        }

        $.ajax({
            url: window.gSateliteWhite.baseUrl('proyectos/reportes/cursograma_analitico'),
            data: {
                slc_categoria: slc_categoria,
                slc_producto: slc_producto
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor_reportes").html(obj.html);
                $("#dv_contenedor_reportes").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });

    });

    $("#frm_reporte").validate({
        ignore: [],
        rules: {
            slc_categoria: {required: true},
            slc_producto: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            form.submit();
        }
    });


});