$(document).ready(function () {
    $('select').select2({placeholder: "Seleccione"});

    $(".datepicker").datepicker({
        dateFormat: 'dd-mm-yy',
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true
    });

    $("#slcCliente").select2({
        placeholder: "Buscar Cliente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    //$("#get_ordenes_cliente")
    $("#slcCliente").change(function () {
        obtenerOrdenes();
    });

    $("#slcTipoOrden").change(function () {
        obtenerOrdenes();
    });

    $("#slcOrden").change(function () {
        var orden = $(this).val();
        if (orden != '') {
            var fechaOrden = $("#slcOrden option:selected").data('fecha');
            $("#txtFechaOrden").val(fechaOrden);
        } else {
            $("#txtFechaOrden").val('');
        }
    });

    $("body").on("change", "#txt_fecha_ini, #txt_fecha_fin", function(){
        obtener_programaciones();
    });
    

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var fecha_ini_a = $("#txt_fecha_ini").val();
        var fecha_fin_a = $("#txt_fecha_fin").val();
        var filtro_prog = $("#slc_program").val();
        var program_id = $("#txt_progra_id").val()
        if (!verifica_fecha(fecha_ini_a, fecha_fin_a)) {
            return false;
        }

        $("#dvResultado").hide('slide', {
            direction: 'right'
        },
        400, function () {
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('proyectos/reportes/rep_produccion_detallada'),
                data: {
                    txt_fecha_ini: fecha_ini_a,
                    txt_fecha_fin: fecha_fin_a, 
                    filtro_progra: filtro_prog,
                    txt_progra_id: program_id,
                    tipo_reporte: ''
                }, //$("#frm_report").serialize(),
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    //console.log(result.html);
                    var fecha_ini = $("#txt_fecha_ini").val();
                    var fecha_fin = $("#txt_fecha_fin").val();
                    $("#dv_contenedor_listado").html(result.html);
                    $("#dvResultado").show("slide", {
                        direction: 'left'
                    }, 500);
                    $("#txt_fecha_ini_p").val(fecha_ini);
                    $("#txt_fecha_fin_p").val(fecha_fin);
                    $("#txt_prog_filt_p").val(filtro_prog);
                    $(".print").show();
                    wait.close();
                }
            });
        });
    });


}); //END DOC READY

function obtener_programaciones() {
    var fecha_ini = $("#txt_fecha_ini").val();
    var fecha_fin = $("#txt_fecha_fin").val();
    var es_valido = verifica_fecha($('#txt_fecha_ini').val(), $('#txt_fecha_fin').val());
    if (fecha_ini != '' && fecha_fin != '' && es_valido) {
        $.ajax({
            type: 'post',
            url: urlj + 'proyectos/reportes/get_programaciones_fechas',
            data: {
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#slc_program").html(data);
                $("#slc_program").select2({placeholder: 'Seleccione'});
                wait.close();
            }
        });
    }
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    var dia_ini = fecha_ini.split("-");
    var dia_fin = fecha_fin.split("-");

    // if ((dia_fin[0] - dia_ini[0]) > 5) {
    //     crear_alerta('error', 'Filtros', 'La cantidad de dias no puede superar a 5.');
    //     return false;
    // }

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        //$("#fecha_fin_error").text('');
        // crear_alerta('error', 'Filtros', 'Elegir un rango de fechas.');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        // $("#fecha_fin").addClass('error');
        // $("#fecha_fin_error").text("Verifique las fechas");
        crear_alerta('error', 'Filtros', 'Verifique las fechas.');
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        // $("#fecha_fin").removeClass('error');
        // $("#fecha_fin_error").text('');
        return true;
    }

    
}

function obtenerOrdenes() {
    var cliente = $("#slcCliente").val();
    var tipo_orden = ($("#slcTipoOrden").val() > 0) ? $("#slcTipoOrden").val() : '';
    $("#slcOrden").html('<option></option>');
    $("#slcOrden").select2({placeholder: "Seleccione una opción"});
    if (cliente != '') {
        $.ajax({
            type: 'post',
            url: window.gSateliteWhite.baseUrl('proyectos/reportes/get_ordenes_cliente'),
            data: {cliente: cliente, tipo_orden: tipo_orden},
            dataType: 'json',
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                wait.close();
                $("#slcOrden").html(result.ordenes);
                $("#slcOrden").select2({placeholder: "Seleccione una opción"});
            }
        });
    }

}