$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $(".datepicker").datepicker({
        dateFormat: 'dd-mm-yy',
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true
    });

    $("#slcCliente").select2({
        placeholder: "Buscar Cliente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    //$("#get_ordenes_cliente")
    $("#slcCliente").change(function () {
        obtenerOrdenes();
    });

    $("#slcTipoOrden").change(function () {
        obtenerOrdenes();
    });

    $("#slcOrden").change(function () {
        var orden = $(this).val();
        if (orden != '') {
            var fechaOrden = $("#slcOrden option:selected").data('fecha');
            $("#txtFechaOrden").val(fechaOrden);
        } else {
            $("#txtFechaOrden").val('');
        }
    });
    

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var fecha_ini_a = $("#txt_fecha_ini").val();
        var fecha_fin_a = $("#txt_fecha_fin").val();
        var caracteristica = $("#slc_caracteristica").val();

        if (!verifica_fecha(fecha_ini_a, fecha_fin_a)) {
            return false;
        }

        $("#dvResultado").hide('slide', {
            direction: 'right'
        },
        400, function () {
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('proyectos/reportes/Producto_costeo'),
                data: $("#frm_report").serialize(),
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    //console.log(result.html);
                    var fecha_ini = $("#txt_fecha_ini").val();
                    var fecha_fin = $("#txt_fecha_fin").val();
                    var slc_orden = $("#slc_orden").val();
                    console.log(result.html);
                    $("#dv_contenedor_listado").html(result.html);
                    //aplicarDataTable(".tabla");
                    $("#dvResultado").show("slide", {
                        direction: 'left'
                    }, 500);
                    $("#txt_fecha_ini_p").val(fecha_ini);
                    $("#txt_fecha_fin_p").val(fecha_fin);
                    $("#slc_caracteristica_p").val(caracteristica);
                    $(".print").show();
                    wait.close();
                }
            });
        });
    });


}); //END DOC READY

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        //$("#fecha_fin_error").text('');
        // crear_alerta('error', 'Filtros', 'Elegir un rango de fechas.');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        // $("#fecha_fin").addClass('error');
        // $("#fecha_fin_error").text("Verifique las fechas");
        crear_alerta('error', 'Filtros', 'Verifique las fechas.');
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        // $("#fecha_fin").removeClass('error');
        // $("#fecha_fin_error").text('');
        return true;
    }

}

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
