$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $("#slcCliente").select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFechaIni,#txtFechaFin").change(function(event) {  
        validar_fecha_inicio_fin('txtFechaIni','txtFechaFin','La fecha de desde debe ser menor a la fecha hasta'); 
    });

    var estados = '';
    //Validaciones de filtros
    $("#frm-etapas").validate({
        ignore:"",
        rules: {
            txtFechaIni:  {required:true},
            txtFechaFin:  {required:true},
            slcOrdenes:   {required:true},
            slcCliente:   {required:true},
            slcProductos: {required:true}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    //Ajax en filtros
    $("#slcCliente").change(function () {
        var cliente = $(this).val();
        if (cliente != '') {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'proyectos/reportes/get_ordenes_cliente',
                data: {cliente: cliente},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    get_ordenes_venta(cliente);
                    $("#slcOrdenes").html(data.ordenes);
                    $('#slcOrdenes').select2({placeholder: "Seleccione una orden"});
                    $("#slcProductos").html('<option value=""></option>');
                    $('#slcProductos').select2({placeholder: "Seleccione un producto"});                    
                    wait.close();
                }
            }); 
        }else  {    
            $("#slcOrdenes").html('<option value=""></option>');
            $('#slcOrdenes').select2({placeholder: "Seleccione una orden"});
            $("#slcProductos").html('<option value=""></option>');
            $('#slcProductos').select2({placeholder: "Seleccione un producto"});
            $("#slcOrdenVenta").html('<option value=""></option>');
            $('#slcOrdenVenta').select2({placeholder: "Seleccione un orden"});
            $("#slcEtapas").html('<option value=""></option>');
            $('#slcEtapas').select2({placeholder: "Seleccione un orden"});

        } 
    });

    function get_ordenes_venta(cliente){
        if (cliente != '') {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'proyectos/reportes/get_ordenes_venta',
                data: {cliente: cliente},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#slcOrdenVenta").html('<option></option>'+data.ordenes);
                    $('#slcOrdenVenta').select2({placeholder: "Seleccione una orden de Venta"});
                    wait.close();
                }
            });
        }else{
            $("#slcOrdenVenta").html('');
            $('#slcOrdenVenta').select2({placeholder: "Seleccione una orden de Venta"});
        }
    }

    $("#slcOrdenes").change(function () {
        var orden = $(this).val();
        if (orden != '') {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'proyectos/reportes/get_productoS_por_orden',
                data: {orden: orden},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#slcProductos").html(data.productos);
                    $('#slcProductos').select2({placeholder: "Seleccione un producto"});
                    wait.close();
                }
            }); 
        }else  {    
            $("#slcProductos").html('<option value=""></option>');
            $('#slcProductos').select2({placeholder: "Seleccione un Producto"});
        } 
    });

      $("#slcProductos").change(function () {
        var producto = $(this).val();
        if (producto != '') {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'proyectos/reportes/get_etapas_productos',
                data: {producto: producto},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#slcEtapas").html('<option></option>'+data.etapas);
                    $('#slcEtapas').select2({placeholder: "Seleccione una etapa"});
                    wait.close();
                }
            }); 
        }else  {    
            $("#slcEtapas").html('<option value=""></option>');
            $('#slcEtapas').select2({placeholder: "Seleccione una etapa"});
        } 
    });

    $("#slcOrdenVenta").change(function () {
        var orv = $(this).val();
        if (orv != '') {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'proyectos/reportes/get_productos_x_orv',
                data: {orv: orv},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#slcProductos").html('<option></option>'+data.productos);
                    $('#slcProductos').select2({placeholder: "Seleccione una orden"});
                    wait.close();
                }
            }); 
        }else  {    
            $("#slcProductos").html('<option value=""></option>');
            $('#slcProductos').select2({placeholder: "Seleccione una orden"});
        } 
    });


  

    //PDF o Excel
    $(".print").live('click',function(event){
        var tipo = $(this).val();
        $("#rpt_tipo").val(tipo);
        $("#frm-etapas").submit();
    })

    //Búsqueda
    $("#btnConsultar").click(function(){
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var cliente   = $("#slcCliente").val();
        var producto  = $("#slcProductos").val()
        var ordenP    = $("#slcOrdenes").val()
        var ordenV    = $("#slcOrdenVenta").val()
        var etapas    = $("#slcEtapas").val()
        if(!$("#frm-etapas").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400, function(){
                $.ajax({
                    type:'post',
                    url:window.gSateliteWhite.baseUrl('proyectos/reportes/show_reporte_etapas'),
                    data:{
                        fecha_ini: fecha_ini,
                        fecha_fin: fecha_fin,
                        cliente: cliente,
                        slcProductos: producto,
                        slcEtapas: etapas,
                        slcOrdenes: ordenP,
                        slcOrdenVenta: ordenV
                    },
                    beforeSend:function(){
                       wait.start();
                    },
                    success:function(result){
                        $('#rpt_txtFechaIni').val(fecha_ini)
                        $('#rpt_txtFechaFin').val(fecha_fin)
                        $('#rpt_cliente').val(cliente)
                        $('#rpt_producto').val(producto)
                        $('#rpt_ordenP').val(ordenP)
                        $('#rpt_ordenV').val(ordenV)
                        $('#rpt_etapas').val(etapas)
                        $('#encabezado').show();
                        $("#dv_contenedor_reg").html(result);
                        $("#control").show();
                        wait.close();
                        $(".btn-info").show(500);
                        $("#dv_contenedor_reg").show("slide", {
                            direction: 'left'
                        }, 500);
                    }
                });
            }
        );

    });
    
});

 function validar_fecha_inicio_fin(id_fecha_inicio,id_fecha_fin,texto_alerta) { 
     texto_alerta = typeof texto_alerta !== 'undefined' ? texto_alerta : 'La fecha de inicio debe ser menor a la fecha fin';
     if($("#"+id_fecha_inicio).length >0 && $("#"+id_fecha_fin).length >0 ) {
         var fecha_inicio = $("#"+id_fecha_inicio).val();
         var fecha_fin = $("#"+id_fecha_fin).val();
         if(fecha_inicio != '' && fecha_fin != '') {
            
            if(fecha_inicio.indexOf('/') != -1){
                f_1 = fecha_inicio.split('/');
                f_2 = fecha_fin.split('/');
            } else {
                f_1 = fecha_inicio.split('-');
                f_2 = fecha_fin.split('-');
            }



            ////////////////////////////////////
            // SI SOLO SE TIENE MES Y ANIO
            ///////////////////////////////////
            if (f_1.length == 2) {
                f_1[2] = f_1[1];
                f_1[1] = f_1[0];
                f_1[0] = '01';
            }
            //alert(f_1[0]+" "+f_1[1]+" "+f_1[2]);
         

            if (f_2.length == 2) {
                f_2[2] = f_2[1];
                f_2[1] = f_2[0];
                f_2[0] = '01';
            }
            //alert(f_2[0]+" "+f_2[1]+" "+f_2[2]);
            
            /////////////////////////////////

             if (f_1[0].length==4 ) { //el año va en la primera posición
              fecha1 = f_1[0] + "-" + f_1[1] + "- " + f_1[2] + " 00:00:00";
              fecha2 = f_2[0] + "-" + f_2[1] + "- " + f_2[2] + " 11:59:00";
              //var f1 = new Date(f_1[0], f_1[1], f_1[2]); 
              //var f2 = new Date(f_2[0], f_2[1], f_2[2]);
             } else {
              fecha1 = f_1[2] + "-" + f_1[1] + "- " + f_1[0] + " 00:00:00";
              fecha2 = f_2[2] + "-" + f_2[1] + "- " + f_2[0] + " 11:59:00";
              //var f1 = new Date(f_1[2], f_1[1], f_1[0]); 
              //var f2 = new Date(f_2[2], f_2[1], f_2[0]);
             }
             var f1 = new Date(fecha1); 
             var f2 = new Date(fecha2);
              
             //alert(f1);
             //alert(f2);
             if( ( f2 < f1 ) ){
                 crear_alerta('error','Error en fechas',texto_alerta);
                 $("#"+id_fecha_inicio).val('');
                 $("#"+id_fecha_fin).val('');
             }
         }

     }
 } 

   
