$(document).ready(function () {
    $('select').select2({placeholder: 'Seleccione'});

    // $('#acciones').hide();    

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    //Búsqueda
    $("#btn_consultar").click(function(){
        $('#acciones').hide();
        var fecha_ini = $("#fecha_ini").val();
        var fecha_fin = $("#fecha_fin").val();
        var articulos = ($.isArray($("#slc_producto").val())) ? $("#slc_producto").val().toString() : "";
        var categoria = ($.isArray($("#slc_category").val())) ? $("#slc_category").val().toString() : "";
        if (fecha_ini == "" || fecha_fin == "") {
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_invalida(fecha_ini, fecha_fin)){
            crear_alerta('error','Alerta','Verifique las fechas del período.');
            return false;
        }
        $("#dv_contenedor_reg").hide('slide',{
            direction:'right'
        },
        400,function(){
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: urlj + 'proyectos/reportes/produccion_general/1',
                data:{
                    fecha_ini: fecha_ini,
                    fecha_fin: fecha_fin,
                    categoria: categoria, 
                    articulos: articulos
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(data){
                    console.log(data);
                    var oTable = $('#datagried').dataTable();
                    $('#hdn_fec_ini').val(fecha_ini);
                    $('#hdn_fec_fin').val(fecha_fin);
                    $('#hdn_article').val(articulos);
                    $('#hdn_categor').val(categoria);
                    oTable.fnDestroy(); 
                    // $('#datagried_tbody').html("");
                    $("#datagried_tbody").html(data.filas);
                    if (data.cantidad > 0) {
                        $('#acciones').show();
                    }                                        
                    aplidarDataTable('datagried');
                    $("#dv_contenedor_reg").show("slide", {
                        direction: 'left'
                    }, 500);
                    wait.close();
                }
            });
        });
    });
    
}); //end document ready

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}    

aplidarDataTable('datagried');

function fecha_invalida(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas del período');
        return true;
    }else{
        return false;
    }
}
