$(document).ready(function () {
    $('select option[value=0]').text('Todos');
    gSateliteWhite.jsSelect();
    
     $("#reporte").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){            
            if ( !validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val()) ) {
                crear_alerta('error', 'Reporte orden de producción', 'Verifique el período de las fechas.');
                return false;
            }
            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val( $("#txtFechaFin").val());            
        
            form.submit();
        }
    });


    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    /*Busqueda*/
    $("#btnConsultar").click(function (event) {
        event.preventDefault();            
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Reporte orden de producción', 'Fechas son obligatorias.');
            return false;
        }

        if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Reporte orden de producción', 'Verifique el período de las fechas.');
                return false;
        }        
        $('#reporte').submit();     
    });


    
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}