$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $("#slcCliente").select2({
        placeholder: "Buscar Cliente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    //$("#get_ordenes_cliente")
    $("#slcCliente").change(function () {
        obtenerOrdenes();
    });

    $("#slcTipoOrden").change(function () {
        obtenerOrdenes();
    });

    $("#slcOrden").change(function () {
        var orden = $(this).val();
        if (orden != '') {
            var fechaOrden = $("#slcOrden option:selected").data('fecha');
            $("#txtFechaOrden").val(fechaOrden);
        } else {
            $("#txtFechaOrden").val('');
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var orden = ($("#slcOrden").val() > 0) ? $("#slcOrden").val() : "";
        var vacio = '<table border="1" width="100%" cellpadding="3"><tr><th style="text-align: center;font-weight: bold;">No Se Encontró Información</th></tr></table>';
        $(".print").hide();
        if (orden == '') {
            crear_alerta('error', 'Filtros', 'Debe especificar Cliente y número de Orden.');
            return false;
        }
        $("#dvResultado").hide('slide', {
            direction: 'right'
        },
        400, function () {
            $.ajax({
                type: 'post',
                dataType: 'text',
                url: window.gSateliteWhite.baseUrl('proyectos/reportes/reporte_materia_prima_x_orden/1'),
                data: {
                    orden: orden,
                    tipo_reporte: ''
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    $("#orden").val(orden);
                    if (result.trim() == vacio) {
                        $(".print").hide();
                    } else {
                        $(".print").show();
                    }
                    $("#dv_contenedor_listado").html(result.trim());
                    $("#dvResultado").show("slide", {
                        direction: 'left'
                    }, 500);
                    wait.close();
                }
            });
        });
    });


}); //END DOC READY

// function verifica_fecha(fecha_ini, fecha_fin) {
//     var fecha_i = fecha_ini.split("-").reverse().join("-");
//     var fecha_f = fecha_fin.split("-").reverse().join("-");

//     if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
//         $("#fecha_fin_error").text('');
//         return true;
//     }

//     if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
//         $("#fecha_fin").addClass('error');
//         $("#fecha_fin_error").text("Verifique las fechas del período");
//         return false;
//     }

//     if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
//         $("#fecha_fin").removeClass('error');
//         $("#fecha_fin_error").text('');
//         return true;
//     }
// }

function obtenerOrdenes() {
    var cliente = $("#slcCliente").val();
    var tipo_orden = ($("#slcTipoOrden").val() > 0) ? $("#slcTipoOrden").val() : '';
    $("#slcOrden").html('<option></option>');
    $("#slcOrden").select2({placeholder: "Seleccione una opción"});
    if (cliente != '') {
        $.ajax({
            type: 'post',
            url: window.gSateliteWhite.baseUrl('proyectos/reportes/get_ordenes_cliente'),
            data: {cliente: cliente, tipo_orden: tipo_orden},
            dataType: 'json',
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                wait.close();
                $("#slcOrden").html(result.ordenes);
                $("#slcOrden").select2({placeholder: "Seleccione una opción"});
            }
        });
    }

}