var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;

$(document).ready(function () {

	$("#slcCategoria").select2();
	$("#slcCategoria").select2({placeholder: 'Seleccione'});

	$(".datePicker").datepicker({
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});

	$("#btn_consultar").click(function () {
		event.preventDefault();
		$("#excel").css("display", "none");//ocultar los botones
		$("#pdf").css("display", "none");

		var txtFechaIni = $("#txtFechaIni").val();
		var txtFechaFin = $("#txtFechaFin").val();
		var categoria 	= $("#slcCategoria").val();
		var text    	= $("#slcCategoria option:selected").text(); 		

		if ( txtFechaIni == "" || txtFechaFin == "") {
			crear_alerta('error', 'Rep. de Análisis de Cotizaciones', 'Por favor ingrese el rango de fechas.');
			return false;
		}

		if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
			crear_alerta('error', 'Rep. de Análisis de Cotizaciones', 'Verifique el período de fechas.');
			return false;
		}

		$("#h_fecha_ini").val(txtFechaIni);
		$("#h_fecha_fin").val(txtFechaFin);
		$("#h_categ_id").val(categoria);
		$("#h_categ_text").val(text);

		
		$.ajax({
			dataType: 'text',
			type: 	  'POST',
			url: 	  urlj+'proyectos/reportes/costo_venta_producto/1',
			data: {
				txtFechaIni: 	txtFechaIni,
				txtFechaFin: 	txtFechaFin,
				tipo_reporte: 	"",
				categoria:		categoria
			},
			beforeSend: function () {
				wait.start();
			},
			success:function(data) {
				var obj = jQuery.parseJSON(data);
				$("#dv_contenedor").html(obj.html);
				$("#dv_contenedor").show("slide", {
					direction: 'left'
				}, 500);
				if (obj.rows>0) {
					$("#excel").css("display", "");
					$("#pdf").css("display", "");
				}
				wait.close();
			}
		}); 
	});

})