$(document).ready(function(){
    $("#acciones").hide();
    $("select").select2({placeholder: "Seleccione"});

    $("#slcCliente, #slcTipoOrden").change(function () {
        obtenerOrdenes();
    });

    $("#slcOrden").change(function () {
        var orden = $(this).val();
        if (orden != '') {
            var fechaOrden = $("#slcOrden option:selected").data('fecha');
            $("#txtFechaOrden").val(fechaOrden);
        } else {
            $("#txtFechaOrden").val("");
        }
    });

    $("#slcCliente").select2({
        placeholder: "Buscar Cliente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    $("#btnConsultar").click(function () {
        var orden = $("#slcOrden").val();
        $("#acciones").hide();
        if (orden == '') {
            crear_alerta('error', 'Filtros', 'Debe especificar Cliente y número de Orden.');
            return false;
        }
        $("#dvResultado").hide('slide', {direction: 'right'}, 400, function () {
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: urlj + 'proyectos/reportes/cantidad_consumo_orden/1',
                data: {orden: orden},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    console.log(data);
                    if (data.cantidad > 0) {
                        $("#hdn_orden").val(orden);
                        $("#acciones").show();
                    }                            
                    $("#dv_contenedor_listado").html(data.filas);
                    $("#dvResultado").show("slide", {direction: 'left'}, 500);
                    wait.close();
                }
            });//end ajax
        });//end transition
    });

});


function obtenerOrdenes() {
    var cliente = $("#slcCliente").val();
    var tipo_orden = ($("#slcTipoOrden").val() > 0) ? $("#slcTipoOrden").val() : '';
    $("#slcOrden").html('<option></option>');
    $("#slcOrden").select2({placeholder: "Seleccione una opción"});
    if (cliente != '') {
        $.ajax({
            type: 'post',
            url: window.gSateliteWhite.baseUrl('proyectos/reportes/get_ordenes_cliente'),
            data: {
                cliente: cliente, 
                tipo_orden: tipo_orden,
                ver_finalizadas: 1
            },
            dataType: 'json',
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                wait.close();
                $("#slcOrden").html(result.ordenes);
                $("#slcOrden").select2({placeholder: "Seleccione una opción"});
            }
        });
    }
}