$(document).ready(function () {

   $("select").select2({placeholder: "Selecccione..."});


   $("#slc_category").select2({
        placeholder:'Buscar Categoría',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_cuentas_cobrar/reportes/consultar_categoria',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.tia_id,
                        'text': (item.tia_codigo+' - '+item.tia_nombre)
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });


    $("#slc_product").select2({
        placeholder: "Nombre o Código del Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/mantenimiento/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    tipo: $("#tipo_general_combo").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };                
            }
        }
    });


    $('#btn_consultar').click(function() {
        var year  = $('#slc_year').val();
        var month = $('#slc_month').val(); 
        var categ = $('#slc_category').val(); 
        var prod  = $('#slc_product').val(); 
        if (year != "" || (month != "" || categ != "" || prod != "") ) {
            $.ajax({
                type: 'post',
                url: urlj + 'proyectos/procesos/ventas_proyectadas',
                data: {
                    year: year,
                    month: month,
                    category: categ,
                    product: prod    
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    var oTable = $('#tabla_ordenes').dataTable();
                    oTable.fnDestroy(); 
                    $('#tbDetalle').html(data);
                    aplidarDataTable('tabla_ordenes');
                    wait.close();
                }
            });
        } else {
            crear_alerta('error', 'Proyección de Ventas', 'Debe seleccionar al menos un filtro.');
            return false;
        }
    });


    $('#btn_consultar').trigger('click');


    $("body").on("click", ".del_proy",function() {
        event.preventDefault();
        var id = $(this).data("borrar");
        alerta_confirm_ajax(borrar_proy, id, 'Alerta de Confirmación', 'Esta acción no se puede revertir.<br /> ¿Está seguro que desea eliminar esta Proyección de Ventas?');
    }); 
    
});//end doc ready 

function borrar_proy(id) {
        var direccion = urlj + 'proyectos/procesos/eliminar_proyeccion_venta/' + id;
        window.location = direccion; 
    }

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        // "bFilter": false,//Esconder el buscador del datatable
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}


