$(document).ready(function () {    

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    $("body").on("change", "#txt_fecha_ini, #txt_fecha_fin", function(){
        if (!(verifica_fecha($('#txt_fecha_ini').val(), $('#txt_fecha_fin').val()))) {
            // $('#txt_fecha_ini').val('');
        }
    });

    $("body").on("click", ".rep_op", function () {
        event.preventDefault();
        var permitido = 0;

        $.ajax({
            dataType: 'json',
            type: 'post',
            url: urlj + 'modulo_compras/procesos/get_permisos',
            async: false,
            data: { url: "proyectos/reportes/rep_produccion_detallada" },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                if (data.permiso == 1) {
                    permitido = 1;
                }
                wait.close();
            }
        });
        if (permitido === 1) {
            var url = $(this).attr('href');
            window.open(url);
        } else {
            crear_alerta('error', 'Permiso', 'Debe tener permiso para visualizar el reporte');
            wait.close();
        }
    });


    $("#btn_consultar").click(function() { 
        if (!(verifica_fecha($('#txt_fecha_ini').val(), $('#txt_fecha_fin').val()))) {
            // $('#txt_fecha_ini').val('');
            return false;
        } else {
            if ($('#txt_fecha_ini').val() != '' && $('#txt_fecha_fin').val() != '') {
                $.ajax({
                    type: 'post',
                    url: urlj + 'proyectos/procesos/programacion_produccion',
                    data: {
                        fecha_ini: $('#txt_fecha_ini').val(),
                        fecha_fin: $('#txt_fecha_fin').val(),
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (data) {
                        var oTable = $('#tblDocumentos').dataTable();
                        oTable.fnDestroy(); 
                        $('#contenedor').html("");
                        $('#contenedor').html(data);
                        aplidarDataTable('tblDocumentos');
                        wait.close();
                    }
                });
            } else {
                crear_alerta('error','Fechas','Verifique las fechas del período');
                return false;
            } 
        }
    });


    $("#btn_consultar").trigger('click');
    
});//end doc ready 




function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas del período');
        return false;
    }else{
        return true;
    }
}

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}