$(document).ready(function () {
   // $('select option[value=0]').text('Todos');
    gSateliteWhite.jsSelect();
    
     $("#reporte").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){            
            if ( !validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val()) ) {
                crear_alerta('error', 'Orden de producción', 'Verifique el período de las fechas.');
                return false;
            }
            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val( $("#txtFechaFin").val());            
        
            form.submit();
        }
    });


    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    /*Busqueda*/
    $("#btnConsultar").click(function (event) {
        event.preventDefault();            
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Orden de producción', 'Fechas son obligatorias.');
            return false;
        }

        if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Orden de producción', 'Verifique el período de las fechas.');
                return false;
        }        
        $('#reporte').submit();     
    });

    $(document).on('click','.lote_auto',function(){ 
        event.preventDefault();
        console.log($(this).attr("id"));        
        alerta_confirm_ajax(generar_orden_auto, $(this).attr("id"),
            '¿Desea generar lotes automaticos?',
            '<h5>Una vez creados los lotes podrá editarlos individualmente</h5>'
        );
    });

    $(document).on('click','.finiquitar',function(){ 
        event.preventDefault();
        console.log($(this).attr("id"));        
        alerta_confirm_ajax(finiquitar_orden_produccion, $(this).attr("id"),
            '¿Desea establecer estar orden como finalizada?.',
            '<h5>Una vez finalizada la orden no podrá editar costos ni realizar ingresos de inventario.<br>¿Está seguro de realizar esta acción?</h5>'
        );
    });

    
});





function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}

function generar_orden_auto(idorden){
    $.ajax({
        url: urlj + 'proyectos/procesos/generar_lotes_automaticos/' + idorden,            
        type: 'GET',
        dataType: 'json',
        beforeSend:function(){
            wait.start();
        },
        success: function(data){
            wait.close();
            /*if(data.estado == 1){
                crear_alerta('success','Lotes automaticos','Lotes creados con éxito.');
            }else{
                crear_alerta('error','Lotes automaticos','Los lotes no pudieron ser creados');
            }*/                  
            setTimeout(function() {                
                  location.href = urlj + 'proyectos/procesos/lotes/' + idorden;
            }, 500);
            
        }
    });//Fin ajax consultar   
}

function finiquitar_orden_produccion(idorden){
    $.ajax({
        url: urlj + 'proyectos/procesos/finiquitar_orden/' + idorden,            
        type: 'POST',
        dataType: 'json',
        beforeSend:function(){
            wait.start();
        },
        success: function(data){
            $("#btnConsultar").trigger('click');
        }
    });
}