var pathArray = window.location.pathname.split('/');
var urlj = url_base_proyecto;
$(document).ready(function () {
    $("select").select2({placeholder: "Seleccione"});
    $("#periodo_planilla, #periodo_planillamo").select2('disable');

    $('.relojito, .relojitomo').timeEntry({
        show24Hours: true,
        showSeconds: false,
        beforeShow: hora_limite,
        spinnerIncDecOnly: true,
        spinnerImage: ''
    });

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    $("#slcCliente").change(function(event) {
        if($(this).val() > 0) {
            $.ajax({
                dataType: 'json',
                url: urlj + 'proyectos/procesos/cargar_select_ordenes_cliente/1',
                type: 'post',
                data: {
                  'id': $(this).val()
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function(data) {                    
                    $("#slcOrden").html(data.ordenes_select); 
                    $("#slcOrden").select2();
                    wait.close();
                }
              });
        } else {
            $("#slcOrden").html('<option value=""></option>');
            $("#slcOrden").select2();
        }        
    });

    $("#slcEmpleado").change(function(event) {
        if ($(this).val() > 0) {
            $.ajax({
                dataType: 'json',
                url: urlj + 'proyectos/procesos/get_planillas_empleado',
                type: 'post',
                data: {
                  'emp_id': $(this).val()
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function(data) {
                    $("#tipo_planilla").html(data.select_tpls); 
                    $("#tipo_planilla").select2();
                    wait.close();
                }
            });
            $("#periodo_planilla").select2('enable');
        } else {
            $("#tipo_planilla").html('<option value=""></option>');
            $("#periodo_planilla").select2('disable');
            $("#tipo_planilla").select2();
        }
    });

    $("#tipo_planilla").change(function(event) {
        if ($(this).val() > 0) {
            $.ajax({
                dataType: 'json',
                url: urlj + 'proyectos/procesos/get_planillas_empleado/1',
                type: 'post',
                data: {
                  'pla_id': $(this).val()
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function(data) {
                    $("#periodo_planilla").html(data.select_plas); 
                    $("#periodo_planilla").select2();
                    wait.close();
                }
              });
        } else {
            $("#periodo_planilla").html('<option value=""></option>');            
            $("#periodo_planilla").select2();
        }
    });

    $(".relojito").change(function(event) {
        var inicio = $("#txtHoraInicio").val();
        var final = $("#txtHoraFin").val();
        if (inicio != "" && final != "") {
            var hora1 = inicio.split(":");
            var hora2 = final.split(":");
            var d_1 = new Date(2000, 1, 1, hora1[0], hora1[1]);
            var d_2 = new Date(2000, 1, 1, hora2[0], hora2[1]);
            var dif = d_2.getTime() - d_1.getTime();
            var horas =  round_number((dif / 3600000));
            $('#total_horas').val(horas);
            $('#total_horas').attr('readonly', true);
        } else {
            $('#total_horas').removeAttr('readonly');
        }
    });

    $("#agregar").click(function () {
        var emplea = $("#slcEmpleado").val();
        var period = $("#periodo_planilla").val();
        var tipo_h = $("#slcTipoHora").val();
        var hora_i = $("#txtHoraInicio").val();
        var hora_f = $("#txtHoraFin").val();
        var hora_t = $("#total_horas").val();
        var fechas = $('#txtFecha').val();
        var tp_pla = $('#tipo_planilla').val();
        var concpt = $('#concepto').val();
        var ord_pd = $("#slcOrden").val();
        var client = $('#slcCliente').val();
        var sal_bs = parseFloat($("#slcEmpleado").find(':selected').data('salario'));
        if (emplea != "" && tipo_h != "" && fechas != "" && hora_t > 0 && $.trim(concpt) != "" && period != "") {
            var tr_id = 'tr_' + emplea + '_' + period + '_' + tipo_h;            
            if($('#datagried').find('#' + tr_id).length > 0){
                crear_alerta('error', 'Aviso', 'El registro ya existe');
                return false;
            }
            var factor = $("#slcTipoHora option:selected").data('factor');
            var total   = parseFloat(((sal_bs / 240) * factor) * hora_t);
            var fila = '<tr id="' + tr_id + '">';
            fila += '<td class="td_emp"><input type="hidden" name="lis_emp[]" value="' + emplea + '" /><label>' + $("#slcEmpleado option:selected").text() + '</label></td>';
            fila += '<td class="td_fec"><input type="hidden" name="lis_fec[]" value="' + fechas + '" /><label>' + fechas + '</label></td>';
            fila += '<td class="td_hinicio"><input type="hidden" name="lis_hinicio[]" value="' + hora_i + '" /><label>' + hora_i + '</label></td>';
            fila += '<td class="td_hfin"><input type="hidden" name="lis_hfin[]" value="' + hora_f + '" /><label>' + hora_f + '<label></td>';
            fila += '<td class="td_hcant"><input type="hidden" name="lis_hcant[]" value="' + hora_t + '" /><label>' + hora_t + '</label></td>';
            fila += '<td class="td_tot"><input type="hidden" name="lis_tot[]" value="' + number_format(total,2,'.','') + '" /><label>$' + number_format(total,2) + '</label></td>'
            fila += '<td class="td_concep"><textarea class="txt" name="lis_concep[]" readonly>' + $.trim(concpt) + '</textarea><input type="hidden" class="cli" name="lis_cli[]" value="' + client + '">';
            fila += '<input type="hidden" name="lis_ord[]" class="ord" value="'+ ord_pd +'" /><input type="hidden" name="lis_tpls[]" class="tpl" value="' + tp_pla + '" />';
            fila += '<input type="hidden" class="tph" name="lis_tphrex[]" value="' + tipo_h + '" /><input type="hidden" name="lis_plas[]" class="pla" value="' + period + '" /></td>';
            fila += '<td><button id="remove" class="btn btn-danger btn-mini remove"><span class="icomoon-icon-remove-5"></span></button><span>&nbsp;</span>';
            fila += '<a class="myModal btnRetChe btn btn-primary btn-mini" href="#modalEditar"><span class="icon16 icomoon-icon-pencil-5"></span></a>'
            fila += '</tr>';
            $("#datagried").append(fila);
            limpiarCampos();
        } else {
            if(emplea == ''){
                $('#slcEmpleado_error').html('Campo requerido');
            }
            if(tipo_h == ''){
                $('#slcTipoHora_error').html('Campo requerido');
            }
            if(fechas == ''){
                $('#txtFecha_error').html('Campo requerido');
            }
            if(!(hora_t > 0)){
                $('#total_horas_error').html('Campo requerido');
            }
            if($.trim(concpt) == ''){
                $('#txtConcepto_error').html('Campo requerido');
            }
            if (period == '') {
                $('#periodo_planilla_error').html('Campo requerido');
            }
            crear_alerta('warning', 'Aviso', 'Verifique los Campos Requeridos');
        }
    });

    $(document).on('change', '.relojitomo', function(event) {
        var inicio = $("#txtHoraIniciomo").val();
        var final = $("#txtHoraFinmo").val();
        if (inicio != "" && final != "") {
            var hora1 = inicio.split(":");
            var hora2 = final.split(":");
            var d_1 = new Date(2000, 1, 1, hora1[0], hora1[1]);
            var d_2 = new Date(2000, 1, 1, hora2[0], hora2[1]);
            var dif = d_2.getTime() - d_1.getTime();
            var horas =  round_number((dif / 3600000));
            $('#total_horasmo').val(horas);
            $('#total_horasmo').attr('readonly', true);
        } else {
            $('#total_horasmo').removeAttr('readonly');
        }
    });    

    $("#save").click(function () {//Verificar si existen filas antes de enviar los datos
        if ($('#datagried tr').length > 1) {
            $('#guardar').click();
        }else{
            $.pnotify({
                type: 'info',
                title: 'Aviso',
                text: 'Debe agregar horas',
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
        }        
    });

    //Quitar mensaje de error para select
    $(document).on('change', 'select', function() {
        $(this).parent().find('.error').html('');
    });
    $(document).on( 'change paste keyup', 'textarea', function() {
        $(this).parent().find('.error').html('');
    });
    $(document).on('change paste keyup', 'input', function() {
        $(this).parent().find('.error').html('');
    });

    //Eliminar filas de la grid
    $(document).on( 'click', '.remove', function() {    
        $(this).parent().parent().remove();        
    });

    $(".myModal").fancybox({
        width: '80%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {

        },
        beforeClose: function () {

        }
    });

    //Cargar datos en el modal
    $(document).on('click','.myModal',function () {
        var idemp = $(this).parent().parent().find('.td_emp').children().val();
        var idcli = $(this).parent().parent().find('.td_concep').children('.cli').val();
        var idord = $(this).parent().parent().find('.td_concep').children('.ord').val();
        var idtpl = $(this).parent().parent().find('.td_concep').children('.tpl').val();
        var idpla = $(this).parent().parent().find('.td_concep').children('.pla').val();
        var idtph = $(this).parent().parent().find('.td_concep').children('.tph').val();
        $("#ord_ya").val(idord);
        $('#slcEmpleadomo').val(idemp).trigger('change');
        get_plan(idemp, idtpl);
        get_perid(idtpl, idpla);
        $('#slcTipoHoramo').val(idtph).trigger('change');
        $('#txtFechamo').val($(this).parent().parent().find('.td_fec').children().val());
        $('#txtHoraIniciomo').val($(this).parent().parent().find('.td_hinicio').children().val());
        $('#txtHoraFinmo').val($(this).parent().parent().find('.td_hfin').children().val());
        $('#conceptomo').val($(this).parent().parent().find('.td_concep').children('.txt').val());
        $(".relojitomo").trigger('change');
        $('#slcClientemo').val(idcli).trigger('change');
        //Asignar el id de la fila al form del modal
        $('.edit_form').attr('id', $(this).parent().parent().attr('id'));
    });

    $("#slcClientemo").change(function(event) {
        var hay_ord = $("#ord_ya").val();
        if($(this).val() > 0) {
            if (hay_ord > 0) {
                get_cli_ord($(this).val(), hay_ord);
            } else {
                $.ajax({
                    dataType: 'json',
                    url: urlj + 'proyectos/procesos/cargar_select_ordenes_cliente_modal/1',
                    type: 'post',
                    async: true,
                    data: {
                        'id': $(this).val()
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function(data) {
                        $("#slcOrdenmo").html(data.ordenes_select); 
                        $("#slcOrdenmo").select2();
                        wait.close();
                    }
                });
            }
        } else {
            $("#slcOrdenmo").html('<option value=""></option>');
            $("#slcOrdenmo").select2();
        }        
    });

    
    //Edicion hora extra
    $(document).on('click', '#btnEditar', function() {
        var emplea = $("#slcEmpleadomo").val();
        var period = $("#periodo_planillamo").val();
        var tipo_h = $("#slcTipoHoramo").val();
        var factor = $("#slcTipoHoramo option:selected").data('factor');
        var hora_i = $("#txtHoraIniciomo").val();
        var hora_f = $("#txtHoraFinmo").val();
        var hora_t = $("#total_horasmo").val();
        var fechas = $('#txtFechamo').val();
        var tp_pla = $('#tipo_planillamo').val();        
        var concpt = $('#conceptomo').val();
        var ord_pd = $("#slcOrdenmo").val();
        var client = $('#slcClientemo').val();
        var sal_bs = parseFloat($("#slcEmpleadomo").find(':selected').data('salario'));
        var total   = parseFloat(((sal_bs / 240) * factor) * hora_t);
        var tr_id = $('.edit_form').attr('id');
        var tr_id_nuevo = 'tr_' + emplea + '_' + period + '_' + tipo_h;
        if(tr_id != tr_id_nuevo){
            if($('#datagried').find('#' + tr_id_nuevo).length > 0){
                $.pnotify({
                    type: 'error',
                    title: 'Aviso',
                    text: 'El registro ya existe',
                    icon: 'ui-icon ui-icon-info',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
                return false;
            }
        }
        if (emplea != "" && tipo_h != "" && fechas != "" && hora_t > 0 && $.trim(concpt) != "" && period != "") {
            $('#'+tr_id).find('.td_emp').children().val(emplea);
            $('#'+tr_id).find('.td_emp').children().next().html($("#slcEmpleadomo option:selected").text());
            $('#'+tr_id).find('.td_fec').children().val(fechas);
            $('#'+tr_id).find('.td_fec').children().next().html(fechas);
            $('#'+tr_id).find('.td_hinicio').children().val(hora_i);            
            $('#'+tr_id).find('.td_hinicio').children().next().html(hora_i);
            $('#'+tr_id).find('.td_hfin').children().val(hora_f);
            $('#'+tr_id).find('.td_hfin').children().next().html(hora_f);
            $('#'+tr_id).find('.td_hcant').children().val(hora_t);
            $('#'+tr_id).find('.td_hcant').children().next().html(hora_t);
            $('#'+tr_id).find('.td_tot').children().val(number_format(total,2,'.',''));
            $('#'+tr_id).find('.td_tot').children().next().html('$'+number_format(total,2));
            $('#'+tr_id).find('.td_concep').children().val($.trim(concpt));
            $('#'+tr_id).find('.td_concep').children('.cli').val(client);
            $('#'+tr_id).find('.td_concep').children('.ord').val(ord_pd);
            $('#'+tr_id).find('.td_concep').children('.tpl').val(tp_pla);
            $('#'+tr_id).find('.td_concep').children('.tph').val(tipo_h);
            $('#'+tr_id).find('.td_concep').children('.pla').val(period);
            $.fancybox.close();
        } else {
            if(emplea == ''){
                $('#slcEmpleadomo_error').html('Campo requerido');
            }
            if(tipo_h == ''){
                $('#slcTipoHoramo_error').html('Campo requerido');
            }
            if(fechas == ''){
                $('#txtFechamo_error').html('Campo requerido');
            }
            if(!(hora_t > 0)){
                $('#total_horasmo_error').html('Campo requerido');
            }
            if($.trim(concpt) == ''){
                $('#txtConceptomo_error').html('Campo requerido');
            }
            if (period == '') {
                $('#periodo_planillamo').html('Campo requerido');
            }
            crear_alerta('warning', 'Aviso', 'Verifique los Campos Requeridos');
        }
    });

        
}); // Cierre del jQuery

function limpiarCampos(){
    $("#slcCliente").select2("val", "");
    $("#slcOrden").select2("val", "");
    $("#slcEmpleado").select2("val", "");
    $("#slcTipoHora").select2("val", "");
    $('#txtFecha').val('');
    $('#txtHoraInicio').val('');
    $('#txtHoraFin').val('');
    $('#total_horas').val('');
    $('#concepto').val('');
    $("#tipo_planilla").select2("val", "");
    $("#periodo_planilla").select2("val", "");
    $('#total_horas').removeAttr('readonly');
}

function hora_limite(input) {
    return {
        minTime: (input.id === 'txtHoraFin' ? $('#txtHoraInicio').timeEntry('getTime') : null),  
        maxTime: (input.id === 'txtHoraInicio' ? $('#txtHoraFin').timeEntry('getTime') : null)
    }; 
}

function get_plan(id, slctd = null){
    if (id > 0) {
        $.ajax({
            dataType: 'json',
            url: urlj + 'proyectos/procesos/get_planillas_empleado/0/' + slctd,
            type: 'post',
            data: {
                'emp_id': id
            },
            beforeSend: function () {
                wait.start();
            },
            success: function(data) {
                $("#tipo_planillamo").html(data.select_tpls); 
                $("#tipo_planillamo").select2();
                wait.close();
            }
        });
        $("#periodo_planillamo").select2('enable');
    } else {
        $("#tipo_planillamo").html('<option value=""></option>');
        $("#periodo_planillamo").select2('disable');
        $("#tipo_planillamo").select2();
    }
}

function get_perid(tpl, slctd = null){
    if (tpl > 0) {
        $.ajax({
            dataType: 'json',
            url: urlj + 'proyectos/procesos/get_planillas_empleado/1/' + slctd,
            type: 'post',
            data: {
                'pla_id': tpl
            },
            beforeSend: function () {
                wait.start();
            },
            success: function(data) {
                $("#periodo_planillamo").html(data.select_plas); 
                $("#periodo_planillamo").select2();
                wait.close();
            }
        });
    } else {
        $("#periodo_planillamo").html('<option value=""></option>');            
        $("#periodo_planillamo").select2();
    }
}

function get_cli_ord(cliente, slctd = null) {
    if(cliente > 0) {
        $.ajax({
            dataType: 'json',
            url: urlj + 'proyectos/procesos/cargar_select_ordenes_cliente_modal/1',
            type: 'post',
            data: {
                'id': cliente,
                'selected': slctd
            },
            beforeSend: function () {
                wait.start();
            },
            success: function(data) {
                $("#slcOrdenmo").html(data.ordenes_select); 
                $("#slcOrdenmo").select2();
                wait.close();
            }
        });
    } else {
        $("#slcOrdenmo").html('<option value=""></option>'); 
        $("#slcOrdenmo").select2();
    }        
}
