$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto; 
    var slc_bodega      = "";
    var slc_bodega_tmp  = "";

    $("#afecta_inventario").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#txt_afecta_inventario").val(1);
                $("#btnProcesar").hide();
            } else {
                $("#txt_afecta_inventario").val(0);
                $("#btnProcesar").show();
            }
        }
    });


    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $('select').select2({placeholder: 'Seleccione una opción'});
    $(".soloNumeros").numeric();
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $(".btn-close").live('click', function () {
        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    var id_bod;
    var id_cat;
    var id_prod;

    $("#frm-solicitud").validate({
        ignore: ".solicitadoMt",
        rules: {
            slcTipo: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#tbMateriaPrima .trMateriaPrima').length == 0) {
                crear_alerta('error', 'Solicitud de Materiales', 'Debe ingresar al menos un registro.');
                return false;
            }

            form.submit();
        }
    });

    $("#slcProducto").change(function () {
        var producto = $(this).val();
        var idproducto = $("#slcProducto :selected").data('idarticulo');
        var idorden = $("#hdnOrden").val();
        if (producto > 0) {
            var cantidad_disponible = $("#slcProducto option:selected").data('disponible');
            $("#txtCantidadEnvio").val(cantidad_disponible);
            //mostrar select
            selectEtapasProducto(idproducto, idorden);
            $("#divSlcEtapa").css('display','block');
        } else {
            $("#txtCantidadEnvio").val('');
            //ocultar select
            $("#divSlcEtapa").css('display','none');
        }
    });

    $("#slcTipo").change(function () {
        var tipo = $(this).val();
    //    $("#slcBodega").val('');
        if ($("#tblMateriaPrima .trMateriaPrima").length > 0) {
            alerta_confirm_ajax(verificar_alert, "", "Alerta confirmación", "¿Éstas seguro que quieres cambiar el tipo de solicitud?");
        }
        if (tipo == 1) {
            $("#dvBodega").show('slow');
        } else {
            $("#dvBodega").hide('slow');
            $("#slcBodega option:selected").removeAttr('selected');
            $("#slcBodega").select2({placeholder: "Seleccione una opción"});
        }
    });

    $("#slcBodega").change(function (){
        slc_bodega_tmp = $(this).val();
        if ($("#tblMateriaPrima .trMateriaPrima").length > 0) {
            alerta_confirm_ajax(verificar_alert, "", "Alerta confirmación", "¿Éstas seguro que quieres de bodega?");
        }

        if ($("#tblMateriaPrima .trMateriaPrima").length > 0) {
            $("#slcBodega").val( slc_bodega );
            $("#slcBodega").select2();
        } else{
            $("#dvProductos").html("");
            slc_bodega = $(this).val();
        }
    });

    function verificar_alert() {
        $("#slcBodega").val( slc_bodega_tmp );
        slc_bodega = slc_bodega_tmp;
        $("#slcBodega").select2();

        $("#dvProductos").html("");
        $('#tblMateriaPrima').dataTable().fnDestroy();
        $('#tbMateriaPrima').html("");
        aplicarDataTableSimple("#tblMateriaPrima");
        $("#txtTotalSolicitud").val(0.00);
    }

    $("#btnDetalles").fancybox({
        width: '90%',
        height: '100%',
        autoSize: false,
        type: 'inline',
        beforeLoad: function () {
            var producto    = $("#slcProducto").val();
            var orden       = $("#hdnOrden").val();
            var bodega      = ($("#slcBodega").val() != '') ? $("#slcBodega").val() : '';
            var tipo        = $("#slcTipo").val();
            var existentes  = '';
            var etapa       = $("#slcEtapa").val();
              $("#dvProductos").html('');

            if ($(".dvDetalle").length > 0) {
                existentes = $(".dvDetalle").map(function () {
                    return $(this).data('id');
                }).get().join();
            }

            if ( bodega == "" && tipo == 1 ) {
                crear_alerta("error","Solicitud de materiales", "Bodega es requerida.");
                return false;
            }

            if (tipo == 2 ) {
                bodega = "";
            }

            if ( tipo == "" ) {
                crear_alerta("error","Solicitud de materiales", "Tipo es requerido.");
                return false;
            }

            $.ajax({
                url: urlj + 'proyectos/procesos/get_detalles_materia_prima',
                type: 'post',
                data: {producto: producto, orden: orden, existentes: existentes, bodega: bodega, etapa: etapa, tipo:tipo},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    $("#dvProductos").append(data.trim());
                    var producto = $("#slcProducto").val();
                    if (producto != '') {
                        $(".dvDetalle").hide();
                        $("#tr_" + producto).show();
                    } else {
                        $(".dvDetalle").show();
                    }
                }
            });
        }
    });

    //Traslado de materia prima a grid general
    $("body").on('click', '.btnTrasladarMt', function () {
        var trPadre = $(this).parent().parent();
        trasladarMt(trPadre);
        calcularTotal(trPadre);
    });

    $("body").on('click', '.trasladar_all', function () {
        var id_tabla =  $(this).parent().parent();
        alerta_confirm_ajax(trasladar_todo, id_tabla,"Alerta confirmación","Esta seguro que quiere agregar todas las materias prima?");
    })

    function trasladar_todo(id_tabla){
        $(id_tabla).find('table.modal_materias .btnTrasladarMt').each(function(){
            var trPadre = $(this).parent().parent();
            trasladarMt(trPadre);
            calcularTotal(trPadre);
        })
        //verificamos cuantas tablas hay y la comparamos si hay un td con la clase empty, si hay 2 td empty y 2 tablas cierra el modal
        var tables_empty = $(".modal_materias").find('tbody tr td.dataTables_empty').length;
        var tables = $(".modal_materias").length;
        if(tables_empty == tables){
            $.fancybox.close();
        }
    }

    function trasladarMt(trPadre){
        var dataProd = $("#" + trPadre[0].id).data('prod');
        var dataId = $("#" + trPadre[0].id).data('id');
        //console.log(trPadre);
        var trHtml = trPadre[0].outerHTML;

        var oTable = $('#tblMateriaPrima').dataTable();
        //Se agrega el registro a trasladar
        oTable.fnDestroy();
        $("#tbMateriaPrima").append(trHtml);
        $("#tbMateriaPrima #trMat_" + dataId + ' .tdSolicitar').show();
        $("#tbMateriaPrima #trMat_" + dataId + ' .btnTrasladarMt').hide();
        $("#tbMateriaPrima #trMat_" + dataId + ' .btnRegresarMt').show();
        aplicarDataTable('#tblMateriaPrima');

        //Se quita de la tabla el registro trasladado
        var oTable = $("#tblMateria_" + dataProd).dataTable();
        oTable.fnDeleteRow(trPadre[0]);
        oTable.fnDestroy();
        aplicarDataTableSimple("#tblMateria_" + dataProd);
    }

    //Traslado de materia prima a grid general
    $("body").on('click', '.btnRegresarMt', function () {
        var trPadre = $(this).parent().parent();
        var dataProd = $("#" + trPadre[0].id).data('prod');
        var dataId = $("#" + trPadre[0].id).data('id');
        //console.log(trPadre);
        var trHtml = trPadre[0].outerHTML;

        var oTablePrincipal = $('#tblMateriaPrima').dataTable();
        //Se agrega el registro a regresar
        oTablePrincipal.fnDeleteRow(trPadre[0]);
        oTablePrincipal.fnDestroy();
        aplicarDataTable('#tblMateriaPrima');


        var oTableMateria = $("#tblMateria_" + dataProd).dataTable();
        oTableMateria.fnDestroy();
        $("#tbMateria_" + dataProd).append(trHtml);
        $("#tbMateria_" + dataProd + " #trMat_" + dataId + ' .tdSolicitar').hide();
        $("#tbMateria_" + dataProd + " #trMat_" + dataId + ' .btnTrasladarMt').show();
        $("#tbMateria_" + dataProd + " #trMat_" + dataId + ' .btnRegresarMt').hide();
        aplicarDataTableSimple("#tblMateria_" + dataProd);
        calcularTotal();
    });

    $("#btnProcesar, #btnAutorizar").click(function () {
        var formulario = $("#frm-solicitud");
        //$(this.element[0]).attr('data-etiqueta');
        var tipoSolicitud = $("#slcTipo option:selected").text();
        formulario.validate();
        var totalProductos = $("#txtTotalSolicitud").val();
        if (!formulario.valid()) {
            return false;
        }
        if ($('#tbMateriaPrima .trMateriaPrima').length === 0) {
            crear_alerta('error', 'Solicitud de Materiales', 'Debe seleccionar ingresar al menos un registro.');
            return false;
        }


        var errores = 0;
        $("#tbMateriaPrima > tr .solicitadoMt").each(function () {
            var cantidad = $(this).val();
            if (!(cantidad > 0)) {
                errores++;
            }
        });

        if (errores > 0) {
            crear_alerta('error', 'Solicitud de Materiales', 'Debe completar todos materiales solicitados.\nVerifique las cantidades solicitadas');
            return false;
        }

        var superiores = 0;
        $("#tbMateriaPrima > tr").each(function () {
            var cantidad = parseFloat($(this).find('.solicitadoMt').val());
            //  var pendiente = parseFloat($(this).find('.pendienteMt').val());
            var solicitado = parseFloat($(this).find('.soliAcumulado').val());
            var totalOrden = parseFloat($(this).find('.cantidadMt').val());
            var totalPendiente = solicitado + cantidad;
            //  console.log(cantidad.toFixed(2) + " " + totalOrden.toFixed(2) + " "+ (cantidad - totalPendiente).toFixed(2) );
            if (parseFloat(totalOrden) < parseFloat(totalPendiente)) {
                superiores++;
            }
        });

        var tipo = $("#slcTipo").val();
        if (tipo == 1) {
            var bodega = $("#slcBodega").val();
            if (bodega == '') {
                crear_alerta('error', 'Solicitud de Materiales', 'Debe especificar una bodega.');
                return false;
            }
        }

        if (superiores > 0) {
            crear_alerta('warning', 'Solicitud de Materiales', 'Las cantidades de materiales solicitados excede al presupuesto.');
            // return false;
            alerta_confirm_ajax(ejecutarFormulario, 1, 'Alerta de Confirmación', 'Estas seguro de generar una solicitud del tipo <b>' + tipoSolicitud + '</b> con un total de <b>' + totalProductos + '</b> productos. (<b>La cantidad de materiales solicitados excede al presupuesto<b/>) ¿Desea generar la solicitud?');
        } else if ($("#tbMateriaPrima > tr .error").length > 0) {
            crear_alerta('error', 'Solicitud de Materiales', 'Debe verificar las cantidades a solicitar.');
            return false;
        } else {
            alerta_confirm_ajax(ejecutarFormulario, '', 'Alerta de Confirmación', 'Estas seguro de generar una solicitud del tipo <b>' + tipoSolicitud + '</b> con un total de <b>' + totalProductos + '</b> productos.<br /> ¿Desea generar la solicitud?');
        }
        //alerta_confirm_ajax(enviarFormulario, '', 'Alerta de Confirmación', 'La cantidad de materiales solicitada excede al presupuesto.<br /> ¿Éstas seguro de continuar?');

    });

    $("body").on('keyup', '.solicitadoMt', function () {
        var cantidadSolicitada = parseFloat($(this).val());
        if (cantidadSolicitada > 0 && cantidadSolicitada != '') {
            var trParent = $(this).parent().parent();

            //var totalDespachado = parseFloat($("#" + trParent[0].id).find('.despachadoMt').val());
            var solicitado = parseFloat($("#" + trParent[0].id).find('.soliAcumulado').val());
            var totalOrden = parseFloat($("#" + trParent[0].id).find('.cantidadMt').val());
            var totalPendiente = totalOrden - solicitado;
          //  console.log(totalPendiente);
            if (cantidadSolicitada > totalPendiente) {
                $(this).addClass('error');
            } else {
                $(this).removeClass('error');
            }

            //var nuevoPendiente = totalPendiente - cantidadSolicitada;

            //$("#" + trParent[0].id).find('.pendienteMt').val(number_format(nuevoPendiente,2));
            calcularTotal();
      // $(this).attr('value', cantidadSolicitada);
        } else {
            $(this).addClass('error');
        }
    });
});

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function ejecutarFormulario(actualizar_costeo = 0) {
    if (actualizar_costeo > 0) {
        var excede = 0;
        $("#tbMateriaPrima > tr").each(function () {
            var cantidad = parseFloat($(this).find('.solicitadoMt').val());
            var solicitado = parseFloat($(this).find('.soliAcumulado').val());
            var totalOrden = parseFloat($(this).find('.cantidadMt').val());
            var existencia = parseFloat($(this).find('.existMt').val());
            var totalPendiente = solicitado + cantidad;
            var mat_prim = $(this).find('.artMat').val();
            console.log(cantidad);
            if (cantidad > existencia) {
                excede++;
            }
            if (parseFloat(totalOrden) < parseFloat(totalPendiente)) {
                $('#modifica_costeo_'+mat_prim).val(1);
                $('#modifica_ctdad_'+mat_prim).val(totalPendiente);
            }
        });
        console.log(excede);
        if (excede > 0) {
            crear_alerta('error','Atención','No debe sobrepasar las existencias totales');
            return false;
        } else {
            $("#frm-solicitud").submit();
        }
    } else {
        $("#frm-solicitud").submit();
    }
}

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
    });
}

function aplicarDataTableSimple(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}

function calcularTotal() {
    var montoTotal = 0;
    $("#tbMateriaPrima tr").each(function () {
        var idData = $(this).data('id');
      //  console.log(idData);
        var monto = $("#txtSolicitada_" + idData).val();
        if (monto != '') {
            montoTotal += parseFloat(monto);
        }
    });
   //console.log("se calculo total"+ montoTotal);
    $("#txtTotalSolicitud").val(number_format(montoTotal, 2));
}

function enviarFormulario() {
    $("#frm-solicitud").submit();
}

function selectEtapasProducto(idproducto, idorden){
    $.ajax({
        url: urlj + 'proyectos/procesos/get_etapas_producto_solicitud_materiales',
        type: 'post',
        data: {idproducto: idproducto, idorden: idorden},
        beforeSend: function () {
            wait.start();
        },
        success: function (data) {
            wait.close();
            $("#slcEtapa").html(data);            
        }
    });
}