$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $('select').select2({placeholder: 'Seleccione una opción'});
    $('.slcProducto').select2('destroy');
    $(".soloNumeros").numeric();
    $(".btn-close").live('click', function () {
        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    if ( $("#edit_lop").length > 0 ) {
        cantidades_restantes( parseFloat( $("#txtCantidadTotal").val() ) , $("#slcProducto").val() );
    }

    $("#frm-lotes").validate({
        ignore: [],
        rules: {
            slcProducto: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#tbProductos .trProducto').length == 0) {
                wait.close();
                crear_alerta('error', 'Lotes', 'Debe ingresar al menos un lote.');
                return false;
            }
            var totalLotes = number_format($("#txtTotalLotes").val(), 2, '.', '' );
            var totalProducto = number_format($("#txtCantidadTotal").val(), 2, '.', '' );

            if (totalLotes != totalProducto) {
                wait.close();
                crear_alerta('error', 'Lotes', 'La suma de productos por lote debe corresponder a la cantidad total (' + number_format(totalProducto, 2) + ').');
                return false;
            }
            form.submit();
        }
    });

    $("#slcProducto").change(function (event) {
        event.preventDefault();
        var producto = $(this).val();
        var anteriorSelected = $("#hdnSelectProducto").val();

        if ($("#tbProductos .trProducto").length > 0) {
            if (anteriorSelected != producto) {
                alerta_confirm_ajax(limpiarTabla, producto, 'Alerta de Confirmación', "Si cambia de producto, se eliminaran los lotes agregados.<br> ¿Éstas seguro que quieres cambiar de producto?");
            }

            $("#slcProducto option:selected").removeAttr('selected');
            $('#slcProducto option[value=' + anteriorSelected + ']').attr('selected', 'selected');
            $('#slcProducto').select2({placeholder: "Seleccione una opción"});
        }

        var cantidad = number_format($("#slcProducto option:selected").data('cantidad'), 2, '.', '');
        $("#txtCantidadTotal").val(cantidad);
        $("#hdnSelectProducto").val($(this).val());
        $("#txtCantidad").val(cantidad);
        
    });

    function cantidades_restantes(cantidad, producto){
        var contador = 0;
        $(".productos_reg").each(function(){
            var producto_select = $(this).val();
            if(producto_select == producto){
                var parent = $(this).parent().parent();
                var id_parent = $("#" + parent[0].id).data('id');
                var txtCantidad = $("#txtCantidad_" + id_parent).val();
                contador += parseFloat(txtCantidad);
            }
        });
        var diferencia = cantidad - contador;
        if (diferencia != 0) {
            $("#txtCantidad").val(diferencia);
        } else {
            $("#txtCantidad").val("");
        }
    }

    var row = 0;
    if ($('#tbProductos .trProducto').length > 0) {
        row = $("#tbProductos .trProducto").length;
    }
    $("#btnAgregar").click(function () {
        var txtNombreLote = $("#txtNombreLote").val();
        var txtCantidad = $("#txtCantidad").val();
        var slcProducto = $("#slcProducto").val();
        var slcProductoText = $("#slcProducto option:selected").text();
        //var slcProductoCantidad = $("#slcProducto option:selected").data('cantidad');

        if (txtNombreLote == '' || txtCantidad == '' || slcProducto == '') {
            crear_alerta('info', 'Lotes', 'Debe completar todos los campos. (Producto, Lote, Cantidad).');
            return false;
        }

        if ($(".loteProducto [value='" + txtNombreLote + "']").length > 0) {
            crear_alerta('error', 'Lotes', 'El nombre del lote debe ser único.');
            return false;
        }

        txtCantidad = parseFloat(txtCantidad);
        calcularTotal();
        var totalLotes = parseFloat($("#txtTotalLotes").val());
        var totalProducto = parseFloat($("#txtCantidadTotal").val());
        totalLoteNuevo = totalLotes + txtCantidad;

        if (totalLoteNuevo > totalProducto) {
            crear_alerta('error', 'Lotes', 'La cantidad de productos por lote debe corresponder a la cantidad total (' + number_format(totalProducto, 2) + ').');
            return false;
        }

        var slcProductoHtml = getOpcionesSelect("slcProducto");
        var slcSucursalHtml = getOpcionesSelect("slcSucursal");

        slcProductoHtml = slcProductoHtml.replace(/"/g, "'");
        slcSucursalHtml = slcSucursalHtml.replace(/"/g, "'");

        var html = '';

        html += '<tr id="tr_' + row + '" class="trProducto" data-id="' + row + '">';

        html += '<td>';
        html += '<input type="hidden" name="hdnDetalle[]" class="tables-input" value="0" />';
        html += '<input type="hidden" class="productos_reg" value="'+slcProducto+'" />';
        html += '<input type="text" class="text tables-input" value="' + $.trim(slcProductoText) + '" readonly="readonly"/>';
        html += '<select id="slcProducto_' + row + '" data-id="' + row + '" name="productos[]" style="display:none;" class="slcProducto">' + slcProductoHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtNombreLote_' + row + '" name="nombreLotes[]" class="loteProducto text tables-input-show tables-input" value="' + txtNombreLote + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidad_' + row + '" name="cantidades[]" class="text tables-input-show tables-input cantidadProducto soloNumeros" extras="." value="' + number_format(txtCantidad,2,'.','') + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;">Guardar</button>';
        html += '<button type="button" class="btn btn-primary btn-mini btnEditProd" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;">Editar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelProd" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button>';
        html += '</td>';

        html += '</tr>';

        var oTable = $('#tblProductos').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbProductos").append(html);
        aplicarDataTable('#tblProductos');
        row = row + 1;
        calcularTotal();

        $("#txtNombreLote").val('');
        $("#txtCantidad").val('');
        var cantidad_total = parseFloat($("#txtCantidadTotal").val())
        cantidades_restantes(cantidad_total, slcProducto);
    });//En of function agregar

    $(".btnEditProd").live('click', function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id + " .select-text").hide();

        $("#" + parent[0].id + " .select-edit").select2({placeholder: "Seleccione una opción"});
        $("#" + parent[0].id + " .select2-container").css('width', '100%');
        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarProd").show();
    });

    //Guardar
    $(".btnGuardarProd").live('click', function () {
        var parent = $(this).parent().parent();

        var id_parent = $("#" + parent[0].id).data('id');

        var txtNombreLote = $("#txtNombreLote_" + id_parent).val();
        var txtCantidad = $("#txtCantidad_" + id_parent).val();

        if (txtNombreLote == '' || txtCantidad == '') {
            crear_alerta('error', 'Lotes', 'Debe completar los campos requeridos. (Lote, Cantidad).');
            return false;
        }

        var existe = 0;
        $("#tbProductos .trProducto").each(function () {
            var dataId = $(this).attr('data-id');
            var LoteExistente = $(this).find('.loteProducto').val();
            if (id_parent != dataId) {
                if (LoteExistente == txtNombreLote) {
                    existe = 1;
                }
            }
        });

        if (existe > 0) {
            crear_alerta('error', 'Lotes', 'El nombre del lote debe ser único.');
            return false;
        }
        calcularTotal();
        var totalLotes = parseFloat($("#txtTotalLotes").val());
        var totalProducto = parseFloat($("#txtCantidadTotal").val());

        if (totalLotes > totalProducto) {
            crear_alerta('error', 'Lotes', 'La cantidad total de lotes no puede superar a la cantidad del producto (' + number_format(totalProducto, 2) + ').');
            return false;
        }

        $("#" + parent[0].id + " .select-edit").each(function () {
            var select_id = $(this).attr('id');
            var valor = $("#" + select_id).val();
            var text = $("#" + select_id + " option:selected").text();
            if (valor != '') {
                $("#" + select_id).prev().val(text);
            } else {
                $("#" + select_id).prev().val('');
            }
            $("#" + select_id).prev().show();
        });
        cantidades_restantes(totalProducto, $("#slcProducto").val());
        $("#" + parent[0].id + " .select-edit").select2('destroy');
        $("#" + parent[0].id + " .select-edit").hide();

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditProd").show();
    });


    //Eliminar Producto
    $(".btnDelProd").live("click", function () {
        var parent = $(this).parent().parent();
        var oTable = $('#tblProductos').dataTable();
        oTable.fnDeleteRow(parent[0]);
        calcularTotal();
        cantidades_restantes( parseFloat( $("#txtCantidadTotal").val() ) , $("#slcProducto").val() );
    });
});

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function cerrar_modal() {
    //alert('asdasd');
    jQuery.fancybox.close();
}

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": true,
        "bInfo": true,
        "bSort": false,
        "bLengthChange": false,
        "bFilter": false
    });
}

function limpiarTabla(producto) {
    $("#hdnSelectProducto").val(producto);
    $('#slcProducto option[value=' + $("#hdnSelectProducto").val() + ']').attr('selected', 'selected');
    $('#slcProducto').select2({placeholder: "Seleccione una opción"});
    var cantidad = $("#slcProducto option:selected").data('cantidad');
    $("#txtCantidadTotal").val(number_format(cantidad, 2));
    var oTable = $('#tblProductos').dataTable();
    //Se destruye el datatable para luego volver a crearla
    oTable.fnDestroy();

    $("#tbProductos").html('');
    aplicarDataTable('#tblProductos');
}

function calcularTotal() {
    var totalLotes = 0;
    $("#tbProductos .trProducto").each(function () {
        var cantidad = parseFloat($(this).find('.cantidadProducto').val());
        totalLotes += cantidad;
    });
    $("#txtTotalLotes").val(number_format(totalLotes, 2));
}