var row = 0;
$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;

    if ($('#tblEtapas .trEtapas').length > 0) {
        row = $("#tblEtapas .trEtapas").length;
    }

    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $('select').select2({placeholder: 'Seleccione una opción'});
    $('.slcProducto').select2('destroy');
    $(".soloNumeros").numeric();
    $(".btn-close").live('click', function () {
        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    $("#frm-lotes").validate({
        ignore: [],
        rules: {
            slcProducto: {required: true},
            slcLotes: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#tblEtapas .trEtapas').length == 0) {
                crear_alerta('error', 'Etapas de Producción', 'Debe ingrear al menos una etapa.');
                return false;
            }

            if ($(".etapaFinal[value='1']").length == 0) {
                crear_alerta('error', 'Etapas de Producción', 'Debe agregar una etapa final en el listado.');
                return false;
            }

            var error = 0;
            $(".duracionEtapa").each(function () {
                if ($(this).val() == '') {
                    error++;
                }
            });

            $(".duracionEtapaMod").each(function () {
                if ($(this).val() == '') {
                    error++;
                }
            });

            if (error > 0) {
                crear_alerta('error', 'Etapas de Producción', 'Debe asignar una cantidad de horas a cada etapa.');
                return false;
            }

            form.submit();
        }
    });

    $("#slcProducto").change(function (event) {
        event.preventDefault();
        var producto = $(this).val();
        var anteriorSelected = $("#hdnSelectProduccion").val();

        if ($('#tblEtapas .trEtapas').length > 0) {
            if (anteriorSelected != producto) {
                alerta_confirm_ajax(limpiarTabla, producto, 'Alerta de Confirmación', "Si cambia de producto, se eliminaran las etapas agregadas.<br> ¿Está seguro que quiere cambiar de producto?");
            } else {
                if (producto != '') {
                    cargarDetallesProducto(producto);
                }
            }
            $('#slcProduccion option[value=' + $("#hdnSelectProducto").val() + ']').attr('selected', 'selected');
            $('#slcProduccion').select2({placeholder: "Seleccione una opción"});
        } else {
            if (producto != '') {
                cargarDetallesProducto(producto);
            }
        }
        $("#hdnSelectProduccion").val($(this).val());
    });

    $("#chkFinaliza").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnFinaliza").val(1);
            } else {
                $("#hdnFinaliza").val(0);
            }
        }
    });

    $("#slcEtapas").change(function(){
        var duracionHoras = "";
        if($(this).val() > 0){
            var duracionHoras = $("#slcEtapas option:selected").data('horas');
            if ( typeof duracionHoras == 'undefined') {
              duracionHoras = '';
            }
        }
        $("#txtTiempoProceso").val(duracionHoras);
        $("#txtTiempoMod").val(duracionHoras);
    });

    $("#btnAgregar").click(function () {        
        var slcLotes = $("#slcLotes").val();
        var slcEtapas = $("#slcEtapas").val();
        var duracionHoras = ($("#txtTiempoProceso").val() == '') ? '0': $("#txtTiempoProceso").val();
        var duracionHorasMod = ($("#txtTiempoMod").val() == '') ? '0': $("#txtTiempoMod").val();
        //var duracionHoras = $("#slcEtapas option:selected").data('horas');
        
        // if ( typeof duracionHoras == 'undefined') {
        //   duracionHoras = '';
        // }
        


        $("#txtTiempoProceso").val(duracionHoras);
        $("#txtTiempoMod").val(duracionHoras);


        var slcEtapasText = $("#slcEtapas option:selected").text();
        var slcEtapasBodega = $("#slcEtapas option:selected").data('bodega');

        var slcEtapasBodegaNombre = $("#slcEtapas option:selected").data('bodega-nombre');
        var slcEtapasSector = $("#slcEtapas option:selected").data('sector');

        if($.trim(slcEtapasSector) != ''){
            slcEtapasBodegaNombre = slcEtapasBodegaNombre + ' - ' + slcEtapasSector;
        }
        var etapaFinal = (slcEtapasBodega != '') ? 1 : $("#hdnFinaliza").val();
        var dragClass = (slcEtapasBodega != '') ? '' : 'dragHandle showDragHandle';

        if (slcLotes == '' || slcEtapas == '') {
            crear_alerta('info', 'Lotes', 'Debe completar todos los campos. (Producto, Lote, Etapa).');
            return false;
        }
        numEtapas = $("#tbEtapas .trEtapas").length;
        var numOrden = numEtapas + 1;
        var finalizaJob = (etapaFinal == 1 || slcEtapasBodega != '') ? "X" : "";
        var classSort = (finalizaJob == "X") ? "nodrop" : "moverFila";

        if ($(".etapaFinal[value='1']").length > 0 && finalizaJob != "") {
            crear_alerta('info', 'Etapas de Producción', 'Solo puede haber una etapa de finalización.');
            return false;
        }

        if ($(".numEtapa[value='" + slcEtapas + "']").length > 0) {
            crear_alerta('info', 'Etapas de Producción', 'La etapa ya fue ingresada.');
            return false;
        }

        var html = '';

        html += '<tr id="tr_' + row + '" class="trEtapas ' + classSort + '" data-id="' + row + '">';
        html += '<td>';
        html += '<input type="hidden" name="hdnDetalle[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input ordenFila" id="txtOrden_' + row + '" name="numOrden[]" value="' + numOrden + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="hidden" id="slcEtapas_' + row + '" name="etapas[]" class="numEtapa tables-input" value="' + slcEtapas + '" />';
        html += '<input type="text" class="text tables-input nombreEtapa" value="' + slcEtapasText + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtDuracion_' + row + '" name="duraciones[]" class="duracionEtapa text tables-input-show soloDecimales" value="'+duracionHoras+'"/>';
        html += '</td>';
        html += '<td>';
        html += '<input type="text" id="txtDuracionMod_' + row + '" name="duracionesMod[]" class="duracionEtapaMod text tables-input-show soloDecimales" value="'+duracionHorasMod+'"/>';
        html += '</td>';

        html += '<td style="text-align: center;">';
        html += '<input type="hidden" name="hdnFinaliza[]" class="tables-input etapaFinal" value="' + etapaFinal + '" />';
        html += '<label id="lblFinaliza_' + row + '">' + finalizaJob + '</label>';
        html += '</td>';

        html += '<td>';
        html += '<label class="text tables-input bodegaFila"> ' + slcEtapasBodegaNombre + '</label>';
        html += '</td>';

        html += '<td>';
        html += '<textarea id="txtComentario_' + row + '" name="comentarios[]" class="comentariosEtapa"></textarea>';
        html += '</td>';

        html += '<td class="" style="text-align: center;">';
        if (etapaFinal != 1) {
            //html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd btnTable moveRow" value="up"><span class="icomoon-icon-arrow-up-7"></button>';
            html += '<button type="button" class="btn btn dragHandle showDragHandle btnTable" value="down"></button>';
        }
        html += '<button type="button" class="btn btn-danger btn-mini btnDelProd btnTable"><span class="white icomoon-icon-remove"></button>';
        html += '</td>';

        html += '</tr>';

        //Se destruye el datatable para luego volver a crearla
        //var oTable = $('#tblEtapas').dataTable();
        //oTable.fnDestroy();
        if ($("#tblEtapas .trEtapas").length == 0) {
            $("#tbEtapas").html('');
        }

        if ($(".nodrop").length > 0) {
            //$("#tbEtapas").append(html);
            $(html).insertBefore(".nodrop");
        } else {
            $("#tbEtapas").append(html);
        }


        //aplicarDataTable('#tblEtapas');
        row = row + 1;

        $("#slcEtapas option:selected").removeAttr('selected');
        $("#slcEtapas").select2({placeholder: "Seleccione una opción"});
        $("#txtCantidad").val('');

        $("#tblEtapas").tableDnD({
            dragHandle: ".dragHandle",
            onDragClass: "dragContent",
            onDrop: function (table, row) {
                calcularOrden();
            }
        });
        calcularOrden();
    });//En of function agregar


    //Eliminar Producto
    $("body").on('click', '.btnDelProd', function () {
        var parent = $(this).parent().parent();
        //var oTable = $('#tblEtapas').dataTable();
        //oTable.fnDeleteRow(parent[0]);
        //calcularTotal();
        $("#" + parent[0].id).remove().delay(300);
        calcularOrden();
    });

    $("body").on('click', '.moveRow', function () {
        var direccion = $(this).val();
        var trParent = $(this).parent().parent();
    });
    $("body").on('click', '.up,.down', function () {
        //$(".up,.down").click(function () {

        var $element = this;
        var row = $($element).parents("tr:first");

        if ($(this).val() == 'up') {
            row.insertBefore(row.prev());
        } else {
            row.insertAfter(row.next());
        }

    });
});

function cargarDetallesProducto(producto) {
    $.ajax({
        url: urlj + 'proyectos/procesos/get_info_producto_orden',
        data: {producto: producto, lotes_etapa: 1},
        type: 'post',
        dataType: "json",
        beforeSend: function () {
            wait.start('Espere un momento por favor... Buscando información del producto.');
        },
        success: function (data) {
            wait.close();
            $("#slcLotes").html(data.lotes);
            $("#slcLotes").select2({placeholder: "Seleccione una opción"});

            if (data.etapas != '') {
                $("#tbEtapas").html(data.etapas);
                existe_bodega();
            }
            row = $("#tblEtapas .trEtapas").length;
            console.log(row);
        }
    });
}

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function cerrar_modal() {
    //alert('asdasd');
    jQuery.fancybox.close();
}

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
        "iDisplayLength": 20
    });
}

function limpiarTabla(producto) {
    $("#hdnSelectProducto").val(producto);
    $('#slcProduccion option[value=' + $("#hdnSelectProducto").val() + ']').attr('selected', 'selected');
    $('#slcProduccion').select2({placeholder: "Seleccione una opción"});
    $("#tblEtapas").html('<tr><td colspan="8">No se encontraron registros</td></tr>');
    cargarLotes(producto);
}

function calcularTotal() {
    var totalLotes = 0;

    $("#tbProductos .trProducto").each(function () {
        var cantidad = parseFloat($(this).find('.cantidadProducto').val());

        totalLotes += cantidad;
    });

    $("#txtTotalLotes").val(number_format(totalLotes, 2));
}

function calcularOrden() {
    var Orden = 1;
    $(".moverFila").each(function () {
        $(this).find('.ordenFila').val(Orden);
        Orden++;
    });

    $(".nodrop .ordenFila").val(Orden);
}

function existe_bodega() {
    var hay_bodega = 0;
    $(".bod_final").each(function () {
        var es_final = $(this).data('final');
        if ($(this).val() > 0 && es_final > 0) {
            hay_bodega++;
        }
    });
    if (!(hay_bodega > 0)) {
        crear_alerta('info', 'Atención', 'La Etapa Final no posee una bodega asignada.');
    }
}