$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});
    $(".soloNumeros").numeric();

    var cant_intocable = $("#cantidad_intocable").val();
    $(".btnCrear").click(function(event) {
        event.preventDefault();
        var cant_orden = parseFloat($("#ctdad_total_axo").val().replace(',', ''));
        var lastCont = $("#hdnultimo").data('cont');
        var bodega = $("#hdnbodega").val();
        var namebodega = $("#namebodega").val();
        var pres_total = $("#pres_total").val();
        var canti_programada = $("#txtCantidadTotal").val();
        var unidad_medida = $("#unidad_medida").val();
        var total_val_etp = 0;
        $('.cantidadActualEtapa').each(function(){
            total_val_etp += parseFloat($(this).val());
        })
        var esta_ctdad = parseFloat($("#txtCantidadActual_"+lastCont).val(),2) - cant_intocable;
        var proporcion = esta_ctdad / cant_orden;

        if($("#txtCantidadActual_"+lastCont).val() <= 0){
            $("#ingresoInv").val(0);
            $("#frm-lotes").submit();
        }else if($("#txtCantidadActual_"+lastCont).val() > 0 && $("#ingresoInv").val() == 0){
            if(total_val_etp <= $("#txtCantidadTotal").val()){
                if((total_val_etp - cant_intocable) > 0 && (parseFloat($("#txtCantidadActual_"+lastCont).val()) - cant_intocable) == 0) {
                   $("#ingresoInv").val(0);
                    $("#frm-lotes").submit(); 
                } else if($("#txtCantidadActual_"+lastCont).val() == cant_intocable){
                    crear_alerta('warning', 'Alerta', 'La cantidad en la última etapa ya ha sido ingresada.');
                } else{
                    // if(bodega>0){
                    //     var aplica=1;
                    //     var mensaje= "Se realizará una entrada a la bodega \""+namebodega+"\" de inventario, para la cantidad en la etapa final.<br> Nota: Si selecciona cancelar, deberá hacer una entrada manual a inventario. ¿Éstas seguro de continuar?";
                    // }else{
                    //     var aplica=0;
                    //     var mensaje= "La etapa final no posee bodega asignada, por lo que no se realizará entrada a inventario.<br> Deberá hacer una entrada manual. ¿Éstas seguro de continuar?";
                    //     $("#ingresoInv").val(2);
                    // }
                    // alerta_confirm_ajax(ingreso_inv, aplica, 'Alerta de Confirmación', mensaje);
                    if (!($("#existe_bod").val() > 0)) {
                        $("#btnguardar").attr("disabled", true);
                        crear_alerta('error', 'Atención', 'La etapa final no tiene una bodega asignada.');
                    } else if (!(pres_total > 0)) {
                        $("#btnguardar").attr("disabled", true);
                        crear_alerta('error', 'Atención', 'Verifique el costeo total de la orden.');
                    } else {
                        $('#btnguardar').removeAttr("disabled");
                        
                    }
                    $.fancybox({
                        href: $(this).attr("href"),
                        'scrolling': 'no',
                        'titleShow': false,
                        'width': '70%',
                        closeBtn: false,
                        helpers: {
                            overlay: {closeClick: false}
                        },
                    });
                    $("#cant_programada").val(canti_programada);
                    $("#cant_real").val(esta_ctdad);
                    $("#unidad_medida_lavel").val(unidad_medida);
                    $("#cant_total").val(number_format((pres_total * proporcion), numero_decimales, '.', ''));
                    $("#cant_unitaria").val(number_format(((pres_total * proporcion) / esta_ctdad), numero_decimales, '.', ''));
                    $("#bode_entrada").val(namebodega);
                    $("#tipo_guardar").val($(this).val());
                    return false;
                }
            } else{
                crear_alerta('warning', 'Alerta', 'La cantidad de entradas por etapa no puede superar la cantidad total.');
            }
        }
    });

    $("#btnguardar").click(function () {
        wait.start()
        $.fancybox.close();
        var bodega = $("#hdnbodega").val();
        if (bodega > 0) {
            var aplica = 1;
        } else {
            var aplica = 0;
            $("#ingresoInv").val(2);
        }
        setTimeout(function () {
            ingreso_inv(aplica);
        }, 1000);
    });

    $("#cant_real").keyup(function () {
        var cantidad = $(this).val();
        var precio = $("#cant_total").val();
        console.log(cantidad);
        console.log(precio);
        console.log(precio / cantidad);
        $("#cant_unitaria").val(number_format(precio / cantidad, numero_decimales, '.', ''));
    });

    $("#cant_real").blur(function () {
        if ($(this).val() <= 0) {
            crear_alerta('warning', 'Alerta', 'la cantidad no puede ser menor o igual a 0');
            var cantidad = $("#cant_programada").val();
            var precio = $("#cant_total").val();
            $(this).val(cantidad);
            $("#cant_unitaria").val(number_format(precio / cantidad, numero_decimales, '.', ''));
        }
    });

    $(".ui-dialog-buttonset button:last").live('click',function() {
        if($("#ingresoInv").val()<2){
            $("#ingresoInv").val(0);
            $("#frm-lotes").submit();
        }else{
            $("#ingresoInv").val(0);
        }
    });

    $("#frm-lotes").validate({
        ignore: [],
        rules: {
            slcProducto: {required: true},
            slcLotes: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            var etapaInicial = $("#tbEtapas tr:first").data('prod');
            var totalEtapaInicial = getTotalEtapa(etapaInicial, '.nonOrigen');
            var etapafinal = $("#hdnultimo").val();

            if (totalEtapaInicial < 1) {
                crear_alerta('error', 'Número de Entradas', 'La cantidad de entrada debe ser mayor a cero.');
                return false;
            }

            if ($("#tbEtapas tr:first .cantidadActualEtapa").val() === '') {
                //crear_alerta('error', 'Etapas de Producción', 'Debe ingresar al menos una entrada.');
                //return false;
            }

            var error = 0;
            $(".duracionEtapa").each(function () {
                if ($(this).val() == '') {
                    error++;
                }
            });

            $(".duracionEtapaMod").each(function () {
                if ($(this).val() == '') {
                    error++;
                }
            });

            if (error > 0) {
                crear_alerta('error', 'Etapas de Producción', 'Debe asignar una cantidad de horas a cada etapa.');
                return false;
            }

            form.submit();
        }
    });
    $("#btnAgregar").click(function () {
        var cantidadEntrada = ($("#txtCantidad").val() != '') ? parseFloat($("#txtCantidad").val()) : 0;
        var cantidadTotal = $("#txtCantidadTotal").val();
        var etapaInicial = $("#tbEtapas tr:first").data('prod');
        var totalEtapaInicial = 0;//getTotalEtapa(etapaInicial, '.nonOrigen');
        var cantidad_etapa = 0;
        $(".cantidadActualEtapa").each(function(){
            if($.trim($(this).val()) != ""){
                cantidad_etapa += parseFloat($(this).val());
            }
        })

        $("#tbMovimientos_" + etapaInicial + " .nonOrigen").each(function () {
            var cantidadEntrada = $(this).find('.cantidadDetalleEtapa').val();

            var fechaSalida = $(this).find('.horaSalidaDetalle').val();
            if (fechaSalida == '') {
                totalEtapaInicial += parseFloat(cantidadEntrada);
            }
        });

        var nuevoTotal = cantidadEntrada + totalEtapaInicial;
        if (cantidadEntrada < 1) {
            crear_alerta('error', 'Número de Entradas', 'La cantidad de entrada debe ser mayor a cero.');
            return false;
        }

        if ((totalEtapaInicial == cantidadTotal) || nuevoTotal > cantidadTotal) {
            crear_alerta('error', 'Número de Entradas', 'La cantidad de entradas por etapa no puede superar la cantidad total (' + cantidadTotal + ').');
            return false;
        }
        console.log(cantidad_etapa + cantidadEntrada);
        console.log($("#txtCantidadTotal").val());
        
        
        if(!(parseFloat((cantidad_etapa + cantidadEntrada),2) <= parseFloat($("#txtCantidadTotal").val()))){
            crear_alerta('error', 'Número de Entradas', 'La cantidad de entradas por etapa no puede superar la cantidad total (' + cantidadTotal + ').');
            return false;
        }

        var cantidadSinSalida = getTotalEtapa(etapaInicial, '.nonSalida');

        agregarEntrada(etapaInicial, cantidadEntrada, '', '');
        $("#txtCantidad").val('');
        var totalEtapa = getTotalEtapa(etapaInicial);
        var newValor = number_format((cantidadSinSalida + cantidadEntrada),2, '.', '');
        newValor = newValor.replace(',','');
        $("#tbEtapas tr:first .cantidadActualEtapa").val(newValor);
    });

    $('body').on('click', '.btnTrasladar', function () {
        var total_lote = $("#txtCantidadTotal").val();
        var trParent = $(this).parent().parent().parent();
        var idTr = trParent[0].id;
        var dataId = $("#" + idTr).data('id');
        var dataEtp = $("#" + idTr).data('prod');
        var totalEtapa = getTotalEtapa(dataEtp, '.nonOrigen');
        var cantidadActual = $("#" + idTr).find('.cantidadActualEtapa').val();
        if (totalEtapa == 0 && (parseFloat(cantidadActual, 2) == parseFloat(0, 2) || cantidadActual == '')) {
            crear_alerta('info', 'Traslado', 'Debe generar una entrada primero antes de realizar un traslado.');
            return false;
        }
        var cantidad_etapa = 0;
        var ctdad_entrada_ini = ($("#txtCantidad").val() != '') ? parseFloat($("#txtCantidad").val()) : 0;
        $(".cantidadActualEtapa").each(function(){
            if($.trim($(this).val()) != ""){
                cantidad_etapa += parseFloat($(this).val());
            }
        });
        var nuevoTotal = cantidad_etapa + ctdad_entrada_ini;
        if (parseFloat(nuevoTotal, 2) > parseFloat(total_lote, 2)) {
            crear_alerta('warning', 'Traslado', 'Suma de la cantidad es mayor que el total del lote.');
            return false;
        }
        if (parseFloat(cantidadActual, 2) > parseFloat(total_lote, 2)) {
            crear_alerta('warning', 'Traslado', 'Traslado es mayor que la cantidad total del lote.');
            return false;
        }
        var trDestino = $("#" + idTr).next('tr');
        var idTrDestino = trDestino[0].id;
        var dataIdDestino = $("#" + idTrDestino).data('id');
        var dataEtpDestino = $("#" + idTrDestino).data('prod');
        
        generarSalidas(dataEtp, dataEtpDestino);
        agregarEntrada(dataEtpDestino, parseFloat(number_format(cantidadActual,2,".","")), '', dataEtp);

        var totalEtapaSinSalida = getTotalEtapa(dataEtpDestino, '.nonSalida');
        var nuevoTotalEtapa = parseFloat(totalEtapaSinSalida) + parseFloat(cantidadActual);

        var lastCont = $("#hdnultimo").data('cont');
        var cantidad_last_et = $("#txtCantidadActual_"+lastCont).val();
        var etapa_actual_id = $("#" + idTr).find('.cantidadActualEtapa').attr('id');
        var etapa_next_id = $("#" + idTrDestino).find('.cantidadActualEtapa').attr('id');
        if(etapa_next_id == "txtCantidadActual_"+lastCont){
            totalEtapaSinSalida = parseFloat(cantidadActual) + parseFloat(($.trim(cantidad_last_et) != ""?cantidad_last_et:0));
            totalEtapaSinSalida = number_format(parseFloat(totalEtapaSinSalida,2), 2, '.','');
            totalEtapaSinSalida = totalEtapaSinSalida.replace(',', '');
            $("#" + idTrDestino).find('.cantidadActualEtapa').val(totalEtapaSinSalida);
        } else{
            $("#" + idTrDestino).find('.cantidadActualEtapa').val(number_format(parseFloat(totalEtapaSinSalida,2), 2, '.', ''));
        }

        
        $("#" + idTr).find('.cantidadActualEtapa').val(number_format(0, 2));
    });

    $('body').on('click', '.btnRetornar', function () {
        var trParent = $(this).parent().parent().parent();
        //console.log(trParent);
        var idTr = trParent[0].id;
        var dataId = $("#" + idTr).data('id');
        var dataEtp = $("#" + idTr).data('prod');
        var totalEtapa = getTotalEtapa(dataEtp, '.nonSalida');
        var cantidadActual = $("#" + idTr).find('.cantidadActualEtapa').val();
        if (totalEtapa == 0 && (parseFloat(cantidadActual, 2) == parseFloat(0, 2) || cantidadActual == '')) {
            crear_alerta('info', 'Traslado', 'Debe generar una entrada primero antes de realizar la operación.');
            return false;
        }
        var cantidad_etapa = 0;
        var total_lote = $("#txtCantidadTotal").val();
        var ctdad_entrada_ini = ($("#txtCantidad").val() != '') ? parseFloat($("#txtCantidad").val()) : 0;
        $(".cantidadActualEtapa").each(function(){
            if($.trim($(this).val()) != ""){
                cantidad_etapa += parseFloat($(this).val());
            }
        });
        var nuevoTotal = cantidad_etapa + ctdad_entrada_ini;
        if (parseFloat(nuevoTotal, 2) > parseFloat(total_lote, 2)) {
            crear_alerta('warning', 'Retorno', 'Suma de la cantidad es mayor que el total del lote.');
            return false;
        }
        var trDestino = $("#" + idTr).prev('tr');
        if (trDestino.length > 0) {
            
            /*console.log(etapa_actual_id);
            console.log(lastCont);
            console.log(cantidad_last_et);*/

            var idTrDestino = trDestino[0].id;
            var dataIdDestino = $("#" + idTrDestino).data('id');
            var dataEtpDestino = $("#" + idTrDestino).data('prod');

            var cantidadActualDestino = $("#" + idTrDestino).find('.cantidadActualEtapa').val();

            var nuevaCantidad = 0;

            if (cantidadActualDestino != '') {
                nuevaCantidad = parseFloat(cantidadActualDestino) + parseFloat(cantidadActual);
            } else {
                nuevaCantidad = parseFloat(cantidadActual);
            }
            var lastCont = $("#hdnultimo").data('cont');
            var cantidad_last_et = $("#txtCantidadActual_"+lastCont).val();
            var etapa_actual_id = $("#" + idTr).find('.cantidadActualEtapa').attr('id');
            if(etapa_actual_id == "txtCantidadActual_"+lastCont){
                var cantidad_regresar = parseFloat(cantidad_last_et, 2) - parseFloat(cant_intocable,2);
                if(cantidad_regresar != 0){
                    generarSalidas(dataEtp, dataEtpDestino);
                    agregarEntrada(dataEtpDestino, parseFloat(cantidad_regresar), '', dataEtp);
                    $("#" + idTrDestino).find('.cantidadActualEtapa').val(number_format(cantidad_regresar, 2, '.', ''));
                }
                $("#" + idTr).find('.cantidadActualEtapa').val(cant_intocable);
                //console.log(cantidad_regresar);
            } else{
                generarSalidas(dataEtp, dataEtpDestino);
                agregarEntrada(dataEtpDestino, parseFloat(cantidadActual), '', dataEtp);
                $("#" + idTrDestino).find('.cantidadActualEtapa').val(number_format(nuevaCantidad, 2, '.', ''));
                $("#" + idTr).find('.cantidadActualEtapa').val(number_format(0,2));
            }

            
        } else {
            generarSalidas(dataEtp);
            $("#" + idTr).find('.cantidadActualEtapa').val(number_format(0,2));
        }
    });


    //Modal de Multiselects
    $(".btnDetalles").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
    });
});
function getTotalEtapa(dataEtapa, selectorRow = 'tr') {
    var totalEntradas = 0;
    $("#tbMovimientos_" + dataEtapa + " " + selectorRow).each(function () {
        var cantidadEntrada = $(this).find('.cantidadDetalleEtapa').val();
        totalEntradas += parseFloat(cantidadEntrada);
    });
    return totalEntradas;
}

function agregarEntrada(rowEtapa, cantidad, etapaDestino, etapaOrigen) {
    wait.start();
    var row = 0;
    if ($('#tbMovimientos_' + rowEtapa + ' .trDetalle').length > 0) {
        row = $('#tbMovimientos_' + rowEtapa + ' .trDetalle').length;
    }

    var fecha = new Date();
    var fechaEntradaFormat = formatearFecha(fecha, 'dd/mm/yy');
    var horaEntradaFormat = formatearHora(fecha);
    var fechaEntrada = fechaEntradaFormat + ' ' + horaEntradaFormat;
    var claseOrigen = (etapaOrigen === '') ? 'nonOrigen' : '';
    var html = '';
    html += '<tr id="trDetalle_' + row + '" data-etp="' + rowEtapa + '" data-id="' + row + '" class="trDetalle nonSalida ' + claseOrigen + '">';
    html += '<td>';
    html += '<input type="text" class="text tables-input cantidadDetalleEtapa" name="cantidadesDetalle_' + rowEtapa + '[]" id="txtCantidadDetalle_' + row + '" value="' + cantidad + '" readonly="readonly"/>';
    html += '<input type="hidden" class="etapaDestino" name="hdnEtapaDestino_' + rowEtapa + '[]" id="hdnEtapaDestino_' + row + '" value="' + etapaDestino + '"/>';
    html += '<input type="hidden" class="etapaOrigen" name="hdnEtapaOrigen_' + rowEtapa + '[]" id="hdnEtapaOrigen_' + row + '" value="' + etapaOrigen + '"/>';
    html += '</td>';
    html += '<td>';
    html += '<input type="hidden" class="fechaEntrada" name="hdnfechaEntrada_' + rowEtapa + '[]" id="hdnFechaEntrada_' + row + '" value="' + fechaEntrada + '"/>';
    html += '<input type="text" class="text tables-input fechaEntradaDetalle" id="txtFechaEntrada_' + row + '" value="' + fechaEntradaFormat + '" readonly="readonly"/>';
    html += '</td>';
    html += '<td>';
    html += '<input type="text" class="text tables-input horaEntradaDetalle" id="txtHoraEntrada_' + row + '" value="' + horaEntradaFormat + '" readonly="readonly"/>';
    html += '</td>';
    html += '<td>';
    html += '<input type="hidden" class="fechaSalida" name="hdnfechaSalida_' + rowEtapa + '[]" id="hdnFechaSalida_' + row + '" value=""/>';
    html += '<input type="text" class="text tables-input fechaSalidaDetalle" id="txtFechaSalida_' + row + '" value="" readonly="readonly"/>';
    html += '</td>';
    html += '<td>';
    html += '<input type="text" class="text tables-input horaSalidaDetalle" id="txtHoraSalida_' + row + '" value="" readonly="readonly"/>';
    html += '</td>';
    html += '</tr>';
    var oTable = $("#tblMovimientos_" + rowEtapa).dataTable();
    //Se destruye el datatable para luego volver a crearla
    oTable.fnDestroy();
    $("#tbMovimientos_" + rowEtapa).append(html);
    aplicarDataTable("#tblMovimientos_" + rowEtapa);
    $("#tblMovimientos_" + rowEtapa).css('width', '100%');
    wait.close();
}

function generarSalidas(rowEtapa, etapaDestino, etapaOrigen) {

    var fecha = new Date();
    var fechaSalidaFormat = formatearFecha(fecha, 'dd/mm/yy');
    var horaSalidaFormat = formatearHora(fecha);
    var fechaSalida = fechaSalidaFormat + ' ' + horaSalidaFormat;


    $("#tbMovimientos_" + rowEtapa + " .nonSalida").each(function () {
        $(this).find('.fechaSalida').val(fechaSalida);
        $(this).find('.fechaSalidaDetalle').val(fechaSalidaFormat);
        $(this).find('.horaSalidaDetalle').val(horaSalidaFormat);
        $(this).find('.etapaDestino').val(etapaDestino);

        $(this).removeClass('nonSalida');
    });
}

function formatearFecha(fecha, formato) {
    var strFecha = $.datepicker.formatDate(formato, fecha);
    return strFecha;
}

function formatearHora(fecha) {
    var horas = fecha.getHours();
    var minutos = fecha.getMinutes();
    var segundos = fecha.getSeconds();
    var ampm = horas >= 12 ? 'pm' : 'am';
    horas = horas % 12;
    horas = horas ? horas : 12; // the hour '0' should be '12'
    minutos = minutos < 10 ? '0' + minutos : minutos;
    segundos = segundos < 10 ? '0' + segundos : segundos;
    var strHora = horas + ':' + minutos + ':' + segundos + ' ' + ampm;
    return strHora;
}

function aplicarDataTable(selectorTabla) {
    $(selectorTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}

function ingreso_inv(aplica){
    $("#ingresoInv").val(aplica);
    $("#frm-lotes").submit();
}

