$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $('select').select2({placeholder: 'Seleccione una opción'});
    $(".soloNumeros").numeric();
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $(".txt_hora").datepicker('destroy');
    $('.txt_hora').timepicker({timeFormat: 'H:mm:ss'});
    $('.txt_hora').mask('99:99:99');
    $('.txt_hora').attr('placeholder', 'ejemplo: 16:00:00');

    $(".btn-close").live('click', function () {
        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    var id_bod;
    var id_cat;
    var id_prod;

    $("#frm-envio").validate({
        ignore: [],
        rules: {
            txtCotizacion: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#tbProductos .trProducto').length == 0) {
                crear_alerta('error', 'Envío Parcial', 'Debe seleccionar al menos un producto.');
                return false;
            }
            form.submit();
        }
    });

    $(".ver_en_modal").fancybox({
        openEffect  : 'elastic',
        closeEffect : 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        closeBtn : true,
        keys : {
            close  : null
        },
        helpers: {
            overlay: { closeClick: false } 
        },
        afterClose: function () {
            id_cliente = $("#id_cliente").val();
           
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj+'cotizaciones/cotizaciones/get_contactos_dropdown',
                    data: {cliente:id_cliente},
                    beforeSend: function () {
                        if($.trim(id_cliente) != ''){
                            wait.start();
                        }
                    },
                    success: function(data){
                        $("#slc_contacto").attr("placeholder","Seleccione una opción");
                        $("#slc_contacto").html(data);
                        $("#slc_contacto option[value=0]").val('');
                        $("#slc_contacto").select2();
                        wait.close();
                    }
                });
           
        }
    });

    $("#slcProducto").change(function () {
        var producto = $(this).val();
        if (producto > 0) {
            var cantidad_disponible = $("#slcProducto option:selected").data('disponible');
            $("#txtCantidadEnvio").val(cantidad_disponible);
        } else {
            $("#txtCantidadEnvio").val('');
        }
    });

    var row = 0;
    if ($('#tbProductos .trProducto').length > 0) {
        row = $("#tbProductos .trServicio").length;
    }
    
    $("#btnAgregar").click(function () {

        var txtFechaEnvio       = $("#txtFechaEnvio").val();
        var txtCantidadEnvio    = $("#txtCantidadEnvio").val();
        var slcProducto         = $("#slcProducto").val();
        var slcProductoText     = $("#slcProducto option:selected").data('nombre');
        var slcProdTextCode     = $("#slcProducto option:selected").data('codigo');
        var CantidadDisponible  = $("#slcProducto option:selected").data('disponible');
        var slcSucursal         = $("#slcSucursal").val();
        var slcSucursalTxt      = $("#slcSucursal option:selected").text();

        var txtDireccion        = $("#txt_direccion").val();
        var txtHora             = $("#txt_hora").val();
        var slcContacto         = $("#slc_contacto").val();
        var slcContactoTxt      = $("#slc_contacto option:selected").text();

        if (txtFechaEnvio == '' || slcSucursal == '' || slcProducto == '' || txtCantidadEnvio == '' || slcContacto == '' || txtHora == '') {
            crear_alerta('error', 'Envío Parcial', 'Debe completar todos los campos. (Producto, Sucursal, Fecha, Cantidad, Contacto, Hora).');
            return false;
        }

        var prodSucId = slcProducto + '_' + slcSucursal;

        if (txtCantidadEnvio < 1) {
            crear_alerta('error', 'Envío Parcial', 'La cantidad debe ser superior a 1');
            return false;
        }

        /*if ($(".slcProducto option[value='" + slcProducto + "']:selected").length > 0) {
         crear_alerta('error', 'Envío Parcial', 'El producto ya fue ingresado.');
         return false;
         }*/

        if ($(".trProducto").attr('data-prodsuc') == prodSucId) {
            crear_alerta('error', 'Envío Parcial', 'El producto ya fue ingresado a esta sucursal.');
            return false;
        }

        CantidadDisponible = parseFloat(CantidadDisponible);
        txtCantidadEnvio = parseFloat(txtCantidadEnvio);

        if (txtCantidadEnvio > CantidadDisponible) {
            crear_alerta('error', 'Envío Parcial', 'La cantidad de envío no puede superar la cantidad pendiente (' + number_format(CantidadDisponible, 2) + ').');
            return false;
        }

        var cantidadHabilitada = (CantidadDisponible - txtCantidadEnvio);

        $("#slcProducto option:selected").data('disponible', cantidadHabilitada);
        $("#slcProducto option:selected").text(slcProdTextCode + ' - ' + slcProductoText + " (" + number_format(cantidadHabilitada, 2) + ").");

        var slcProductoHtml = getOpcionesSelect("slcProducto");
        var slcSucursalHtml = getOpcionesSelect("slcSucursal");
        var slcContactosHtml= getOpcionesSelect("slc_contacto");

        slcProductoHtml = slcProductoHtml.replace(/"/g, "'");
        slcSucursalHtml = slcSucursalHtml.replace(/"/g, "'");
        slcContactosHtml= slcContactosHtml.replace(/"/g, "'");

        var html = '';

        html += '<tr id="tr_' + row + '" class="trProducto" data-id="' + row + '" data-prodsuc="' + prodSucId + '">';

        html += '<td>';
        html += '<input type="hidden" name="hdnDetalle[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input select-text" value="' + slcProdTextCode + ' - ' + slcProductoText + '" readonly="readonly"/>';
        html += '<select id="slcProducto_' + row + '" data-id="' + row + '" name="productos[]" style="display:none;" class="slcProducto select-edit">' + slcProductoHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtFechaEnvio_' + row + '" name="fechasEnvio[]" class="text tables-input-show tables-input fechaContrato txtFechas" value="' + txtFechaEnvio + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtHoraEnvio_' + row + '" name="horasEnvio[]" class="txt_hora text tables-input-show tables-input" value="' + txtHora + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + slcSucursalTxt + '" readonly="readonly"/>';
        html += '<select id="slcSucursal_' + row + '" data-id="' + row + '" name="sucursalProducto[]" style="display:none;" class="sucursalProducto select-edit">' + slcSucursalHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtDireccion' + row + '" name="direccionEnvio[]" class="text tables-input-show tables-input" value="' + txtDireccion + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidadEnvio_' + row + '" name="cantidades[]" class="text tables-input-show tables-input cantidadProducto soloNumeros" extras="." value="' + txtCantidadEnvio + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + slcContactoTxt + '" readonly="readonly"/>';
        html += '<select id="slcContacto_' + row + '" data-id="' + row + '" name="contactoEnvio[]" style="display:none;" class="contactoEnvio select-edit">' + slcContactosHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;"><input type="hidden" value="6" id="txtest">Guardar</button>';
        html += '<button type="button" class="btn btn-primary btn-mini btnEditProd" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;"><input type="hidden" value="6" id="txtest">Editar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelProd" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
        html += '</td>';

        html += '</tr>';

        var oTable = $('#tblProductos').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbProductos").append(html);
        aplidarDataTable('#tblProductos');

        row = row + 1;

        $("#txtFechaEnvio").val('');
        $("#txtCantidadEnvio").val('');
        $("#slcProducto option:selected").removeAttr('selected');
        $("#slcProducto").select2({placeholder: "Seleccione una opción"});
        $("#slcSucursal option:selected").removeAttr('selected');
        $("#slcSucursal").select2({placeholder: "Seleccione una opción"});
        $("#txt_hora").val('');
        $("#slc_contacto option:selected").removeAttr('selected');
        $("#slc_contacto").select2({placeholder: "Seleccione una opción"});
    });//En of function agregar
   

    $(".btnEditProd").live('click', function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id + " .select-text").hide();

        $("#" + parent[0].id + " .select-edit").select2({placeholder: "Seleccione una opción"});
        $("#" + parent[0].id + " .select2-container").css('width', '100%');
        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $("#" + parent[0].id + " .txtFechas").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
                    //minDate: 0
        });

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarProd").show();
    });

    //Guardar
    $(".btnGuardarProd").live('click', function () {
        var parent = $(this).parent().parent();

        var id_parent = $("#" + parent[0].id).data('id');

        var txtFechaEnvio = $("#txtFechaEnvio_" + id_parent).val();
        var txtCantidadEnvio = $("#txtCantidadEnvio_" + id_parent).val();
        var slcProducto = $("#slcProducto_" + id_parent).val();
        var slcSucursal = $("#slcSucursal_" + id_parent).val();
        var CantidadDisponible = $("#slcProducto_" + id_parent + " option:selected").data('disponible');

        if (txtFechaEnvio == '' || txtCantidadEnvio == '' || slcProducto == '' || slcSucursal == '') {
            crear_alerta('error', 'Envío Parcial', 'Debe completar todos los campos. (Producto, Sucursal, Fecha, Cantidad).');
            return false;
        }

        var prodSucId = slcProducto + '_' + slcSucursal;

        var existe = 0;
        $("#tbProductos .trProducto").each(function () {
            var dataId = $(this).attr('data-id');
            var slcProductosExistentes = $(this).attr('data-prodsuc');
            if (id_parent != dataId) {
                if (slcProductosExistentes == prodSucId) {
                    existe = 1;
                }
            }
        });

        if (existe > 0) {
            //crear_alerta('error', 'Envío Parcial', 'El producto ya fue ingresado.');
            crear_alerta('error', 'Envío Parcial', 'El producto ya fue ingresado a esta sucursal.');
            return false;
        }

        if (txtCantidadEnvio > CantidadDisponible) {
            crear_alerta('error', 'Envío Parcial', 'La cantidad de envío no puede superar la cantidad pendiente (' + number_format(CantidadDisponible, 2) + ').');
            return false;
        }

        $("#" + parent[0].id + " .select-edit").each(function () {
            var select_id = $(this).attr('id');
            var valor = $("#" + select_id).val();
            var text = "";

            if ($("#" + select_id + " option:selected").attr('data-nombre')) {
                text = $("#" + select_id + " option:selected").data('codigo') + ' - ' + $("#" + select_id + " option:selected").data('nombre');
            } else {
                text = $("#" + select_id + " option:selected").text();
            }
            if (text == '') {
                text = $("#" + select_id + " option:selected").text();
            }
            if (valor != '') {
                $("#" + select_id).prev().val(text);
            } else {
                $("#" + select_id).prev().val('');
            }
            $("#" + select_id).prev().show();
        });
        
        

        var cantidadHabilitada = (CantidadDisponible - txtCantidadEnvio);
        var slcProductoText = $("#slcProducto [value='" + slcProducto + "']").data('nombre');
        var slcProdTextCode = $("#slcProducto [value='" + slcProducto + "']").data('codigo');
        $("#slcProducto [value='" + slcProducto + "']").data('disponible', cantidadHabilitada);
        $("#slcProducto [value='" + slcProducto + "']").text(slcProdTextCode + ' - ' + slcProductoText + " (" + number_format(cantidadHabilitada, 2) + ").");


        $("#" + parent[0].id + " .select-edit").select2('destroy');
        $("#" + parent[0].id + " .select-edit").hide();
        $("#" + parent[0].id + " .select-text").show();
        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).attr('data-prodsuc', prodSucId);
        $(this).hide();
        $("#" + parent[0].id + " .btnEditProd").show();
    });


    //Eliminar Producto
    $(".btnDelProd").live("click", function () {
        var parent = $(this).parent().parent();
        var id_parent = $("#" + parent[0].id).data('id');

        var txtCantidadEnvio = parseFloat($("#txtCantidadEnvio_" + id_parent).val());
        var slcProducto = $("#slcProducto_" + id_parent).val();
        var slcProductoText = $("#slcProducto_" + id_parent + " option:selected").data('nombre');

        var cantidadDisponible = parseFloat($("#slcProducto option[value='" + slcProducto + "']").data('disponible'));

        var cantidadHabilitada = cantidadDisponible + txtCantidadEnvio;

        $("#slcProducto option[value='" + slcProducto + "']").data('disponible', cantidadHabilitada);
        $("#slcProducto option[value='" + slcProducto + "']").text(slcProductoText + " (" + number_format(cantidadHabilitada, 2) + ").");



        var oTable = $('#tblProductos').dataTable();

        oTable.fnDeleteRow(parent[0]);
    });
});

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function cerrar_modal() {
    //alert('asdasd');
    jQuery.fancybox.close();
}

function aplidarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": true,
        "bInfo": false,
        "bSort": false,
        "bLengthChange": false,
        "bFilter": false
    });
}