var dec = $("#decimales").val();
$(document).ready(function () {    

    $("select").select2({placeholder: "Seleccione"});

    $("#slcOrden").change(function () {
        var orden = $(this).val();
        if (orden != '') {
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('proyectos/reportes/get_producto_x_orden'),
                data: {
                    orden: orden
                },            
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcArticulo").html(result.productos);
                }
            });
        } else {
            $("#slcArticulo, #slcBodega").html('<option></option>');
            $("#slcArticulo, #slcBodega").select2({placeholder: "Seleccione"});
            $('#dv_contenedor_listado').html('');
            $("#acciones").hide();
            $("#bodegas").hide();
        }
    });


    $("#slcCliente").select2({
        placeholder: "Buscar Cliente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });


    $("#slcCliente, #slcTipoOrden").change(function () {
        obtenerOrdenes();
    });


    $("#btnConsultar").click(function(e) { 
        e.preventDefault();
        $("#acciones").hide();
        $("#bodegas").hide();
        var orden = $("#slcOrden").val();
        var axo = $("#slcArticulo").val();
        if (orden != "") {
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: urlj + 'proyectos/procesos/get_materiales_devolucion',
                data: {
                    orden: orden,
                    axo: axo

                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $('#dv_contenedor_listado').html(data.tabla);
                    if (data.filas > 0) {
                        if (data.despa > 0) {
                            $("#slcBodega").html(data.dropd);
                            $("#slcBodega").select2({placeholder: "Seleccione Bodega Destino"});
                            $("#btnAceptar").show();
                            $("#bodegas").show();
                        } else {
                            $("#btnAceptar").hide();
                            $("#bodegas").hide();
                            $("#slcBodega").html('<option></option>');
                            $("#slcBodega").select2({placeholder: "Seleccione"});
                            crear_alerta('info', 'Sin Producto Despachado', 'Solamente puede realizar devoluciones sobre producto ya despachado');
                        }
                        $("#acciones").show();
                    }
                    wait.close();
                }                
            });
        } else {
            $("#bodegas").hide();
            $("#slcBodega").html('<option></option>');
            $("#slcBodega").select2({placeholder: "Seleccione"});
            crear_alerta('error', 'Filtros', 'Debe especificar Cliente y número de Orden.');
            return false;
        }
    });

    $("body").on('keyup', '.devolver', function () {
        var valor = $(this).val();
        var id =  $(this).data('fila');
        var original = $('#fila_' + id).find('.ctdad_costeo').val();
        var maximo = $('#fila_' + id).find('.dev_max').val();
        if ((valor != "" && parseFloat(valor) > 0) && parseFloat(valor) > parseFloat(maximo)) {
            crear_alerta('error', 'Atención', 'Devolución sobrepasa a total despachado');
            $(this).val(0);
            $("#ctdad_nva_" + id).val(original);
            $("#nuevo_val_" + id).html(number_format(original, dec));
        }
    });

    $("body").on('blur', '.devolver', function () {
        var valor = $(this).val();
        var id =  $(this).data('fila');
        var original = $('#fila_' + id).find('.ctdad_costeo').val();
        var maximo = $('#fila_' + id).find('.dev_max').val();
        if (valor != "") {
            if (parseFloat(valor) > 0) {
                if (parseFloat(valor) > parseFloat(maximo)) {
                    crear_alerta('error', 'Atención', 'Devolución sobrepasa a total despachado');
                    $(this).val(0);
                    $("#ctdad_nva_" + id).val(original);
                    $("#nuevo_val_" + id).html(number_format(original, dec));
                } else {
                    var nuevo = parseFloat(original) - parseFloat(valor);
                    $("#ctdad_nva_" + id).val(nuevo);
                    $("#nuevo_val_" + id).html(number_format(nuevo, dec));
                }                
            }
        } else {
            $(this).val(0);
            $("#ctdad_nva_" + id).val(original);
            $("#nuevo_val_" + id).html(number_format(original, dec));
        }
    });

    $("#btnAceptar").click(function(e) {
        e.preventDefault();
        var orden = $("#slcOrden").val();
        var bodega = $("#slcBodega").val();
        if (orden != "") {
            var aplican = 0;
            $(".materiales > tr").each(function () {
                var cantidad = parseFloat($(this).find('.devolver').val());
                var maximo = parseFloat($(this).find('.dev_max').val());
                if (cantidad > 0 && cantidad <= maximo) {
                    aplican += parseFloat(cantidad);
                }
            });
            if (aplican > 0) {
                if (!(bodega > 0)) {
                    crear_alerta('warning', 'Devolución de Materiales', 'Debe especificar la Bodega Destino.');
                    $('#slcBodega').select2('open');
                    return false;
                }
                var mensaje = '¿Está seguro que desea procesar la devolución de ' + number_format(aplican, dec) + ' materias primas?';
                alerta_confirm_ajax(enviar_form, 1, 'Alerta de Confirmación', mensaje);    
            } else {
                crear_alerta('error', 'Devolución de Materiales', 'No se ha definido ninguna devolución.');
                return false;
            }            
        }
    });        
    

    function enviar_form(confirma) {
        if (confirma > 0) {
            $("#frm_devolucion").submit();
        }
    }

    
});//end doc ready 

function obtenerOrdenes() {
    $('#dv_contenedor_listado').html('');
    $("#bodegas").hide();
    var cliente = $("#slcCliente").val();
    var tipo_orden = ($("#slcTipoOrden").val() > 0) ? $("#slcTipoOrden").val() : '';
    $("#slcOrden, #slcBodega").html('<option></option>');
    $("#slcOrden, #slcBodega").select2({placeholder: "Seleccione una opción"});
    if (cliente != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.gSateliteWhite.baseUrl('proyectos/reportes/get_ordenes_cliente'),
            data: {
                cliente: cliente, 
                tipo_orden: tipo_orden
            },            
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                wait.close();
                $("#slcOrden").html(result.ordenes);
                $("#slcOrden").select2({placeholder: "Seleccione una opción"});
            }
        });
    }else{
        $("#slcTipoOrden").select2("val", "");
        $("#slcArticulo, #slcBodega").html('<option></option>');
        $("#slcArticulo , #slcBodega").select2({placeholder: "Seleccione"});
        $("#acciones").hide();
        $("#bodegas").hide();
    }
}

