var pathArray = window.location.pathname.split( '/' );
var urlj = url_base_proyecto;

$(document).ready(function () {

    var i = 0;
    if ($('#tbActions tr').length > 0) {
        i = $("#tbActions tr").length;
    }

    $('select').select2({placeholder: 'Seleccione'});

    $('.hora').timeEntry({
        show24Hours: false,
        ampmPrefix: ' ',
        spinnerImage: urlj+'media/images/spinner.png',
        spinnerSize: [40, 40, 0],
        spinnerBigSize: [70, 50, 0],
        spinnerIncDecOnly: true,
        spinnerTexts: ['', '', '', 'Incrementar', 'Disminuir']            
    });
    $(".hora").attr('placeholder','HH:mm AM');
    
    $(".datePicker").datepicker({
        showButtonPanel: false,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior"
    });

    $('#pasa_anexo').click(function() {
        $('#pes-anexos').trigger('click');
    });
    
    $('#pasa_pruebas').click(function() {
        $('#pes-pruebas').trigger('click');
    });

    $('#prueba_producto').change(function() {
        var art = $(this).val();
        if (art != "") {
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: urlj + 'proyectos/procesos/get_factores_calidad_art',
                data: {
                    producto: art
                },
                beforeSend: function () {
                    wait.start();
                }, 
                success: function (data) {
                    $('#prueba_factor').html(data.factores);
                    wait.close();
                }
            });
        } else {
            $("#prueba_factor").val('').trigger('change');
            $('#prueba_factor').html('');
            $('#prueba_comentario').val('');
            $('#prueba_valor').val('');
        }
    });

    $("body").on("change", "#prueba_factor",function() {
        $('#unidad').html("");
        $('#reference').html("");
        valor = $(this).val();
        if (valor != "") {
            var unity = $("#prueba_factor option:selected").data('unidad');
            var refer = $("#prueba_factor option:selected").data('refer');
            if (unity != "") {
                $('#unidad').html("<b>Unidad: </b>" + unity);
            }
            if (refer != "") {
                $('#reference').html("<b>Referencia: </b>" + refer);
            }
        } else {
            $('#unidad').html("");
            $('#reference').html("");
        }
    });

    $("body").on("click", "#btnAgregar",function(e) {
        e.preventDefault();
        wait.start();
        var articulo = $('#prueba_producto').val();
        var factor = $("#prueba_factor").val();
        var valor = $("#prueba_valor").val();
        var comentario = $('#prueba_comentario').val();
        if ($("#tr_" + factor + "_" + articulo).length > 0) {
            crear_alerta('error', 'Control de Calidad', 'Esta prueba ya fue ingresada.');
            wait.close();
            return false;
        }
        if (articulo != "" && factor != "" && valor != "") {
            var fila = "";
            var text_articulo   = $("#prueba_producto option:selected").text();
            var axo             = $("#prueba_producto option:selected").data('axo');
            var text_factor = $("#prueba_factor option:selected").text();
            var unidad      = $("#prueba_factor option:selected").data('unidad');
            var referencia  = $("#prueba_factor option:selected").data('refer');
            var fcc         = $("#prueba_factor option:selected").data('factor');
            fila += '<tr id="tr_' + factor + '_' + articulo + '" >';
            fila += '<td><input type="hidden" name="articulo[]" value="' + articulo + '"><input type="hidden" name="axo[]" value="' + axo + '">';
            fila += '<input type="hidden" name="hdn_dci[]" value=""><label>' + text_articulo +'</label></td>';
            fila += '<td><input type="hidden" name="fca[]" value="' + factor + '"><input type="hidden" name="fcc[]" value="' + fcc + '"><label>' + text_factor +'</label></td>';
            fila += '<td><input type="hidden" name="resultado[]" value="' + valor + '"><label>' + valor +'</label></td>';
            fila += '<td><input type="hidden" name="referencia[]" value="' + referencia + '"><label>' + referencia +'</label></td>';
            fila += '<td><input type="hidden" name="unidad[]" value="' + unidad + '"><label>' + unidad +'</label></td>';
            fila += '<td><input type="hidden" name="comentario[]" value="' + comentario + '"><label>' + comentario +'</label></td>';
            fila += '<td><button class="btn btn-danger btn-mini del_row" type="button" data-row="tr_' + factor + '_' + articulo + '">Eliminar</button></td>';
            fila += '</tr>';            
            i++;
            $("#prueba_producto").val('').trigger('change');
            $('#prueba_factor').html('<option value=""></option>');
            $('#prueba_comentario').val('');
            $('#prueba_valor').val('');
            $('#unidad').html("");
            $('#reference').html("");
            $('#tbActions').append(fila);
            wait.close();
        } else {
            crear_alerta('info', 'Campos Requeridos', 'Verifique los Campos Requeridos');
            wait.close();
            return false;
        }
    }); 

    $("body").on("click", ".del_row",function() {
        var id = $(this).data('row');
        $("#" + id).remove();
    }); 

    $("#frm_prueba").validate({
        rules: {
            fecha_prueba: {required: true},
            hora_ini: {required: true},
            hora_fin: {required: true}
        },    
        submitHandler: function (form){
            var nFilas = $("#tbActions tr").length;
            if (nFilas > 0) {
                form.submit();
            } else {
                crear_alerta('error', 'Control de Calidad', 'No ha agregado ninguna prueba.');
                return false;
            }
        }
    });

    carpeta = $('#foto_add').attr('value');
    var folder_anx_temp = 'anx_proyectos';
    var ruta = url_base_proyecto + 'personal/empleado/guardar_gral/' + carpeta;

    new FUload('btn_foto',ruta, {
        start:function(file){
            wait.start();
        },
        sucess:function(data){
            wait.close();
            if ($.trim(data) !== "") {
                var anx = $('.imagen_documento').length;
                var a_exten = $.trim(data).split('.');
                exten = a_exten[(a_exten.length - 1)].toLowerCase();
                if(exten == 'jpg' || exten == 'jpeg' || exten == 'png' || exten == 'gif') { 
                    var exten = "." + a_exten[(a_exten.length - 1)];
                    var preview = "<tr id='preview" + anx + "' style='display:none;' class='preview_documento'>";
                    if (a_exten[(a_exten.length - 1)] === 'png' || a_exten[(a_exten.length - 1)] === 'jpg' || a_exten[(a_exten.length - 1)] === 'jpeg' || a_exten[(a_exten.length - 1)] === 'pdf') {
                        preview += "<td><a  title=\"Ver Anexo\" class='ver_en_modal fancybox-buttons' data-fancybox-group='button' href='" + url_base_proyecto + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                    } else {
                        preview += "<td><a target='_blank' title=\"Ver Anexo\" class='' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                    }
                    preview += "<img id='pre" + anx + "' src='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "' width='88' height='88' class='imagen_documento'></a></td>";
                    preview += "<td><input maxlength='75' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc[]' required value='" + $.trim(data).replace(exten, '') + "'>";
                    preview += "<span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc" + anx + "'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                    preview += "<td style='vertical-align:middle !important; width:30px !important;'><img  style='display:none;' src='" + urlj + "media/editar_documento.png" + "' title='Editar' value='titulo_doc" + anx + "' class='editar_documento'/></td>";
                    preview += "<td style='background:#E1E7F0!important;'><a href=\"javascript: void(0);\" title=\"Eliminar Anexo\" onclick='delete_anexo_prev("+anx+");' class='eliminar_imagen' id='delete" + anx + "' custom='' custom_id=''><img class='quitar_documento' src='" + urlj + "media/eliminar_documento.png" + "' title='Eliminar documento'></a></div>";
                    preview += "<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></td></tr>";
                    $("#previews").append(preview).show(300);
                    $("#awesome_form").append("<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></div>");
                    $("#preview" + anx).fadeIn(400);
                    document.getElementById('pre' + anx).src = urlj + "media/imagenes/sistema/" + a_exten[(a_exten.length - 1)] + ".png";
                    document.getElementById('ruta' + anx).value = $.trim(data);
                    document.getElementById('delete' + anx).custom = $.trim(data);
                    document.getElementById('delete' + anx).custom_id = i;
                    valor = document.getElementById('pre' + anx).src;
                    $(".eliminar_imagen, .verAnexo").tooltip();
                }else{
                    crear_alerta('error','Formato Incorrecto', 'El archivo es inválido');
                }               
            } else { 
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });

    
});//end doc ready 

function delete_anexo(id_aop, cont){
     $.ajax({
            dataType: 'json',
            type: "POST",
            url: urlj + "proyectos/procesos/delete_anexo_orden",
            data: {id_aop: id_aop},
            beforeSend: function () {
                wait.start();
            }
        }).done(function (data) {
            wait.close();
           $('#preview'+cont).remove();
        });
}

function delete_anexo_prev(cont){
    $('#preview'+cont).remove();
}


// function aplicarDataTable(idTabla) {
//     $('#' + idTabla).dataTable({
//         "bLengthChange": false,
//     });
// }



// function verifica_fecha(fecha_ini, fecha_fin) {
//     var fecha_i = fecha_ini.split("-").reverse().join("-");
//     var fecha_f = fecha_fin.split("-").reverse().join("-");
//     if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
//         crear_alerta('error','Fechas','Verifique las fechas del período');
//         return false;
//     }else{
//         return true;
//     }
// }

