var global_arreglo = Array();
var i = 0;

$(document).ready(function () {

    //Esconder el buscador del datatable
    aplidarDataTable('tblProductos');
    if ($("#vista").length == 0) {
        setTimeout(function () { verificar_materiales_explosion(); }, 100);
    }
    

    //Evitar el submit con enter
    $('#frm_programacion').on('keyup keypress', function(e) {
        var keyCode = e.keyCode || e.which;
        if (keyCode === 13) { 
            e.preventDefault();
            return false;
        }
    });

    $('select').select2({placeholder: 'Seleccione'});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    //Abrir el modal respectivo
    $("body").on("click", ".fancybox_modal",function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'inline',
            width:'100%',
            closeBtn: false,
            beforeLoad: function() {
                $(".cong").iButton('repaint');
                $(".chk_producir").iButton('repaint');
            },
            helpers   : { 
                overlay : {closeClick: false}
            },
            height: '100%'
        });
    });

    //Validar periodo de fechas
    $("body").on("change", "#txt_fecha_ini, #txt_fecha_fin", function(){
        if (!(verifica_fecha($('#txt_fecha_ini').val(), $('#txt_fecha_fin').val()))) {
            // $('#txt_fecha_ini').val('');
        }
    });

    //Validar que fecha este dentro de periodo valido
    $(document).on('change','.calendar',function(){ 
        var valor = $(this).val().split("-").reverse().join("-");
        var start = $('#txt_fecha_ini').val().split("-").reverse().join("-");
        var final = $('#txt_fecha_fin').val().split("-").reverse().join("-");
        if((Date.parse(valor) < Date.parse(start)) ||  (Date.parse(valor) > Date.parse(final)) ){
            crear_alerta('error', 'Período', 'Fecha debe estar dentro del rango.');
            $(this).val('');
        }                
    });

    $("body").on("change", "#slc_bod_inter, #slc_bod_mat_pr", function(){
        verificar_materiales_explosion();
    });

    $('body').on('click', '.paginate_button', function () {
        $(".datePicker").datepicker({dateFormat: 'dd-mm-yy', placeholder: 'dd-mm-yyyy'});
        $(".datePicker").mask("99-99-9999");
        verificar_materiales_explosion();
    });



    //Boton programar
    $("body").on("click", ".programa", function(){
        resetear();
        var id = $(this).data('id');
        var orden = $(this).data('ord');
        var valor = $(this).closest("#tr_"+id).find("td #programar_" + id).val();
        //console.log(valor);
        //Si valor = 1 ya se habia hecho una programacion
        if (valor > 0) {
            // alerta_confirm_ajax(nuevaProg, id, 'Ya realizó la programación para este artículo.','Si desea modificarlo deberá realizar nuevamente todo el proceso. ¿Está seguro que desea continuar?', cancelar_pro);
            // return false;
            nuevaProg(id, 1);
        } else {
            nuevaProg(id);   
        }
    });


    //Filtrar grid y pintarla de nuevo
    $("#btn_filtrar").click(function() { 
        var articulo = $("#slc_codigo").val();
        var categoria = $("#slc_categoria").val();
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: urlj + 'proyectos/procesos/get_detalle_programacion/1',
            data: {
                articulo: articulo,
                categoria: categoria,
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                var oTable = $('#tblProductos').dataTable();
                oTable.fnDestroy(); 
                $('#tbProductos').html(data.detalles);
                $(".datePicker").datepicker({dateFormat: 'dd-mm-yy', placeholder: 'dd-mm-yyyy'});
                $(".datePicker").mask("99-99-9999");
                verificar_materiales_explosion();
                aplidarDataTable('tblProductos');
                wait.close();
            }
        });
    });


    //Boton Misma fecha
    $("body").on("change", "#ice_date",function() {
        if ($(this).is(':checked')) {
            var valor = $('#fecha_prog').val();
            if (valor != '') {
                $("#fecha_prog").attr('readonly', true).datepicker("destroy");    
            } else {
                $(this).prop("checked", false).change();
                crear_alerta('info','','Debe seleccionar una fecha.');
            }            
        } else {
            $("#fecha_prog").blur();
            $("#fecha_prog").datepicker({dateFormat: 'dd-mm-yy'});
            $("#fecha_prog").removeAttr('readonly');
        }
    });


    //Boton Misma Maquina
    $("body").on("change", "#ice_machine",function() {
        if ($(this).is(':checked')) {
            var valor = $('#machine').val();
            if (valor != '') {
                $('#machine').select2('disable');
            } else {
                $(this).prop("checked", false).change();
                crear_alerta('info','','Debe seleccionar una máquina.');
            }            
        } else {
            $('#machine').select2('enable');
        }
    });


    //Boton Mismo Operador
    $("body").on("change", "#ice_operator",function() {
        if ($(this).is(':checked')) {
            var valor = $('#operator').val();
            if (valor != '' && valor != null) {
                $('#operator').select2('disable');
            } else {
                $(this).prop("checked", false).change();
                crear_alerta('info','','Debe seleccionar al menos un operario.');
            }            
        } else {
            $('#operator').select2('enable');
        }
    });

    //Fecha de las etapas debe estar dentro del rango
    $("body").on("change", "#fecha_prog",function() {
        var f_pro = $(this).val().split("-").reverse().join("-");
        var f_ini = $('#txt_fecha_ini').val().split("-").reverse().join("-");
        var f_fin = $('#txt_fecha_fin').val().split("-").reverse().join("-");
        if (f_pro != '') {
            if((Date.parse(f_pro) < Date.parse(f_ini)) ||  (Date.parse(f_pro) > Date.parse(f_fin)) ){
                crear_alerta('error', 'Fecha', 'Fecha esta fuera del rango definido.');
                $(this).val('');
            }
        }
    });


    //Agregar a grid de modal
    $("body").on("click", "#btnAgregar",function() {
        var datos_etapa = new Array();
        var acumulado = parseFloat($('#hora_acum').val());
        var fila ="";
        var ord = $('#ord_id').val();
        var axo = $('#axo_id').val();
        var cva = $('#cva_id').val();
        var art = $('#art_id').val();
        var etapa = $('#etapas').val();
        var fecha = $('#fecha_prog').val();
        var maqui = $('#machine').val();
        var opera = $('#operator').val();
        if (etapa != '' && fecha != '' && opera != null) {
            var operadores = [];
            var data_opr = $('#operator').select2('data');
            for (var i = 0; i <= (data_opr.length-1); i++) {
                operadores[i] = data_opr[i].text;
            }
            var opera_nombre = operadores.join(', ');
            var etapa_nombre = $('#etapas option:selected').text();
            var maqui_nombre = $('#machine option:selected').text();
            if ($('#tr_' + art + '_' + etapa).length > 0) {
                crear_alerta('error', 'Etapas', 'Esta etapa ya ha sido ingresada.');
                return false;
            }
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: urlj + 'proyectos/procesos/get_datos_maquina',
                data: {
                    article: art,
                    maquina: maqui,
                    etapa: etapa,
                    fecha: fecha,
                    orden: ord
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    //console.log(data);
                    var horas_actuales = parseFloat(data.horas_disp) - parseFloat(data.horas_etap) - acumulado; 
                    fila += '<tr id="tr_' + art + '_' + etapa + '" class="jsonar tr_' + etapa + '" data-key="' + i + '" data-axo="' + axo + '" data-ord="' + ord + '" data-cva="' + cva + '" data-arti="' + art + '" data-ope="' + opera + '" data-maq="' + maqui + '" data-etap="' + etapa + '" data-etapa_nombre="' + etapa_nombre + '" data-maqui_nombre="' + maqui_nombre + '" data-opera_nombre="' + opera_nombre + '" >';
                    fila += '<td>' + etapa_nombre + '</td><td>' + fecha + '</td>';
                    fila += '<td>' + maqui_nombre + '</td><td>' + opera_nombre + '</td>';
                    fila += '<td><span id="hor_eta_' + etapa + '">' + number_format(data.horas_etap,2,'.','') + '</span></td>';
                    fila += '<td><button type="button" class="btn btn-danger btn-mini tr_del" data-art="' + art + '" data-eta="' + etapa + '" >';
                    fila += '<span class="minia-icon-trashcan"></span></button></td>';
                    fila += '</tr>';
                    if (!($('#ice_date').is(':checked'))) {
                        $('#fecha_prog').val('');
                    }
                    if (!($('#ice_machine').is(':checked'))) {
                        $('#machine').val('').trigger('change');
                    }
                    if (!($('#ice_operator').is(':checked'))) {
                        $("#operator").val([]).trigger('change');
                    }
                    $("#etapas").select2("val", "");
                    acumulado += parseFloat(data.horas_etap);
                    $('#hora_acum').val(acumulado);
                    if (horas_actuales < 0) {
                        crear_alerta('warning','Horas Máquina', 'Se alcanzó el máximo de horas.');
                    }
                    datos_etapa = {
                        'key': i,
                        'art': art,
                        'cva': cva,
                        'ord': ord,
                        'axo': axo,
                        'eta': etapa,
                        'maq': maqui,
                        'ope': opera,
                        'hor': data.horas_etap,
                        'fec': fecha,
                        'etapa_nombre' : etapa_nombre,
                        'maqui_nombre' : maqui_nombre,
                        'opera_nombre' : opera_nombre
                    }; 
                    global_arreglo.push(JSON.stringify(datos_etapa));
                    $('#contenedor_etapas').append(fila);
                    i++;
                    wait.close();
                }
            });
        } else {
            crear_alerta('error', 'Campos Requeridos', 'Verifique los Campos Requeridos');
            return false;
        }
    }); 


    //Borrar fila de la grid del modal
    $("body").on("click", ".tr_del",function() {
        var art = $(this).data('art');
        var eta = $(this).data('eta');
        var parent = $(this).parent().parent();
        var horas = parseFloat($(this).closest("#tr_" + art + "_" + eta).find("td #hor_eta_" + eta).text());
        var acumulado = parseFloat($('#hora_acum').val());
        global_arreglo = new Array();
        $("#" + parent[0].id).remove();
        $('#contenedor_etapas .jsonar').each(function(index) {
            var array_datos = new Array();
            var maqui = $(this).data('maq');
            var opera = $(this).data('ope');
            var arti = $(this).data('arti');
            var cva = $(this).data('cva');
            var ord = $(this).data('ord');
            var axo = $(this).data('axo');
            var etapa = $(this).data('etap');
            var key = $(this).data('key');
            var etapa_nombre = $(this).data('etapa_nombre');
            var maqui_nombre = $(this).data('maqui_nombre');
            var opera_nombre = $(this).data('opera_nombre');
            array_datos = {"key": key, 'art': arti, 'cva': cva, 'ord': ord, 'axo': axo, 'eta': etapa, 'maq': maqui, 'ope': opera, 'etapa_nombre' : etapa_nombre,
                        'maqui_nombre' : maqui_nombre,
                        'opera_nombre' : opera_nombre};
            global_arreglo.push(JSON.stringify(array_datos));
        });
        $('#hora_acum').val((acumulado - horas));
    }); 


    //Al guardar trasladar los datos
    $("body").on("click", "#btn_guardar",function(e) {
        e.preventDefault();
        var nFilas = $("#contenedor_etapas tr").length;
        if (nFilas > 0) {
            var destino = $("#array_id").val();
            var datos = global_arreglo.join('#');
            $('#datos_' + destino).text(datos);
            $('#programar_' + destino).val(1);
            $('#programar_' + destino).addClass('explotar');
            parent.$.fancybox.close();     
        } else {
            crear_alerta('error', 'Producto', 'No ha Definido Ninguna Etapa.');
            return false;
        }
    }); 

    $("body").on("change", ".do_rxi", function() {
        var id = $(this).data('id');
        if ($(this).is(':checked')) {
            $("#solicitar_" + id).val(1);
        } else {
            $("#solicitar_" + id).val(0);
        }
    });

    $("body").on("change", ".fecha_inicio", function() {
        var value = $(this).val();
        if (value != "") {
            var format = $(this).datepicker('option', 'dateFormat');
            if (!(es_valido(value, format))) {
                $(this).val('');
                crear_alerta('warning', 'Formato Incorrecto', 'Ingrese la fecha con formato dd-mm-yyyy');
            }
        }else{
            $("#permite_guardar").val(0);
        }
        permite_guardar();
    });


    //Explosion de materiales
    $("body").on("click", "#btnExplocion",function() {
        hacer_explosion();        
    }); 


    $("#frm_programacion").validate({
        ignore: [],  
        rules: {
            txt_fecha_ini: {required: true},
            txt_fecha_fin: {required: true},
            txt_concepto: {required: true}
            // slc_bod_inter: {required: true},
            // slc_bod_mat_pr: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form){
            var nFilas = $("#tbProductos tr").length;
            var bod_req_mater = $('#slc_bod_mat_pr').val();
            var bod_req_inter = $('#slc_bod_inter').val();
            if (!(verifica_fecha($('#txt_fecha_ini').val(), $('#txt_fecha_fin').val()))) {
                return false;
            }
            if (bod_req_mater != "" /* && bod_req_inter != "" */) {
                var start = $('#txt_fecha_ini').val().split("-").reverse().join("-");
                var final = $('#txt_fecha_fin').val().split("-").reverse().join("-");
                if (nFilas > 0) {
                    var nArts = 0;
                    var nFecs = 0;
                    var fProg = 0;
                    $('.calendar').each(function(key, value) {
                        if ($(this).val() != "") {
                            var valor = $(this).val().split("-").reverse().join("-");
                            if ((Date.parse(valor) < Date.parse(start)) ||  (Date.parse(valor) > Date.parse(final))) {
                                fProg++;
                            }
                        }            
                    });             
                    if (fProg > 0) {
                        var texto = (fProg > 1) ? 'Existen ' + fProg + ' programaciones ' : 'Existe ' + fProg + ' programación ';
                        crear_alerta('error', 'Período',  texto + 'con fecha de inicio fuera del rango seleccionado.');
                        return false;
                    }
                    $('.explotar').each(function(key, value) {
                        var value = $(this).val();
                        if (parseFloat(value) > 0) {
                            nArts++;
                        }
                    });
                    $('.fecha_inicio').each(function(key, value) {
                        var value = $(this).val();
                        if (value != "") {
                            nFecs++;
                        }
                    });
                    if (nArts > 0 && nFecs > 0) {
                        alerta_confirm_ajax(enviarForm,"",'¿Desea realizar la programación de las Ordenes de Producción para los Artículos Seleccionados?','Únicamente serán tomados en cuenta los artículos a los que se les ha especificado el proceso de Producción. ¿Está seguro que desea continuar? Esta acción no se puede revertir.');
                    } else {
                        crear_alerta('error', 'Programacion', 'No realizó una programación Válida');
                        return false;
                    }
                } else {
                    crear_alerta('error', 'Programacion', 'No realizó una programación Válida');
                    return false;
                }
            } else {
                crear_alerta('warning', 'Programacion', 'Debe definir la bodega de Materia Prima.');
                $('#slc_bod_mat_pr').select2('open');
                return false;
            }
        }
    });


    
});//end doc ready 

function enviarForm() {
    wait.start();
    var oTable = $('#tblProductos').dataTable();
    oTable.fnDestroy(); 
    // $('#btnExplocion').trigger('click');
    // parent.$.fancybox.close();
    // hacer_explosion(); 
    $("#frm_programacion")[0].submit();
}


function cerrar_modal() {
    parent.$.fancybox.close();
    crear_alerta('error', 'Producto', 'No ha Definido una Programación Válida.');
}


function hacer_explosion() {
    var articulo = new Array();
    var error_fecha = 0;
    var bod_inter = $('#slc_bod_inter').val();
    var bod_mater = $('#slc_bod_mat_pr').val();
    var oTable = $('#tblProductos').dataTable();
    oTable.fnDestroy(); 
    var nFilas = $("#tbProductos tr").length;    
    $('.fecha_inicio').each(function(key, value) {
        var fecha = $(this).val();
        if (fecha != "") {
            var id = $(this).data('id');
            var art_id = $('#tbProductos #tr_' + id).find("td #art_" + id).val();
            var ctdad = $('#tbProductos #tr_' + id).find("td #ctdad_" + id).val();
            if (parseFloat(art_id) > 0 && parseFloat(ctdad) > 0) {
                prod_ctdad = {'art': art_id,'ctd': ctdad};
                articulo.push(prod_ctdad);
            }
        } else {
            error_fecha++;
        }
    });    
    if (!(nFilas > error_fecha)) {
        crear_alerta('error', 'Programación', 'Debe definir fechas de Inicio de Producción');
        $(".datePicker").datepicker({dateFormat: 'dd-mm-yy'});
        $(".datePicker").mask("99-99-9999");
        verificar_materiales_explosion();
        aplidarDataTable('tblProductos');
        parent.$.fancybox.close();
        return false;
    }
    if (articulo.length > 0) {
        var art_programados = $("#tbProductos .explotar").length; 
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: urlj + 'proyectos/procesos/get_explosion',
            data: {
                articulos: articulo,
                intermedios: bod_inter,
                materiales: bod_mater
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                if (data.valido > 0) {
                    $('#tbMateriales').html(data.tabla);
                    $(".do_rxi").iButton({'labelOn':'Si','labelOff': 'No'});
                    $(".do_rxi").iButton('repaint');
                    $('.do_rxi').each(function(key, value) {
                        var tipo = $(this).data('tipo');
                        if (tipo != 3) {
                            $(this).iButton("toggle");
                            $(this).iButton("disable");
                        }
                    }); 
                } else {
                    parent.$.fancybox.close();
                    crear_alerta('error', 'Producto', 'No se han configurado materiales.');
                }
                if (art_programados > 0) {
                    $('#permite_guardar').val(1);
                } else {
                    $("#permite_guardar").val(0);
                }     
                permite_guardar();
                wait.close();
            }
        });
        aplidarDataTable('tblProductos');        
    } else {
        cerrar_modal();
    }
}

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "bFilter": false,//Esconder el buscador del datatable
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}


function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas del período');
        return false;
    }else{
        return true;
    }
}


function resetear() {
    $("#operator").select2("val", "");
    $("#machine").select2("val", "");
    $("#etapas").select2("val", "");
    $('#fecha_prog').val('');
    $('#ice_date').prop("checked", false).change();
    $('#ice_machine').prop("checked", false).change();
    $('#ice_operator').prop("checked", false).change();
    $('#contenedor_etapas').html('');
}
 
function nuevaProg(id, edicion) {
    global_arreglo = new Array();
    var fecha = $('#tbProductos #tr_'+id).find("td .calendar").val();
    if (fecha.trim() != '') {
        var art_id = $('#tbProductos #tr_'+id).find("td .programa").data('art');
        var cva = $('#tbProductos #tr_'+id).find("td .programa").data('cva');
        var axo = $('#tbProductos #tr_'+id).find("td .programa").data('axo');
        var ord = $('#tbProductos #tr_'+id).find("td .programa").data('ord');
        var nombre = $('#tbProductos #tr_'+id).find("td .programa").data('nombre');

        //Si es edicion se cargan los datos previos
        if(edicion == 1){
            cargar_edicion_programacion(id);
        }

        $.ajax({
            type: 'post',
            dataType: 'json',
            url: urlj + 'proyectos/procesos/get_etapas_art',
            data: {
                art_id: art_id,
                orden: ord
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $('#article_name').text(nombre);
                $('#operator').html(data.operarios);
                $('#machine').html(data.maquinas);
                $('#etapas').html(data.etapas);
                $('#fecha_prog').val(fecha);
                $('#ord_id').val(ord);
                $('#axo_id').val(axo);
                $('#cva_id').val(cva);
                $('#art_id').val(art_id);
                $('#array_id').val(id);
                $('#hora_acum').val(0);
                wait.close();
            }
        });
    } else {
        parent.$.fancybox.close();
        crear_alerta('error', 'Fecha Inicio de Producción', 'Debe Definir una Fecha Inicio de Producción');
        return false;
    } 
}

function cargar_edicion_programacion(id){
    //Se obtienen los datos
    var datos = $("#datos_" + id).val();
    //console.log(datos);
    if(datos!=""){
        $.each(datos.split("#"), function(index, row){
            var fila = JSON.parse(row);
            console.log(fila);
            global_arreglo.push(JSON.stringify(fila));
            var tr = '<tr id="tr_' + fila.art + '_' + fila.eta + '" class="jsonar tr_' + fila.eta + '" data-key="' + fila.key + '" data-axo="' + fila.axo + '" data-ord="' + fila.ord + '" data-cva="' + fila.cva + '" data-arti="' + fila.art + '" data-ope="' + fila.ope + '" data-maq="' + fila.maq + '" data-etap="' + fila.eta + '" data-etapa_nombre="' + fila.etapa_nombre + '" data-maqui_nombre="' + fila.maqui_nombre + '" data-opera_nombre="' + fila.opera_nombre + '" >';
            tr += '<td>' + fila.etapa_nombre + '</td><td>' + fila.fec + '</td>';
            tr += '<td>' + fila.maqui_nombre + '</td><td>' + fila.opera_nombre + '</td>';
            tr += '<td><span id="hor_eta_' + fila.eta + '">' + fila.hor + '</span></td>';
            tr += '<td><button type="button" class="btn btn-danger btn-mini tr_del" data-art="' + fila.art + '" data-eta="' + fila.eta + '" >';
            tr += '<span class="minia-icon-trashcan"></span></button></td>';
            tr += '</tr>';
            $('#contenedor_etapas').append(tr);
        });
    }
    if ($("#vista").length > 0) {
        if ($("#vista").val() == 1) {
            $(".tr_del").attr("disabled",true);
        }
    }
}

function cancelar_pro() {
    parent.$.fancybox.close();
    return false;
}

function verificar_materiales_explosion() {
    if ($("#tbProductos tr").length > 0) {
        wait.start();
        var articulo = new Array();
        var respuesta = new Array();
        var error = 0;
        var bod_inter = ($('#slc_bod_inter').val() > 0) ? $('#slc_bod_inter').val() : "";
        var bod_mater = ($('#slc_bod_mat_pr').val() > 0) ? $('#slc_bod_mat_pr').val() : "";
        $('.verify').each(function(key, value) {
            var id = $(this).data('id');
            var art_id = $('#tbProductos #tr_' + id).find("td #art_" + id).val();
            var ctdad = $('#tbProductos #tr_' + id).find("td #ctdad_" + id).val();
            if (parseFloat(art_id) > 0 && parseFloat(ctdad) > 0) {
                prod_ctdad = {'art': art_id,'ctd': ctdad, 'id': id};
                articulo.push(prod_ctdad);
            } else {
                error++; 
            }
        });
        if (error > 0) {
            wait.close();
            crear_alerta('error', 'Cantidad a Producir', 'Verifique las Cantidades de las Ordenes');
            parent.$.fancybox.close();
            return false;
        }        
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: urlj + 'proyectos/procesos/verificar_materiales_explosion',
            data: {
                articulos: articulo,
                intermedios: bod_inter,
                materiales: bod_mater
            },
            success: function (data) {
                respuesta = data.respuesta;
                $.each(respuesta, function(index, value) {
                    if (value > 0) {
                        $('#tbProductos #tr_' + index).prop('style','background-color: #FAFAFA !important;');
                    } else {
                        $('#tbProductos #tr_' + index).prop('style','background-color: #F2A1A1 !important;');
                    }
                });
                wait.close();
            }
        });
    }
}    

function es_valido(fecha, formato) {
    try { 
        $.datepicker.parseDate(formato, fecha); 
        return true; 
    } catch(e) { 
        return false;
    }
}

function permite_guardar() {
    if ($("#permite_guardar").val() > 0) {
        $('#btnCrear').removeAttr("disabled");
    } else {
        $('#btnCrear').attr("disabled", true);
    }
}