$(document).ready(function () {
   $('select').select2({placeholder: 'Seleccione'});

   $("#stock").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $('#hdn_stock').val(1);
            }else{
                $('#hdn_stock').val(0);
            } 
        }
    });
    

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    $("body").on("change", "#txt_fecha_ini, #txt_fecha_fin", function(){
        if (!(verifica_fecha($('#txt_fecha_ini').val(), $('#txt_fecha_fin').val()))) {
            $('#txt_fecha_ini').val('');
        }
    });


    $("body").on("change", "#slc_categoria", function(){
        var actuales = $("#slc_producto").val();
        var catego = $(this).val();
        if (catego != null && catego != '') {
            actuales = (actuales != null && actuales != "") ? actuales : "";
            $.ajax({
                type: 'post',
                url: urlj + 'proyectos/procesos/get_articulos_tia',
                data: {
                    tia_id: catego,
                    select: actuales
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $('#slc_producto').html(data);
                    $("#slc_producto").select2({placeholder: 'Seleccione'});
                    wait.close();
                }
            });
        } else {
            $("#slc_producto").select2("val", "");
            $('#slc_producto').html('');
        }
    });


    $("#btn_insert").click(function() { 
        $("#btnCrear").attr("disabled", true);
        var articulo = $("#slc_producto").val();
        var categoria = $("#slc_categoria").val();
        var bodegas = $("#slc_bodega").val();
        var stock = $("#hdn_stock").val();
        if (!(articulo != null && articulo != '') && !(categoria != null && categoria != '')) {
            crear_alerta('error', 'Planificación', 'Debe seleccionar al menos una categoría.');
            return false;
        }
        $.ajax({
            type: 'post',
            url: urlj + 'proyectos/procesos/get_planificacion',
            data: {
                articulo: articulo,
                categoria: categoria,
                bodegas: bodegas,
                stock: stock
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $('#tbProductos').html(data);
                $(".chk_producir").iButton({'labelOn':'Si','labelOff': 'No'});
                $(".chk_producir").iButton('repaint');
                wait.close();
            }
        });
    });


    $("body").on("change", ".chk_producir",function() {
        var id = $(this).data('id');
        if ($(this).is(':checked')) {
            $("#chkProducir_" + id).val(1);
        } else {
            $("#chkProducir_" + id).val(0);
        }
    });


    $("body").on("click", ".fancybox_modal",function() {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'inline',
            width:'100%',
            closeBtn: false,
            height: '100%',
            helpers   : { 
                // Evita cerrar el modal al dar clic afuera del fancybox 
                overlay : {closeClick: false}
            }
        });
    }); 

    
    $("body").on("click", "#btnExplocion",function() {
        hacer_explosion();        
    }); 


    $("#frm-planificacion").validate({
        rules: {
            txt_fecha_ini: {required: true},
            txt_fecha_fin: {required: true},
            txt_concepto: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var nFilas = $("#tbProductos tr").length;
            if (!(verifica_fecha($('#txt_fecha_ini').val(), $('#txt_fecha_fin').val()))) {
                $('#txt_fecha_ini').val('');
                return false;
            }
            if (nFilas > 0) {
                var nArts = $("#tbProductos .produccion").length;
                if (nArts > 0) {
                    alerta_confirm_ajax(enviarForm,"",'¿Desea generar las Ordenes de Compra / Producción para los Artículos Seleccionados?','Esta acción no se puede revertir ¿Está seguro que desea continuar?');
                } else {
                    crear_alerta('error', 'Producto', 'No ha Filtrado Ningun Producto Válido');
                    return false;
                }
            } else {
                crear_alerta('error', 'Producto', 'No ha Filtrado Ningun Producto Válido');
                return false;
            }
        }
    });

    $("body").on("change", ".do_rxi",function() {
        var id = $(this).data('id');
        if ($(this).is(':checked')) {
            $("#solicitar_" + id).val(1);
        } else {
            $("#solicitar_" + id).val(0);
        }
    });

    
});//end doc ready 

function enviarForm() {
    wait.start();
    // $('#btnExplocion').trigger('click');
    // parent.$.fancybox.close();
    // hacer_explosion(); 
    $("#frm-planificacion")[0].submit();
}


function cerrar_modal() {
    parent.$.fancybox.close();
    crear_alerta('error', 'Producto', 'No ha Filtrado Ningun Producto Válido');
}


function hacer_explosion() {
    var nFilas = $("#tbProductos tr").length;
    var articulo = new Array();
    var error = 0;
    var producir = 0;
    var bod_inter = $('#slc_bod_inter').val();
    var bod_mater = $('#slc_bod_mat_pr').val();
    if (nFilas > 0) {
        var nArts = $("#tbProductos .produccion").length;
        if (nArts > 0) {
            $('.producirse').each(function(key, value) {
                var produc = $(this).val();
                var data_id = $(this).attr('id');
                var num_id = data_id.split('_');
                var id = num_id[1];
                var article = $('#tr_' + id).find('td input.article').val();
                var ctdad = $('#tr_' + id).find('td input.quantity').val();
                if (parseFloat(produc) > 0) {
                    if (parseFloat(ctdad) > 0) {
                        producir++;
                        prod_ctdad = {'art': article,'ctd': ctdad};
                        articulo.push(prod_ctdad);
                    } else {
                        error++;                        
                    }                    
                }
            });
            if (error > 0) {
                crear_alerta('error', 'Cantidad a Producir', 'Ingrese una Cantidad Válida');
                parent.$.fancybox.close();
                return false;
            }
            if (producir == 0) {
                crear_alerta('info', 'Productos', 'Debe seleccionar al menos un producto.');
                parent.$.fancybox.close();
                return false;
            }
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: urlj + 'proyectos/procesos/get_explosion',
                data: {
                    articulos: articulo,
                    intermedios: bod_inter,
                    materiales: bod_mater
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    if (data.valido > 0) {
                        $('#tbMateriales').html(data.tabla);
                        $(".do_rxi").iButton({'labelOn':'Si','labelOff': 'No'});
                        $(".do_rxi").iButton('repaint');
                        $('.do_rxi').each(function(key, value) {
                            var tipo = $(this).data('tipo');
                            if (tipo == 3) {
                                $(this).iButton("toggle");
                                $(this).iButton("disable");
                            }
                        });                        
                    } else {
                        error++;
                        parent.$.fancybox.close();
                        crear_alerta('error', 'Producto', 'No se han configurado materiales.');
                    }
                    if (error > 0) {
                        $("#btnCrear").attr("disabled", true);
                    } else {
                        if (producir > 0) {
                            $('#btnCrear').removeAttr("disabled");
                        } else {
                            $("#btnCrear").attr("disabled", true);
                        }
                    }                    
                    wait.close();
                }
            });
        } else {
            cerrar_modal();    
        }
    } else {
        cerrar_modal();
    }
}


function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas del período');
        return false;
    }else{
        return true;
    }
}
