$(document).ready(function () {

    $("select").select2({placeholder: "Selecccione"});


    $("#slc_product").select2({
        placeholder: "Nombre o Código del Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/mantenimiento/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    tipo: $("#tipo_general_combo").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };                
            }
        }
    });
   


    $("#slc_product").change(function() {
        var product = $(this).val();
        if (product != "") {
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: urlj + 'inventario/gestion_productos/get_conversiones_articulo',
                data: {
                    producto: product
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $('#slc_unity').html(data.medidas);
                    $('#slc_unity option[value="0"]').text('');
                    $('#slc_unity option[value="0"]').val('');
                    $("#slc_unity").select2({placeholder:"Seleccione"});
                    wait.close();
                }
            });
        } else {
            $("#slc_unity").val('').trigger('change');
            $("#slc_unity").empty();
        }
    });

    
    $("#repetir").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $('#hdn_repetir').val(1);
            }else{
                $('#hdn_repetir').val(0);
            } 
        }
    });

    $("#frm_proyeccion_venta").validate({
        submitHandler: function (form){
            var arti = $('#slc_product').val();
            var conv = $('#slc_unity').val();
            var anio = $('#slc_year').val();
            var mont = $('#slc_month').val();
            var cant = $('#txt_cantidad').val();
            var rept = $('#hdn_repetir').val();
            if (arti != "" && conv != "" && anio != "" && mont != "" && cant != "") {
                if (rept > 0) {
                    var pregunta = "¿Desea aplicar la mismas especificaciones para todos los meses del año seleccionado?";
                    var mensaje = "Si existen registros anteriores serán actualizados con este valor ¿Está seguro que desea proceder?";
                    alerta_confirm_ajax(enviarForm, "", pregunta, mensaje);
                } else {
                    wait.start();
                    form.submit();
                }
            } else {
                crear_alerta('error', 'Proyección de Venta', 'Verifique los Campos Requeridos');
                return false;
            }

                return false;
        }
    });

    
});//end doc ready 

function enviarForm() {
    wait.start();
    $("#frm_proyeccion_venta")[0].submit();
}


function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}


