$(document).ready(function () {    
    $("select").select2({placeholder: "Seleccione una opción"});
    $(".slc_edit, .slc_edit_tipo").hide();

    $("#codigo_receta").blur(function() {
        validar_codigo_nombre($("#codigo_receta").val(), 1);
    });

    $("#nombre_receta").blur(function() {
        validar_codigo_nombre($("#nombre_receta").val(), 2);
    });

    
    $("#frm-presupuesto").validate({
        ignore: "",
        rules: {
            txtOrden: {required: true},
            codigo_receta: {required: true},
            nombre_receta: {required: true},
            cantidad_producir: {required: true, min: 0.01}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').html(error);
        },
        invalidHandler: function (form, validator) {
            var errors = validator.numberOfInvalids();
            if (errors) {
                var primerElemento = validator.errorList[0].element;

                var posiciones = primerElemento.offsetTop;
                $("html, body").animate({scrollTop: posiciones}, 1000);
            }
        },
        submitHandler: function (form) {
            if ($('#tbMateriaPrima .trMateriaPrima').length == 0 && $('#tbManoObra .trManoObra').length == 0 && $('#tbGastos .trGastosInd').length == 0) {
                crear_alerta('error', 'Presupuesto', 'Ingrese al menos un registro');
                return false;
            }else{
                form.submit();
            }
        }
    });

    var decimales_conf      = $("#decimales").val();
    var decimales_monetarios= $("#decimales_monetarios").val();

    $("#slcMateriaPrima").change(function () {
        producto = $(this).val();
        $("#slcMedida").html('<option></option>');
        $("#slcMedida").select2({placeholder: "Seleccione una opción"});
        if (producto != '') {
            $.ajax({
                url: urlj + "proyectos/procesos/get_detalles_producto",
                type: 'POST',
                dataType: 'json',
                data: {producto: producto},
                beforeSend: function () {
                    wait.start('Espere un momento por favor... Buscando información del producto.');
                },
                success: function (data) {
                    wait.close();
                    $("#slcMedida").html(data.medidas);
                    $("#slcMedida").select2({placeholder: "Seleccione una opción"});
                    $("#hdnProducto").data('codigo', data.producto.prod_codigo);
                    $("#hdnProducto").data('nombre', data.producto.prod_nombre);
                    var tipo_precio = $("#slcTipoPrecio").val();
                    var producto = $("#slcMateriaPrima").val();
                    var proveedor = $("#slcProveedor").val();
                    //obtener_precio(tipo_precio, producto, proveedor);
                }
            });
        }
    });

    $("#chk_tipo_gasto").iButton({
        'labelOn': '  Gasto Fijo  ',
        'labelOff': '  Variable  ',
        change: function (element) {
            if (element.is(':checked')) {
                $("#tipo_gasto").val(1);
            } else {
                $("#tipo_gasto").val(0);
            }
        }
    });

     $("#chk_defecto").iButton({
        'labelOn': ' Sí ',
        'labelOff': ' No ' ,
        'resizeHandle': false,
        'resizeContainer': false,
        change: function (element) {
            if (element.is(':checked')) {
                $("#receta_defecto").val(1);
            } else {
                $("#receta_defecto").val(0);
            }
        }
    });

    $(".buscarResponsable").select2({
        placeholder: "Buscar Responsable",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_empleados_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (empleado) {
                return {
                    empleado: empleado
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.empleado,
                        'text': item.emp_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $(".select-edit").select2('destroy');

    $("#slcProveedor").change(function () {
        var tipo_precio = $("#slcTipoPrecio").val();
        var producto = $("#slcMateriaPrima").val();
        var proveedor = $("#slcProveedor").val();
        //obtener_precio(tipo_precio, producto, proveedor);
    });

    $("#slcTipoPrecio").change(function () {
        var tipo_precio = $(this).val();
        if (tipo_precio == 4) {
            $("#tipo_precio_4").show();
        } else {
            $("#txt_precio_fijo").val('');
            $("#tipo_precio_4").hide();
        }
    });

    $("#slcManoObra").change(function () {
        var mano_obra = $(this).val();
        $("#txtPrecioMob").val('');
        if (mano_obra != '') {
            var precio = $('#' + this.id + ' option:selected').data('precio');
            var etapas = $('#' + this.id + ' option:selected').data('etapas');
            $("#txtPrecioMob").val(precio);
            if (etapas > 0) {
                var horas = get_ctdad_hora_mob_gif(mano_obra, 0);
                $("#txtCantidadMob").val(horas);
            } else {
                $("#txtCantidadMob").val('');
            }
        } else {
            $("#slcResponsable").select2("val", "");
            $("#txtCantidadMob").val('');
        }
    });

    $("#txtPrecioGasto").keyup(function(){
        var tipo = $("#slcEstimacion option:selected").data('valor');
        if(tipo == 0){
            var campo = $("#txtPrecioGasto").val();
            if($.trim(campo) != ''){
                var cantidad = parseFloat(campo);
                if(!(cantidad <= 100)){
                    $(this).val(100);
                    crear_alerta('error', 'Alerta', 'No se permite más del 100%');
                    return false;
                }
            }
        }
    });

    $("#txtPrecioGasto").blur(function(){
        var tipo = $("#slcEstimacion option:selected").data('valor');
        if(tipo == 0){
            var campo = $("#txtPrecioGasto").val();
            if($.trim(campo) != ''){
                var cantidad = parseFloat(campo);
                if(!(cantidad <= 100)){
                    $(this).val(100);
                    crear_alerta('error', 'Alerta', 'No se permite más del 100%');
                    return false;
                }
            }
        }
    })

    /* ====================================================================================================
                        Acciones de agregar a las grids
    ==================================================================================================== */

    // ===================== Materia Prima =====================
    $("#btnAgregarMateria").click(function () {
        var row = 0;
        if ($('#tbMateriaPrima .trMateriaPrima').length > 0) {
            row = $("#tbMateriaPrima .trMateriaPrima:last").data('id')+1;
        }
        var checkeado = ($('#allMat:checked').length == 1)?'checked':'';
        var checkeado_val = $('#allMat:checked').length;
        var tip_precio = $('#slcTipoPrecio').val(); //costo promedio o ultima compra
        var tip_precio_text = $('#slcTipoPrecio option:selected').text(); //costo promedio o ultima compra
        var val_tipo_4 = $("#txt_precio_fijo").val();
        var slcMateriaPrima = $("#slcMateriaPrima").val();
        var slcMateriaPrimaText = $("#hdnProducto").data('nombre');
        var slcMateriaPrimaHtml = getOpcionesSelect("#slcMateriaPrima");
        var slcMateriaCodigo = $("#hdnProducto").data('codigo');
        var slcProveedor = $("#slcProveedor").val();
        var slcProveedorText = $("#slcProveedor option:selected").text();
        var slcProveedorHtml = getOpcionesSelect("#slcProveedor");
        var slcMedida = $("#slcMedida").val();
        var slcMedidaText = $("#slcMedida option:selected").text();
        var slcMedidaHtml = getOpcionesSelect("#slcMedida");
        var txtPrecio = $("#txtPrecio").val();
        var txtCantidad = $("#txtCantidad").val();
        var slcEtapa = $("#slcEtapa").val();
        var slcEtapaText = $("#slcEtapa option:selected").text();
        var precio_fijo = (tip_precio == 4 && val_tipo_4 > 0) ? true : false;
        //validaciones
        if (slcMateriaPrima == '' || tip_precio == '' || txtCantidad == '' ) {
            crear_alerta('error', 'Materia Prima', 'Debe completar los campos necesarios.(Materia Prima, Tipo de precio, Cantidad)');
            return false;
        }
        if (!(parseFloat(txtCantidad) > parseFloat(0.00))) {
            crear_alerta('error', 'Materia Prima', 'La Cantidad debe ser mayor a cero.');
            return false;
        }
        if (tip_precio == 4 && (val_tipo_4 == "" || val_tipo_4 <= 0)) {
            crear_alerta('error', 'Materia Prima', 'Ingrese el Costo de la Materia Prima.');
            return false;
        }
        if ($("#trMp_" + slcMateriaPrima).length > 0) {
            crear_alerta('error', 'Materia Prima', 'El producto ya fue ingresado.');
            return false;
        }
        //fin de validaciones
        slcMateriaPrimaHtml = slcMateriaPrimaHtml.replace(/"/g, "'"); //reemplaza la comilla doble por simple
        slcProveedorHtml = slcProveedorHtml.replace(/"/g, "'");
        slcMedidaHtml = slcMedidaHtml.replace(/"/g, "'");
        var html = '';
        if (tip_precio == 4) {
            var subTotal = (parseFloat(val_tipo_4) * parseFloat(txtCantidad));
        } else {
            var subTotal = (parseFloat(txtPrecio) * parseFloat(txtCantidad));
        }
        
        html += '<tr id="trMp_' + slcMateriaPrima + '" class="trMateriaPrima" data-id="' + row + '">';
        html += '<td style="width:10%; font-size:11px; color:#777; font-weight:bold; word-wrap:break-word;">';
        html += '<input type="hidden" name="hdnDetalleMateria[]" class="tables-input" value="0" />';
        html += '<input type="hidden" name="hdnEtapas[]" class="tables-input" value="'+slcEtapa+'" />' + slcEtapaText;
        html += '</td>';

        html += '<td style="width:20%; max-width:20%; font-size:11px;color:#777;font-weight:bold;word-wrap:break-word;">' + slcMateriaCodigo + ' - ' + slcMateriaPrimaText;
        html += '<select id="slcMateriaPrima_' + row + '" data-id="' + row + '" name="materiaPrima[]" style="display:none;" class="materiaPrima select-edit">' + slcMateriaPrimaHtml + '</select>';
        html += '</td>';

        html += '<td style="width:8%">';
        html += '<input type="text" class="text tables-input select-text" value="' + slcMedidaText + '" readonly="readonly"/>';
        html += '<select id="slcMedida_' + row + '" data-id="' + row + '" name="conversionesMateria[]" style="display:none;" class="conversionMateria select-edit">' + slcMedidaHtml + '</select>';
        html += '</td>';

        html += '<td style="width:18%">';
        html += '<label class="text tables-input select-text">' + slcProveedorText + '</label>';
        html += '<select id="slcProveedor_' + row + '" data-id="' + row + '" name="proveedoresMateria[]" style="display:none;" class="proveedorMateria select-edit">' + slcProveedorHtml + '</select>';
        html += '</td>';

        html += '<td style="width:12%; text-align: right;">';
        html += '<input type="text" id="tipo_preciot_'+row+'" class="text tables-input-show tables-input"  value="' + tip_precio_text + '" readonly="readonly"/>';
        html += '<select style="font-size: 10px;width: 100%;display: none;" id="slc_tipo_precio_edit_' + row + '" class="slc_edit_tipo nostyle" data-id="' + row + '"><option></option>';
        html += (tip_precio == 1) ? '<option selected value="1">Costo Promedio</option>' : '<option value="1">Costo Promedio</option>';
        html += (tip_precio == 2) ? '<option selected value="2">Última compra</option>' : '<option value="2">Última compra</option>';
        html += (tip_precio == 3) ? '<option selected value="3">Última Producción</option>' : '<option value="3">Última Producción</option>';
        html += (tip_precio == 4) ? '<option selected value="4">Precio Fijo</option>' : '<option value="4">Precio Fijo</option>';
        html += '</select>';
        html += '<span id="texto_val_tipo_4_'+row+'" style="font-size: 10px;">';
        html += (tip_precio == 4) ? '(Precio: $' + number_format(val_tipo_4, decimales_conf) + ')' : '';
        html += '</span>';
        html += '<input type="text" id="pre_fijo_uni_'+row+'" name="pre_fijo_uni[]" class="soloDecimales" value="' + number_format(val_tipo_4, decimales_conf,'.','') + '" data-orig="' +  number_format(val_tipo_4, decimales_conf,'.','') + '"  decimales="'+decimales_conf+'" style="display: none;">';
        html += '<input type="hidden" id="tipo_preciov_'+row+'" name="tipo_precio[]" class="text tables-input-show tables-input"  value="' + tip_precio + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:12%; text-align: right;">';
        html += '<input type="text" style="text-align: right;" id="txtCantidad_' + row + '" name="cantidadesMateria[]" class="text tables-input-show tables-input soloDecimales cantidadMateria edit" value="' + number_format(txtCantidad, decimales_conf) + '" readonly="readonly"/>';
        html += '<span id="subtot_tipo_4_'+row+'" style="font-size: 10px;">';
        html += (tip_precio == 4) ? '(SubTotal: $' + number_format(subTotal, decimales_conf) + ')' : '';
        html += '</span>';
        html += '</td>';

        html += '<td style="width:8%;text-align: center;">';
        html += '<input type="checkbox" id="chkEstMateria_' + row + '" data-subtotal = "txtSubtotal_' + row + '" class="nostyle aplicar_estimacion est_materia" '+checkeado+' />';
        html += '<input type="hidden" id="chkEstMateria' + row + '" name="chkEstMateria[]" value="'+checkeado_val+'" />';
        html += '</td>';

        html += '<td style="width:12%">';
        html += '<div class="span6">';
        html += '<button type="button"  class="btn btn-primary btn-mini editar_fila btnEditMateriaPrima" data-edit="'+row+'" style="float:left; height:30px;width:50px;"> Editar</button>';
        html += '<button type="button"  class="btn btn-primary btn-mini materiaPrima guardar_fila" data-edit="'+row+'" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>';
        html += '</div>';
        html += '<div class="span6">';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelMateriaPrima" style="float:left; margin-left:5%; height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
        html += '</td>';
        html += '</div>';
        html += '</tr>';

        var oTable = $('#tblMateriaPrima').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbMateriaPrima").append(html);
        aplicarDataTable('#tblMateriaPrima');
        $("#txtPrecio").val('');
        $("#txtCantidad").val('');
        $("#slcMateriaPrima option:selected").removeAttr('selected');
        $("#slcMateriaPrima").select2({placeholder: "Seleccione una opción"});
        $("#slcProveedor option:selected").removeAttr('selected');
        $("#slcProveedor").select2({placeholder: "Seleccione una opción"});
        $("#slcTipoPrecio option:selected").removeAttr('selected');
        $("#slcTipoPrecio").select2({placeholder: "Seleccione una opción"});
        $("#slcEtapa option:selected").removeAttr('selected');
        $("#slcEtapa").select2({placeholder: "Seleccione una opción"});
        $("#txt_precio_fijo").val('');
        $("#tipo_precio_4").hide();
        $("#slcMedida").html('<option></option>');
        $("#slcMedida").select2({placeholder: "Seleccione una opción"});
    });

    // ===================== Mano de Obra =====================
    $("#btnAgregarMob").click(function () {
        var row = 0;
        if ($('#tbManoObra .trManoObra').length > 0) {
            row = $("#tbManoObra .trManoObra:last").data('id')+1;
        }

        var checkeado = ($('#allObr:checked').length == 1)?'checked':'';
        var checkeado_val = $('#allObr:checked').length;
        var slcManoObra = $("#slcManoObra").val();
        var slcManoObraText = $("#slcManoObra option:selected").text();
        var slcManoObraHtml = getOpcionesSelect("#slcManoObra");
        var slcManoObraCodigo = $("#slcManoObra option:selected").data('codigo');
        var slcResponsable = $("#slcResponsable").val();
        var txtPrecio = $("#txtPrecioMob").val();
        var txtCantidad = $("#txtCantidadMob").val();
        var emp_default = $("#emp_default").html();

        if($("#decimales").val()>0){
            var decimales = $("#decimales").val();
        }else{
            var decimales = 2;
        }

        if(slcResponsable>0){
            slcResponsableText = ($("#dvResponsable .select2-choice").text()).trim();
        }else{
            slcResponsableText = '-';
        }
        
        //validaciones
        if (slcManoObra == ''  ||  txtCantidad == '') {
            crear_alerta('error', 'Mano de Obra', 'Debe completar los campos necesarios.(Mano de Obra, Cantidad).');
            return false;
        }

        if (!(parseFloat(txtCantidad) > parseFloat(0.00))) {
            crear_alerta('error', 'Materia Prima', 'La Cantidad debe ser mayor a cero.');
            return false;
        }

        if ($("#trMob_" + slcManoObra + '_' + slcResponsable).length > 0) {
            crear_alerta('error', 'Mano de Obra', 'La mano de obra ya fue agregada.');
            return false;
        }
        //fin de validaciones

        slcManoObraHtml = slcManoObraHtml.replace(/"/g, "'");
        var html = '';

        var subTotal = (parseFloat(txtPrecio) * parseFloat(txtCantidad));

        html += '<tr id="trMob_' + slcManoObra + '_' + slcResponsable +'" class="trManoObra" data-id="' + row + '">';

        html += '<td style="width:10%">';
        html += '<input type="hidden" name="hdnDetalleMob[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input select-text" value="' + slcManoObraCodigo + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:23%">';
        html += '<input type="text" class="text tables-input select-text" value="' + slcManoObraText + '" readonly="readonly"/>';
        html += '<select id="slcManoObra_' + row + '" data-id="' + row + '" name="manoObra[]" style="display:none;" class="manoObra select-edit">' + slcManoObraHtml + '</select>';
        html += '</td>';

        html += '<td style="width:23%">';
        html += '<label class="text tables-input select-text'+ row +'">' + slcResponsableText + '</label>';
        html += '<input type="hidden" id="slcResponsable_' + row + '" name="responsanblesMob[]" class="nostyle select-edit buscarResponsable" value="' + slcResponsable + '"/>';
        html += ' <select name="empleados_edit[]" id="empleado_edit_'+ row +'" placeholder="Seleccione" class="nostyle slc_edit " style="width:90%" >'+ emp_default +'</select>';
        html += '</td>';

        html += '<td style="width:10%">';
        html += '<input type="text" id="txtCantidadMob_' + row + '" name="cantidadesMob[]" class="text tables-input-show tables-input soloDecimales cantidadMob edit" value="' + number_format(txtCantidad, decimales_conf) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:10%;text-align: center;">';
        html += '<input type="checkbox" id="chkEstMob_' + row + '" data-subtotal = "txtSubtotalMob_' + row + '" class="nostyle aplicar_estimacion est_mano" '+checkeado+' />';
        html += '<input type="hidden" name="chkEstMob[]" value="'+checkeado_val+'" />';
        html += '</td>';

        html += '<td style="width:10%">';
        html += '<div class="span6">';
        html += '<button type="button"  class="btn btn-primary btn-mini editar_fila ManoObra" data-edit="'+row+'" style="float:left; height:30px;width:50px;"> Editar</button>';
        html += '<button type="button"  class="btn btn-primary btn-mini ManoObra guardar_fila" data-edit="'+row+'" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>';
        html += '</div><div class="span6">';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelManoObra" style="float:left;height:30px;width:50px;margin-left:5%;">Eliminar</button>';
        html += '</div></td>';

        html += '</tr>';

        var oTable = $('#tblManoObra').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbManoObra").append(html);
        aplicarDataTable('#tblManoObra');

        if(slcResponsable>0){ $("#empleado_edit_"+row).val(slcResponsable); }
        $("#empleado_edit_"+row).select2("destroy").hide();

        $("#txtPrecioMob").val('');
        $("#txtCantidadMob").val('');
        $("#slcManoObra option:selected").removeAttr('selected');
        $("#slcManoObra").select2({placeholder: "Seleccione una opción"});
        $("#slcResponsable").select2('data', null);
    });

    // ===================== Mano de Obra =====================
    $("#btnAgregarGasto").click(function () {
        var row = 0;
        if ($('#tbGastos .trGastosInd').length > 0) {
            row = $("#tbGastos .trGastosInd:last").data('id')+1;
        }
        var slcEstimacion       = $("#slcEstimacion").val();
        var slcEstimacionText   = $("#slcEstimacion option:selected").text();
        var slcEstimacionHtml   = getOpcionesSelect("#slcEstimacion");
        var slcEstimacionCodigo = $("#slcEstimacion option:selected").data('codigo');
        var valor_texto         = $("#slcEstimacion option:selected").data('valort');
        var valor               = $("#slcEstimacion option:selected").data('valor');
        var txtPrecio           = $("#txtPrecioGasto").val();
        var txtCantidad         = $("#txtCantidadGasto").val();
        var tipo_gasto          = $("#tipo_gasto").val();
        var subtotal_gasto      = parseFloat(txtPrecio, 2);

        if($("#decimales").val()>0){
            var decimales = $("#decimales").val();
        }else{
            var decimales = 2;
        }

        if (slcEstimacion == '' || txtPrecio == '' || txtCantidad == '') {
            crear_alerta('error', 'Gastos Indirectos', 'Debe completar los campos necesarios.(Estimación de gastos, Precio, Cantidad).');
            return false;
        }

        if (txtCantidad <= 0) {
            crear_alerta('error', 'Gastos Indirectos', 'La Cantidad debe ser mayor a cero.');
            return false;
        }

        if (txtPrecio <= 0) {
            crear_alerta('error', 'Gastos Indirectos', 'El precio debe ser mayor a cero.');
            return false;
        }
        if ($("#trGst_" + slcEstimacion).length > 0) {
            crear_alerta('error', 'Gastos Indirectos', 'La estimación de gasto ya fue agregada.');
            return false;
        }

        slcEstimacionHtml = slcEstimacionHtml.replace(/"/g, "'");
        var html = '';
        var subTotal = 0;
        if(valor == 1){
            subTotal = (parseFloat(txtPrecio) * parseFloat(txtCantidad));
        } else{
            subTotal = parseFloat(subtotal_gasto, decimales_monetarios);
        }
        valor_texto += (tipo_gasto > 0) ? ' (Gasto Fijo)' : ' (Variable)';

        html += '<tr id="trGst_' + slcEstimacion + '" class="trGastosInd" data-id="' + row + '">';

        html += '<td>';
        html += '<input type="hidden" name="hdnDetalleGst[]" class="tables-input" value="0" />';
        html += '<input type="hidden" name="hdnTipoGastos[]" value="' + tipo_gasto + '" />';
        html += '<input type="text" class="text tables-input select-text" value="' + slcEstimacionCodigo + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + slcEstimacionText + '" readonly="readonly"/>';
        html += '<select id="slcEstimacion_' + row + '" data-id="' + row + '" name="estimacionesGasto[]" style="display:none;" class="estimacionGasto select-edit">' + slcEstimacionHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtTipoCalculo_' + row + '" name="TiposCalculos[]" class="text tables-input-show tables-input otros_gastos edit" value="' + valor_texto + '" data-valor = "' + valor + '" data-correlativo = "' + row + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidadGasto_' + row + '" name="cantidadesGasto[]" class="text tables-input-show tables-input soloDecimales cantidadGasto edit" value="' + number_format(txtCantidad, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPrecioGasto_' + row + '" name="preciosGasto[]" class="text tables-input-show tables-input soloDecimales precioGasto edit" value="' + number_format(subTotal, decimales_monetarios) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        //html += '<button type="button"  class="btn btn-primary btn-mini editar_fila btnEditGastoPrima" data-edit="'+row+'" style="float:left; height:30px;width:50px;"> Editar</button>';
        html += '<button type="button"  class="btn btn-primary btn-mini gastoPrima guardar_fila" data-edit="'+row+'" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelGasto" style="float:left;height:30px;width:50px;margin-left:4%;">Eliminar</button>';
        html += '</td>';

        html += '</tr>';


        var oTable = $('#tblGastos').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbGastos").append(html);
        aplicarDataTable('#tblGastos');
        $("#txtCantidadGasto").val(1);
        $("#txtPrecioGasto").val('');
        //$("#txtCantidadGasto").val('');
        $("#slcEstimacion option:selected").removeAttr('selected');
        $("#slcEstimacion").select2({placeholder: "Seleccione una opción"});
    });
    /* ====================================================================================================
                        Fin de Acciones de agregar a las grids
    ==================================================================================================== */
    
    /* ==================================================================================================
                            Edita las filas de las grid
    ================================================================================================== */
    $(".editar_fila").live("click", function () {
        $(this).hide();
        var cont = $(this).data('edit');
        var parent = $(this).parent().parent().parent();
        var tipo_p = ($(this).hasClass('btnEditMateriaPrima')) ? $("#tipo_preciov_"+cont).val() : 0;
        if($(this).hasClass('ManoObra')){
            $(".select-text"+cont).text('');
            $("#empleado_edit_"+cont).show();
            $("#empleado_edit_"+cont).select2({placeholder: "Seleccione una opción"});
            $("#txtCantidadMob_"+cont).val($("#txtCantidadMob_"+cont).val().replace(/\$|\,/gi,''));
        }
        $("#" + parent[0].id + " .edit").removeAttr('readonly');
        $("#" + parent[0].id + " .edit").removeClass('tables-input');
        if($(this).hasClass('btnEditMateriaPrima')){
            $("#tipo_preciot_"+cont).hide();
            $("#slc_tipo_precio_edit_"+cont).show().select2({placeholder: 'Seleccione'});
            $("#slc_tipo_precio_edit_"+cont).trigger('change');
            if (tipo_p == 4) {
                $('#subtot_tipo_4_'+cont).hide();
                $('#texto_val_tipo_4_'+cont).hide();
                $('#pre_fijo_uni_'+cont).show();
            }
        }
        $("#" + parent[0].id + " .guardar_fila").show();
    });

    $(".slc_edit_tipo").live('change',function(event){
        var cont = $(this).data('id');
        $('#subtot_tipo_4_'+cont).hide();
        $('#texto_val_tipo_4_'+cont).hide();
        if ($(this).val() == 4) {
            $('#pre_fijo_uni_'+cont).show();
        } else {
            $('#pre_fijo_uni_'+cont).hide();
        }
    });

    //--------Boton guardar para la tabla de articulos
    $(".guardar_fila").live('click',function(event){
        var cont = $(this).data('edit');
        if($(this).hasClass('materiaPrima')){ //materia prima
            var cantidad = $("#txtCantidad_"+cont).val();
            var tipo_p = $("#slc_tipo_precio_edit_"+cont).val();
            var text_p = $("#slc_tipo_precio_edit_"+cont+" option:selected").text();
            var original = (tipo_p == 4) ? $('#pre_fijo_uni_'+cont).data('orig') : "";
            var new_pric = ($('#pre_fijo_uni_'+cont).val() != "") ? $('#pre_fijo_uni_'+cont).val() : original;
            $("#slc_tipo_precio_edit_"+cont).select2("destroy").hide();
            if (tipo_p > 0) {
                if (tipo_p == 4 && !(new_pric > 0)) {
                    crear_alerta('error', 'Atención', 'Debe ingresar un precio valido');
                    return false;
                }
            } else {
                    crear_alerta('error', 'Atención', 'El Tipo de Precio es Obligatorio');
                    return false;
            }
            $("#tipo_preciov_"+cont).val(tipo_p);
            $("#tipo_preciot_"+cont).val(text_p).show();
        }else if($(this).hasClass('ManoObra')){ //Mano de obra
            var cantidad = $("#txtCantidadMob_"+cont).val();
            $("#txtCantidadMob_"+cont).val(number_format($("#txtCantidadMob_"+cont).val(), decimales_conf));//nos pone los decimales
        }else{
            var cantidad = $("#txtCantidadGasto_"+cont).val();
            var pre = $("#txtPrecioGasto_"+cont).val();
            var precio = pre.replace(',','');
        }
        if(!(cantidad > 0.00) || isNaN(cantidad)){
            crear_alerta('error','Informaci&oacute;n','Ingrese la cantidad'); 
        }else{
            var parent = $(this).parent().parent().parent();
            $(this).hide();
            if($(this).hasClass('materiaPrima')){ //materia prima                
                var new_sbtl = (isNaN(new_pric)) ? 0 : parseFloat(new_pric * cantidad);
                if (new_pric != "") {
                    $('#pre_fijo_uni_'+cont).data('orig', new_pric);
                }
                $('#subtot_tipo_4_'+cont).html('(SubTotal: $' + number_format(new_sbtl, $("#decimales").val()) + ')');
                $('#texto_val_tipo_4_'+cont).html('(Precio: $' + number_format(new_pric, $("#decimales").val()) + ')');
                $('#pre_fijo_uni_'+cont).val(new_pric);
                if (tipo_p == 4) {
                    $('#subtot_tipo_4_'+cont).show();
                    $('#texto_val_tipo_4_'+cont).show();
                } else {
                    $('#subtot_tipo_4_'+cont).hide();
                    $('#texto_val_tipo_4_'+cont).hide();
                }                
                $('#pre_fijo_uni_'+cont).hide();
                /*$("#txtSubtotal_"+cont).val(number_format(subtotal, $("#decimales").val()));
                $("#" + parent[0].id + " .delete_fila").val(subtotal);*/
                //calcularTotal("#tbMateriaPrima .trMateriaPrima", ".subtotalMateria", "#txtTotalMateria");
            }else if($(this).hasClass('ManoObra')){ //Mano de obra
                var resp_id = $("#empleado_edit_"+cont).val();
                if(resp_id>0){
                    $("#slcResponsable_"+cont).val(resp_id); 
                    var slcResponsableText = ($("#empleado_edit_"+cont+" option:selected").text()).trim();
                }else{
                     $("#slcResponsable_"+cont).val('');
                     var slcResponsableText = '-';
                }
                $("#empleado_edit_"+cont).select2("destroy").hide();
                $(".select-text"+cont).text(slcResponsableText);
            }else{
                $("#txtSubtotalGasto_"+cont).val(number_format(subtotal, $("#decimales").val()));
                $("#" + parent[0].id + " .delete_fila").val(subtotal);
            }

            $("#" + parent[0].id + " .edit").attr('readonly','readonly');
            $("#" + parent[0].id + " .edit").addClass('tables-input');
            $("#" + parent[0].id + " .editar_fila").show();
        }
    });
    /* ==================================================================================================
                            Fin de edicion de las filas
    ================================================================================================== */
    
    //GIF
    $("#slcEstimacion").change(function(event) {
        var esm_gif = $(this).val();
        if (esm_gif != "") {
            var monto = $("#slcEstimacion option:selected").data('monto');
            var esm_tipo_calculo = $("#slcEstimacion option:selected").data('valor');
            if($.trim(esm_tipo_calculo) != '') {
                if(esm_tipo_calculo > 0){
                    //Monto
                    var etapas = $("#slcEstimacion option:selected").data('etapas');
                    if (etapas > 0) {
                        var horas = get_ctdad_hora_mob_gif(0, esm_gif);
                        horas = (horas != "") ? horas : 1;
                        $("#txtCantidadGasto").val(horas);
                    }
                    $('#txtPrecioGasto').removeAttr('readonly');
                    $('#txtCantidadGasto').removeAttr('readonly');
                }else{
                    //Porcentaje
                    $('#txtPrecioGasto').removeAttr('readonly');
                    $("#txtCantidadGasto").val(1);
                    $('#txtCantidadGasto').attr('readonly',true);
                    var campo = $("#txtPrecioGasto").val();
                    if($.trim(campo) != ''){
                        var cantidad = parseFloat($("#txtPrecioGasto").val());
                        if (cantidad > 100) {
                            $("#txtPrecioGasto").val(number_format(100, decimales_monetarios,'.',''));
                            crear_alerta('error', 'Alerta', 'No se permite más del 100%');
                            return false;
                        }                    
                    }
                }
            }
            var decimales = $("#decimales").val();
            $("#txtPrecioGasto").val(number_format(monto, decimales_monetarios,'.',''));  
        } else {
            $("#txtPrecioGasto").val("");
            $("#txtCantidadGasto").val(1);
            $('#txtCantidadGasto').attr('readonly',true);
        }
    });
    
    //Borrar desde aca
    $("#det_articulo").change(function () {
        art_id = $(this).val();
        $.ajax({
            url: urlj + "proyectos/procesos/data_articulo",
            type: 'POST',
            dataType: 'json',
            data: {art_id: art_id},
            success: function (data) {
                $("#codigo").html(data.dato);
                var pre = $('#precio').val();
                $('#precio_art').val(pre);
            }
        });
    });

    $("#mano_obra").change(function () {
        mob_id = $(this).val();
        $.ajax({
            url: urlj + "proyectos/procesos/data_articulo",
            type: 'POST',
            dataType: 'json',
            data: {mob_id: mob_id},
            success: function (data) {
                $("#cod_obra").html(data.dato);
            }
        });
    });

    $("#estimacion").change(function () {
        esm_id = $(this).val();
        $.ajax({
            url: urlj + "proyectos/procesos/data_articulo",
            type: 'POST',
            dataType: 'json',
            data: {esm_id: esm_id},
            success: function (data) {
                $("#cod_esm").html(data.dato);
            }
        });
    });

    $("#slcMedida").change(function(){
        var defecto = ($.trim($('#slcMedida option[data-def=1]').data('conv')) != '')?$('#slcMedida option[data-def=1]').data('conv'):0;
        var convertir = ($.trim($('#slcMedida option:selected').data('conv')) != '')?$('#slcMedida option:selected').data('conv'):0;
        var precio_temp = $("#precio_temp").val();

        var precio = ($.trim($('#txtPrecio').val()) != '')?$('#txtPrecio').val():0;

        var tipo_precio = $.trim($('#slcTipoPrecio').val());
        var indice_convercion = defecto/convertir;
        var resultado = precio_temp*convertir;
        if(tipo_precio == ""){
            resultado = 0;
        }
        $('#txtPrecio').val(resultado);
        //console.log(resultado);
    });
    /* ===============================================================================================================
                                Botones de eliminar
    =============================================================================================================== */
    //Eliminar Materia Prima
    $(".btnDelMateriaPrima").live("click", function () {
        var parent = $(this).parent().parent().parent();
        var oTable = $('#tblMateriaPrima').dataTable();
        oTable.fnDeleteRow(parent[0]);
    });

    //Elimina Mano de Obra
    $(".btnDelManoObra").live("click", function () {
        var parent = $(this).parent().parent().parent();
        var oTable = $('#tblManoObra').dataTable();
        oTable.fnDeleteRow(parent[0]);
    });

    //Eliminar Gasto Indirectos
    $(".btnDelGasto").live("click", function () {
        var parent = $(this).parent().parent();
        var oTable = $('#tblGastos').dataTable();
        oTable.fnDeleteRow(parent[0]);
    });
    /* ===============================================================================================================
                                Fin de Botones de eliminar
    =============================================================================================================== */
    $(".aplicar_estimacion").live('click', function(){
        var id = $(this).attr('id');
        var subtotal_id = $(this).data('subtotal');
        var checkeado = $('#'+id+":checked").length;
        $(this).next().val(checkeado);
    })

    $("#allMat").live('click', function(){
        var checkeado = $('#allMat:checked').length;
        $(".est_materia").each(function(){
            var id_check = $(this).attr('id');
            if(checkeado == 1){
                $("#"+id_check).attr('checked','checked');
            } else{
                $("#"+id_check).removeAttr('checked');
            }
            $(this).next().val(checkeado);
        })
    })

    $("#allObr").live('click', function(){
        var checkeado = $('#allObr:checked').length;
        $(".est_mano").each(function(){
            var id_check = $(this).attr('id');
            if(checkeado == 1){
                $("#"+id_check).attr('checked','checked');
            } else{
                $("#"+id_check).removeAttr('checked');
            }
            $(this).next().val(checkeado);
        })
    });

}); /* === FIN DOCUMENT READY === */

function getOpcionesSelect(idElemento) {
    var opciones = "";
    $(idElemento + " option").each(function () {
        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        opciones += this.outerHTML;
    });
    return opciones;
}


function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}

function calcularTotal(idTbody, selectorMontos, idTxtTotal) {
    var total = 0;
    $(idTbody).each(function () {
        var subtotal = parseFloat($(this).find(selectorMontos).val().replace(/,/g, ""));
        total += subtotal;
    });
    $(idTxtTotal).val(number_format(total, 2));
    calcularTotalCostos();
}

function calcularTotalCostos() {
    var total = 0;
    var totalMateria = parseFloat($("#txtTotalMateria").val().replace(/,/g, ""));
    var totalManoObra = parseFloat($("#txtTotalManoObra").val().replace(/,/g, ""));
    var totalGastos = parseFloat($("#txtTotalGastos").val().replace(/,/g, ""));
    total = totalMateria + totalManoObra + totalGastos;
    $("#txtTotalCostos").val(number_format(total, 2));
}

function get_ctdad_hora_mob_gif(id_mob, id_gif) {
    var valor_horas = "";
    var id_art = $('#art_id').val();
    var id_cva = $('#cva_defecto').val();
    $.ajax({
        async: false,
        type: 'post',
        dataType: 'json',
        url: urlj + 'proyectos/mantenimientos/get_suma_horas_mob_gif',
        data: {
            art: id_art,
            cva: id_cva,
            mob: id_mob,
            gif: id_gif
        },
        beforeSend: function () {
            wait.start();
        },
        success: function (data) {
            var mob_val = parseFloat(data.ctdad_mob);
            var gif_val = parseFloat(data.ctdad_gif);
            if (mob_val > 0) {
                valor_horas = mob_val;
            }else if (gif_val > 0) {
                valor_horas = gif_val;
            }
            wait.close();
        }
    });
    return valor_horas;
}

function validar_codigo_nombre(valor, opcion){
    receta = $("#rea_id").val();
    producto = $("#art_id").val();
    if($.trim(valor) != "") {
        $.ajax({
            url: urlj + 'proyectos/mantenimientos/verificar_codigo_receta/' + opcion,
            type: 'POST',
            data: {
                codigo: valor,
                receta: receta,
                article: producto                
            },
            beforeSend: function() {
                wait.close('Verificando...');
            },
            success: function(data){
                if (data > 0) {
                    if (opcion > 1) {
                        var campo = "Nombre";
                        var orgnl = $("#nombre_receta_old").val();
                        var val_id = "nombre_receta";
                    } else {
                        var campo = "Código";
                        var orgnl = $("#codigo_receta_old").val();
                        var val_id = "codigo_receta";
                    }
                    crear_alerta('error', 'El ' + campo + ' ingresado ya existe.', 'Se revertirán los cambios.');
                    $("#" + val_id).val(orgnl);
                }
                wait.close();
            }
        });
    }
}
