$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $('select').select2({placeholder: 'Seleccione una opción'});
    $('.slcProducto').select2('destroy');
    $(".soloNumeros").numeric();
    $(".btn-close").live('click', function () {
        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    $("#frm-lotes").validate({
        ignore: [],
        rules: {
            slcProducto: {required: true},
            slcLotes: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#tblEtapas .trEtapas').length == 0) {
                crear_alerta('error', 'Etapas de Producción', 'Debe ingrear al menos una etapa.');
                return false;
            }

            if ($(".etapaFinal[value='1']").length == 0) {
                crear_alerta('error', 'Etapas de Producción', 'Debe agregar una etapa final en el listado.');
                return false;
            }

            var error = 0;
            $(".duracionEtapa").each(function () {
                if ($(this).val() == '') {
                    error++;
                }
            });


            if (error > 0) {
                crear_alerta('error', 'Etapas de Producción', 'Falta por ingresar una cantidad de tiempo de proceso.');
                return false;
            }

            $(".duracionMod").each(function () {
                if ($(this).val() == '') {
                    error++;
                }
            });

            if (error > 0) {
                crear_alerta('error', 'Etapas de Producción', 'Falta por ingresar una cantidad de tiempo de mano de obra directa (MOD).');
                return false;
            }

            if ( $("#txtcantidad").val() == "" ) {
                crear_alerta('error', 'Etapas de Producción', 'Ingrese la cantidad por favor.');
                $("#txtcantidad").focus();
                return false;
            }

            if ( $("#slc_medida").val() == "" ) {
                crear_alerta('error', 'Etapas de Producción', 'Seleccione una unidad de medida.');
                return false;
            }

            form.submit();
        }
    });

    $("#chkFinaliza").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        'resizeHandle': false,
        'resizeContainer': false,
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnFinaliza").val(1);
            } else {
                $("#hdnFinaliza").val(0);
            }
        }
    });

    var row = 0;
    if ($('#tblEtapas .trEtapas').length > 0) {
        row = $("#tblEtapas .trEtapas").length;
    }
    $("#btnAgregar").click(function () {
        var slcEtapas = $("#slcEtapas").val();
        var slcEtapasText = $("#slcEtapas option:selected").text();
        var slcEtapasBodega = $ ("#slcEtapas option:selected").data('bodega');
        var slcEtapasBodegaNombre = $("#slcEtapas option:selected").data('bodega-nombre');
        var etapaFinal = $("#hdnFinaliza").val();
        if (parseInt(etapaFinal) > 0) {
            if (!(parseInt(slcEtapasBodega) > 0)) {
                crear_alerta('error', 'Etapa Final', 'La etapa no posee una bodega.');
                return false;
            }
        }
        var dragClass = (slcEtapasBodega != '') ? '' : 'dragHandle showDragHandle';

        if (slcEtapas == '') {
            crear_alerta('info', 'Lotes', 'Debe seleccionar una etapa.');
            return false;
        }
        numEtapas = $("#tbEtapas .trEtapas").length;
        var numOrden = numEtapas + 1;
        var finalizaJob = (etapaFinal == 1) ? "X" : "";
        var classSort = (finalizaJob == "X") ? "nodrop" : "moverFila";

        if ($(".etapaFinal[value='1']").length > 0) {
            crear_alerta('info', 'Etapas de Producción', 'No es posible agregar una etapa cuando la etapa final ha sido establecida.');
            return false;
        }

        if ($(".numEtapa[value='" + slcEtapas + "']").length > 0) {
            crear_alerta('info', 'Etapas de Producción', 'La etapa ya fue ingresada.');
            return false;
        }

        var html = '';

        html += '<tr id="tr_' + row + '" class="trEtapas ' + classSort + '" data-id="' + row + '">';
        html += '<td>';
        html += '<input type="hidden" name="hdnDetalle[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input ordenFila" id="txtOrden_' + row + '" name="numOrden[]" value="' + numOrden + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="hidden" id="slcEtapas_' + row + '" name="etapas[]" class="numEtapa tables-input" value="' + slcEtapas + '" />';
        html += '<input type="text" class="text tables-input nombreEtapa" value="' + slcEtapasText + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtDuracion_' + row + '" name="duraciones[]" class="duracionEtapa text tables-input-show soloDecimales" value=""/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtObraDirecta_' + row + '" name="mod[]" class="duracionMod text tables-input-show soloDecimales" value=""/>';
        html += '</td>';

        html += '<td style="text-align: center;">';
        html += '<input type="hidden" name="hdnFinaliza[]" class="tables-input etapaFinal" value="' + etapaFinal + '" />';
        html += '<label id="lblFinaliza_' + row + '">' + finalizaJob + '</label>';
        html += '</td>';

        html += '<td>';
        html += '<label class="text tables-input bodegaFila"> ' + slcEtapasBodegaNombre + '</label>';
        html += '</td>';

        html += '<td class="" style="text-align: center;">';
        if (etapaFinal != 1) {
            //html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd btnTable moveRow" value="up"><span class="icomoon-icon-arrow-up-7"></button>';
            html += '<button type="button" class="btn btn dragHandle showDragHandle btnTable" value="down"></button>';
        }
        html += '<button type="button" class="btn btn-danger btn-mini btnDelProd btnTable"><span class="white icomoon-icon-remove"></button>';
        html += '</td>';

        html += '</tr>';

        //Se destruye el datatable para luego volver a crearla
        //var oTable = $('#tblEtapas').dataTable();
        //oTable.fnDestroy();
        if ($("#tblEtapas .trEtapas").length == 0) {
            $("#tbEtapas").html('');
        }
        $("#tbEtapas").append(html);
        //aplicarDataTable('#tblEtapas');
        row = row + 1;

        $("#slcEtapas option:selected").removeAttr('selected');
        $("#slcEtapas").select2({placeholder: "Seleccione una opción"});
        $("#txtCantidad").val('');

        $("#tblEtapas").tableDnD({
            dragHandle: ".dragHandle",
            onDragClass: "dragContent",
            onDrop: function (table, row) {
                calcularOrden();
            }
        });
    });//En of function agregar


    //Eliminar Producto
    $("body").on('click', '.btnDelProd', function () {
        var parent = $(this).parent().parent();
        //var oTable = $('#tblEtapas').dataTable();
        //oTable.fnDeleteRow(parent[0]);
        //calcularTotal();
        $("#" + parent[0].id).remove().delay(300);
        calcularOrden();
    });

    $("body").on('click', '.moveRow', function () {
        var direccion = $(this).val();
        var trParent = $(this).parent().parent();

        //moverFila(trParent[0], direccion);
    });
    $("body").on('click', '.up,.down', function () {
        //$(".up,.down").click(function () {

        var $element = this;
        var row = $($element).parents("tr:first");

        if ($(this).val() == 'up') {
            row.insertBefore(row.prev());
        } else {
            row.insertAfter(row.next());
        }

    });
});

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function cerrar_modal() {
    //alert('asdasd');
    jQuery.fancybox.close();
}

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
        "iDisplayLength": 20
    });
}

function limpiarTabla(producto) {
    $("#hdnSelectProducto").val(producto);
    $('#slcProduccion option[value=' + $("#hdnSelectProducto").val() + ']').attr('selected', 'selected');
    $('#slcProduccion').select2({placeholder: "Seleccione una opción"});
    $("#tblEtapas").html('<tr><td colspan="8">No se encontraron registros</td></tr>');
    cargarLotes(producto);
}

function calcularTotal() {
    var totalLotes = 0;

    $("#tbProductos .trProducto").each(function () {
        var cantidad = parseFloat($(this).find('.cantidadProducto').val());

        totalLotes += cantidad;
    });

    $("#txtTotalLotes").val(number_format(totalLotes, 2));
}

function calcularOrden() {
    var Orden = 1;
    $(".moverFila").each(function () {
        $(this).find('.ordenFila').val(Orden);

        Orden++;
    });

    $(".nodrop .ordenFila").val(Orden);
}