$(document).ready(function (){

	$('select').select2({placeholder: "Seleccione una opción"});

    var row = 0;
    if ($('#tbFactorCalidad .trDetalle').length > 0) {
        row = $("#tbDetalles .trDetalle").length;
    }

    $("body").on("change", "#slcFactor",function() {
        var unidad = $('#slcFactor option:selected').data('unidad');
        $('#txtUnidad').val(unidad);
    });

    //Eliminar factor de calidad por producto
    $("body").on('click', '.btnDelProd', function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id).remove().delay(300);
    });

    $("#frm-factores").validate({    	
        submitHandler: function (form){
        	if ($('#tblFactorCalidad .trDetalle').length == 0) {
                crear_alerta('error', 'Factores de calidad', 'Debe ingresar al menos un factor de calidad.');
                return false;
            }
            form.submit();
        }
    });

    $("#btnAgregar").click(function () {
        var slcFactor = $("#slcFactor").val();
        var slcFactorText = $("#slcFactor option:selected").text();
        var unidad = $("#txtUnidad").val();
        var referencia = $("#txtReferencia").val();
        if (!(slcFactor != "")) {
            crear_alerta('warning', 'Factor', 'Debe seleccionar un factor de calidad.');
            return false;
        }
        var html = '<tr id="tr_Detalle_' + row + '" class="trDetalle">';
		html += '<td>';
        html += '<input type="hidden" id="slcFactor' + row + '" name="factores[]" class="factor tables-input" value="' + slcFactor + '" />';
        html += '<input type="text" class="text tables-input factor" value="' + slcFactorText + '" readonly="readonly"/>';
        html += '</td>';
        html += '<td>';
        html += '<input type="text" id="txtTablaUnidad_' + row + '" name="unidades[]" class="unidad  text tables-input" value="' + unidad + '"/>';
        html += '</td>';
        html += '<td>';
        html += '<input type="text" id="txtTablaReferencia_' + row + '" name="referencias[]" class="referencia text tables-input" value="' + referencia + '"/>';
        html += '</td>';
        html += '<td style="text-align: center;">';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelProd btnTable"><span class="white icomoon-icon-remove"></button>';
        html += '</td>';
        html += '</tr>';
        if ($("#tblFactorCalidad .trDetalle").length == 0) {
        	$("#tbFactorCalidad").html('');
        }
        $("#tbFactorCalidad").append(html);
        row = row + 1;
        $("#slcFactor option:selected").removeAttr('selected');
        $("#slcFactor").select2({placeholder: "Seleccione una opción"});
        $("#txtReferencia").val('');
        $("#txtUnidad").val('');
    });

});


function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}	
