$(document).ready(function () {
    var decimales           = parseInt($("#txt_decimales").val());
    var correlativo_global  = parseInt($("#txt_correlativo_global").val()); 
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione'});

    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#btn_agregar").click(function () { 
        event.preventDefault();
        var etapa       = $("#slc_etapas option:selected").val();
        var cantidad    = $("#txt_cantidad").val();

        if (cantidad == "" || cantidad == 0) {
            crear_alerta('error', 'Etapas analíticas', 'Agregue cantidad por favor.');
            return false;
        }

        if (etapa == "") {
            crear_alerta('error', 'Etapas analíticas', 'Seleccione una etapa por favor.');
            return false;
        }
        
        var correlativo = $('#tb_analisis tr').length + 1;
        var nombre_etapa= $("#slc_etapas option:selected").text();
        var tiempo      = $('#slc_etapas option:selected').data('tiempo');
        var distancia   = $('#slc_etapas option:selected').data('distancia');
        var proceso     = $('#slc_etapas option:selected').data('proceso');
        var proceso_nom = "";
        switch(proceso) {
            case 1:
                proceso_nom = "Operación";
                break;
            case 2:
                proceso_nom = "Inspección";
                break;
            case 3:
                proceso_nom = "Demora";
                break;
            case 4:
                proceso_nom = "Transporte";
                break;
            case 5:
                proceso_nom = "Almacenamiento";
                break;
        }
        correlativo_global++;
        var html = "";
        html    += '<tr>';
            html    += '<td style="width: 5%;">';
                html    += ' <label class="correlativo_etapa">'+correlativo+'</label>';
                html    += '<input type="hidden" class="correlativo_etapa_txt" id="tbl_orden_'+correlativo_global+'" name="tbl_orden[]" value="'+correlativo+'" readonly>';
                html    += '<input type="hidden" id="tbl_etapaxcursograma_'+correlativo_global+'" name="tbl_etapaxcursograma[]" value="" readonly>';
            html    += '</td>';            
            html    += '<td style="width: 15%;">';
                html    += nombre_etapa;
                html    += '<input type="hidden" id="tbl_actividad_'+correlativo_global+'" name="tbl_etapa[]" value="'+etapa+'" readonly>';
            html    += '</td>';            
            html    += '<td style="width: 5%;"><input type="text" id="tbl_cantidad_'+correlativo_global+'" name="tbl_cantidad[]" value="'+cantidad+'" class="soloDecimales tbl_cantidades" decimales="'+decimales+'" maxlength="19"></td>';
            html    += '<td style="width: 10%;"><input type="text" id="tbl_tiempo_'+correlativo_global+'" name="tbl_tiempo[]" value="'+tiempo+'" class="soloDecimales" decimales="'+decimales+'" maxlength="19"></td>';
            html    += '<td style="width: 15%;"><input type="text" id="tbl_distancia_'+correlativo_global+'" name="tbl_distancia[]" value="'+distancia+'" class="soloDecimales" decimales="'+decimales+'" maxlength="19"></td>';
            html    += '<td style="width: 15%;">'+proceso_nom+'<input type="hidden" id="tbl_proceso_'+correlativo_global+'" name="tbl_proceso[]" value="'+proceso+'" readonly></td>';
            html    += '<td style="width: 25%;"><input type="text" id="tbl_observacion_'+correlativo_global+'" name="tbl_observacion[]" value="" maxlength="100"></td>';
            html    += '<td style="width: 10%;">';
                html    += '<button type="button" class="btn btn-danger btn-mini btn_del_etapa" style="float:left; height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
            html    += '</td>';
        html    += '</tr>';

        $("#tb_analisis").append(html);
        
        $('#slc_etapas option:selected').removeAttr('selected');
        $('#slc_etapas').select2({placeholder: 'Seleccione'});

        $("#txt_cantidad").val("");

    });

    $('#tbl_analisis tbody').on('click', '.btn_del_etapa', function () {
        $(this).parent().parent().remove();
        actualizar_correlativo();
    });

    $("#frm_estapas").validate({
        ignore: [],
        rules: {
            txt_codigo: {required: true},
            txt_fecha: {required: true},
            txt_lugar: {required: true},
            slc_responsable: {required: true},
            txt_actividad: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        invalidHandler: function (form, validator) {
            var errors = validator.numberOfInvalids();
            if (errors) {
                var primerElemento = validator.errorList[0].element;
                var posiciones = primerElemento.offsetTop;
                $("html, body").animate({scrollTop: posiciones}, 1000);
            }
        },
        submitHandler: function (form) {
            wait.start();
            var error = false;

            if ($('#tb_analisis tr').length == 0) {
                crear_alerta('error', 'Cursograma analítico', 'Debe ingresar al menos una etapas analíticas.');
                wait.close();
                return false;
            }

            $("#tb_analisis tr").each(function () {
                if ( $( this ).find( ".tbl_cantidades").val() == "" || $( this ).find( ".tbl_cantidades").val() == "0" ) {
                    $( this ).find( ".tbl_cantidades").focus();
                    error = true;
                    return false;
                }
            });

            if ( error == true) {
                crear_alerta('error', 'Cursograma analítico', 'Debe agregar una cantidad.');
                wait.close();
                return false;
            }

            form.submit();
        }
    });

    function actualizar_correlativo(){
        var contador = 0;
        $("#tb_analisis tr").each(function () {
            contador++;
            $( this ).find( ".correlativo_etapa").empty();
            $( this ).find( ".correlativo_etapa").text(contador);
            $( this ).find( ".correlativo_etapa_txt").val(contador);
        });
    }

});