jQuery(document).ready(function () {
    $('select').select2({placeholder: "Seleccione"});
    $("#exportar").hide();

    $(".fecha").datepicker({
        dateFormat: 'dd-mm-yy',
        changeMonth: true, 
        changeYear: true,
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior"});
    $(".fecha").mask("99-99-9999");

    $("#ver_detalle").click(function (event){
        $("#exportar").hide();
        var inicio = $("#txtFechaInicio").val();
        var fin = $("#txtFechaFin").val();
        var ingreso = ($.isArray($("#slcIngreso").val())) ? $("#slcIngreso").val().toString() : "";
        var empleado = $("#slcEmpleado").val();     
        if(inicio != '' && fin != ''){
            $("#contenedor_consulta").hide("slide", { direction: 'right' }, 400, function () {
                if(!verifica_fecha(inicio, fin)){  
                    wait.close();    
                    return false; 
                }
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: urlj+'personal/reportes/rpt_ingresos_mensuales/1',
                    data: {
                        fecha_ini: inicio, 
                        fecha_fin: fin, 
                        tipo_ingr: ingreso, 
                        filt_empl: empleado,
                        tipo_reporte: ""
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (data) {
                        $("#contenedor_consulta").html(data.tabla);
                        if (data.filas > 0) {
                            $("#fecha_ini").val(inicio);
                            $("#fecha_fin").val(fin);
                            $("#tipo_ingr").val(ingreso);
                            $("#filt_empl").val(empleado);
                            $("#exportar").show();
                        }
                        $("#contenedor_consulta").show("slide", { direction: 'left' }, 500);
                        wait.close();
                    },
                    error: function (xhr, status, error) {
                        wait.close();
                        console.log(xhr);
                        console.log(status);
                        console.log(error);
                        crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
                    }
                });
            });
        }else{
            crear_alerta('error','Error', 'Debe seleccionar la información a filtrar');
        }
    });
   

    // $("#exportar").val(0);



}); // End jQuery

function verifica_fecha(fecha_ini, fecha_fin){
    //Se convierte la fecha a Y-m-d
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if(Date.parse(fecha_i) == Date.parse(fecha_f)){
        $("#txtFechaFin_error").text(''); 
        return true;
    }
    if(Date.parse(fecha_i) > Date.parse(fecha_f)){
        crear_alerta('error','Error','Verifique las fechas del período');
        return false;
    }
    if(Date.parse(fecha_i) < Date.parse(fecha_f)){
        $("#fecha_fin_error").text('');
        return true;
    }
}