$(document).ready(function () {

    $("select").select2({placeholder: "Seleccione"});

    $("#todo_empleado").change(function(event) {
        if($(this).prop('checked')) {
            $("#slc_emp option[value !='']").attr('selected','selected');
            $("#slc_emp").select2();
        } else {
            $("#slc_emp option").removeAttr('selected')
            $("#slc_emp").select2();
        }
    });

    $("#todo_ingreso").change(function(event) {
        if($(this).prop('checked')) {
            $("#slc_inn option[value !='']").attr('selected','selected');
            $("#slc_inn").select2();
        } else {
            $("#slc_inn option").removeAttr('selected')
            $("#slc_inn").select2();
        }
    });

    $("#todo_planillas").change(function(event) {
        if($(this).prop('checked')){
            $("#slc_tpl option[value !='']").attr('selected','selected');
            $("#slc_tpl").select2();
        } else {
            $("#slc_tpl option").removeAttr('selected')
            $("#slc_tpl").select2();
        }
    });

    $("body").on("change", ".slc_stado_emp", function(event){
        var valor_estados = $(this).val();
        $.ajax({
            type: 'POST',
            url: urlj + 'personal/reportes/get_empleado_x_stado',
            data: {
                estado: valor_estados
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#slc_emp").html(data);
                $("#slc_emp").select2({placeholder: "Seleccione"});
                wait.close();
            },
            error: function (xhr, status, error) {
                wait.close();
                console.log(xhr);
                console.log(status);
                console.log(error);
                crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
            }
        });
    });

    $("body").on("click", "#ver_detalle", function(event){
        $("#exportar").hide();
        var year = $("#slc_year").val();
        var valor_ingresos = $("#slc_inn").val();
        var valor_empleado = $("#slc_emp").val();
        var valor_planilla = $("#slc_tpl").val();
        var ingreso   = ($.isArray(valor_ingresos)) ? valor_ingresos.toString() : "";
        var empleado  = ($.isArray(valor_empleado)) ? valor_empleado.toString() : "";
        var tplanilla = ($.isArray(valor_planilla)) ? valor_planilla.toString() : "";
        var emp_stat  = $('input:radio[name=emp_estado]:checked').val();
        if(year != ''){
            $("#contenedor_consulta").hide("slide", { direction: 'right' }, 400, function () {
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: urlj + 'personal/reportes/rpt_ingresos_anuales/1',
                    data: {
                        slct_year: year, 
                        slct_inns: ingreso, 
                        slct_emps: empleado,
                        slct_stat: emp_stat,
                        slct_tpla: tplanilla,
                        tipo_reporte: ""
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (data) {
                        $("#contenedor_consulta").html(data.tabla);
                        if (data.filas > 0) {
                            $("#slct_year").val(year);
                            $("#slct_inns").val(ingreso);
                            $("#slct_emps").val(empleado);
                            $("#slct_stat").val(emp_stat);
                            $("#slct_tpla").val(tplanilla);
                            $("#exportar").show();
                        }
                        $("#contenedor_consulta").show("slide", { direction: 'left' }, 500);
                        wait.close();
                    },
                    error: function (xhr, status, error) {
                        wait.close();
                        console.log(xhr);
                        console.log(status);
                        console.log(error);
                        crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
                    }
                });
            });
        }else{
            crear_alerta('error','Error', 'Debe seleccionar la información a filtrar');
        }
    });


});
