jQuery(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');
    $('select').select2();

    $(".fecha").datepicker({
        dateFormat: 'dd-mm-yy',
        changeMonth: true, 
        changeYear: true,
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior"});
    $(".fecha").mask("99-99-9999");
    $(".fecha").attr('placeholder',"dd-mm-yyyy");

    $("#slcArea").change(function(event) {
        var area = $(this).val(); 
        if(area>0){
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: urlj+'expediente_personal/reportes/get_empleado',
                data: {area: area},
                beforeSend: function(){
                $("#slcEmpleado").attr("placeholder", "Cargando...");
                $("#slcEmpleado").select2();
              },
                success: function (data) {
                    $("#slcEmpleado").html(data.lista);
                    $("#slcEmpleado").attr("placeholder", "Seleccione");
                    $("#slcEmpleado").select2(); 
                    wait.close();
                },
                error: function (xhr, status, error) {
                    wait.close();
                    console.log(xhr);
                    console.log(status);
                    console.log(error);
                    crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
                }
            });
        }else{
            $("#slcEmpleado").attr("placeholder", "Seleccione");
            $("#slcEmpleado").html('<option value=""></option>');
            $("#slcEmpleado option:first").attr('selected','selected');
            $("#slcEmpleado").select2();
        }
    });

    $("#ver_detalle").click(function (event){
        var area = $("#slcArea").val();
        var empleado = $("#slcEmpleado").val();
        var fecha = $("#txtFecha").val();

      
        if(area!='' && fecha!=''){
            consultarAjax(area,empleado, fecha);
        }else{
            crear_alerta('error','Error', 'Debe llenar los filtros requeridos.');
        }
    }); // Fin if consultar_datos


   
    $("#excel_en").click(function(event){
        event.preventDefault();
        tipo=$(this).attr('value');
        $("#tipo_reporte").val(tipo)
        $("#excel").trigger('click');
    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
        event.preventDefault();
        if($("#exportar").val()==1){
            $("#frm-report").submit();
        }else{
            crear_alerta('error','Información', 'Debe filtrar la información a buscar');
        }
    });

}); // End jQuery

function consultarAjax(area=null, empleado=null, fecha=null) {
    wait.start();
    $("#contenedor_consulta").hide("slide", {
        direction: 'right'
    }, 400, function () { // Después de ocultar div enviar el ajax

        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'personal/reportes/rpt_horario',
            data: {area: area, empleado: empleado, fecha: fecha},
            success: function (data) {
                $("#contenedor_consulta").html(data.resultado);
                wait.close();
                $("#ver_detalle").removeAttr('disabled');
                $("#exportar").val(1);

                $("#filtro_empleado").val(data.empleado);
                $("#filtro_fecha").val(data.fecha);
                $("#filtro_area").val(data.area);

                $("#contenedor_consulta").show("slide", {
                    direction: 'left'
                }, 500);
            },
            error: function (xhr, status, error) {
                wait.close();
                console.log(xhr);
                console.log(status);
                console.log(error);
                crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
            }
        });
    });
}

