var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;
var meses = {
    'Enero': '01', 
    'Febrero': '02', 
    'Marzo': '03', 
    'Abril': '04', 
    'Mayo': '05', 
    'Junio': '06', 
    'Julio': '07', 
    'Agosto': '08', 
    'Septiembre': '09', 
    'Octubre': '10',  
    'Noviembre': '11', 
    'Diciembre': '12'
};
var months = {
    '0': 'Enero',
    '1': 'Febrero',
    '2': 'Marzo',
    '3': 'Abril',
    '4': 'Mayo',
    '5': 'Junio',
    '6': 'Julio',
    '7': 'Agosto',
    '8': 'Septiembre',
    '9': 'Octubre',
    '10': 'Noviembre',
    '11': 'Diciembre'
};

$(document).ready(function(){
	$('select').select2();
    
    $(".fechas").datepicker({
        dateFormat: 'MM-yy',
        currentText: "Mes Actual",
        closeText: 'Seleccionar',
        prevText: '<Ant',
        nextText: 'Sig>',        
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        onClose: function(dateText, inst) {
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });
    $(".fechas").attr('placeholder',"mm-yyyy");
    // Ocultar el calendario para solo mostrar el mes
    $(".fechas").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });    
    var hoy = new Date();
    var mes = hoy.getMonth();
    var ann = hoy.getFullYear();
    var now = months[mes]+'-'+ann;
    $("#mes_desde, #mes_hasta").val(now);

    $("#txtFechaInicio, #txtFechaFin").mask('99-99-9999');

    $("#btn-generar").click(function(event) {
        event.preventDefault();
        $(".btnxport").hide();
        var mes_start = $("#mes_desde").val();
        var mes_final = $("#mes_hasta").val();
        var valido  = valida_meses($("#mes_desde").val(), $("#mes_hasta").val());
        var tipo_pla = $("#tipo_planilla").val();
        var periodos = ($.isArray($("#periodos").val()) && $("#periodos").val() != null) ? $("#periodos").val().toString() : "";
        var descuento = ($.isArray($("#tipo_descuento").val()) && $("#tipo_descuento").val() != null) ? $("#tipo_descuento").val().toString() : "";
        if (descuento != "" && mes_start != "" && mes_final != "" && valido) {
            var f1 = mes_start.split('-');
            var f2 = mes_final.split('-');
            var mes1 = meses[f1[0]];
            var mes2 = meses[f2[0]];
            var ultimo = ult_dia(mes2,f2[1]);
            var fecha_ini = f1[1] + '-' + mes1 + '-01';
            var fecha_fin = f2[1] + '-' + mes2 + '-' + ultimo;
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: urlj + 'personal/reportes/get_reporte_detalle_descuento',
                data: { 
                    tipo_reporte: "",
                    fecha_ini: fecha_ini, 
                    fecha_fin: fecha_fin,
                    tipo_pla: tipo_pla,
                    periodo: periodos,
                    descuento: descuento
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (datos) {
                    console.log(datos);
                    $("#contenido").html(datos.tabla);
                    if (datos.filas > 0) {
                        $("#fecha_ini").val(fecha_ini);
                        $("#fecha_fin").val(fecha_fin);
                        $("#tipo_pla").val(tipo_pla);
                        $("#periodo").val(periodos);
                        $("#descuento").val(descuento);
                        $(".btnxport").show();
                    }
                    wait.close();
                },
                error: function (xhr, status, error) {
                    wait.close();
                    crear_alerta('error', 'Error', 'Ocurrió un problema al realizar la operación');
                }
            });
        } else {
            if (valido) {
                crear_alerta('error', 'Verifique los campos requeridos', '');
            } else {
                crear_alerta('error', 'Verifique el período ingresado', '');
            }
            return false;
        }        
    });

    $("#todo_tipo").change(function(event) {
        if($(this).prop('checked')) {
            $("#tipo_descuento option[value !='']").attr('selected','selected');
            $("#tipo_descuento").select2();
        } else {
            $("#tipo_descuento option").removeAttr('selected');
            $("#tipo_descuento").select2();
        }
    });

    $("#tipo_planilla").change(function() {
        tipo_planilla = $('#tipo_planilla').val();
        if (tipo_planilla > 0) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj+'personal/reportes/obtener_periodo_planilla',
                data: {
                    t_planilla: tipo_planilla,
                    tipo: 1
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function(data){
                    $("#periodos").html('<option value=""></option>' + data.drop);
                    $("#periodos").removeAttr('disabled');
                    $("#periodos").select2();
                    wait.close();
                }
            });
        } else {
            $("#periodos").val([]).change();
            $("#periodos").html('<option value=""></option>');
            $('#periodos').select2('disable');
        }
    });
	
});



function valida_meses() {
    fecha_ini = $("#mes_desde").val();
    fecha_fin = $("#mes_hasta").val();
    if (fecha_ini != "" && fecha_fin != "") {
        var start = fecha_ini.split("-");
        var final = fecha_fin.split("-");
        var mes_ini = start[1] + '-' + meses[start[0]] + '-01';
        var mes_fin = final[1] + '-' + meses[final[0]] + '-01';
        if (Date.parse(mes_ini) > Date.parse(mes_fin)) {
            return false;
        } else {
            return true;
        }    
    }
}

function ult_dia(mes, anio) {
    if (mes.charAt(0) == '0') {
        mes = mes.charAt(1);
    }
    mes = parseInt(mes);
    anio = parseInt(anio);
    switch (mes) {
        case 1 : case 3 : case 5 : case 7 : case 8 : case 10 : case 12 : return 31;
        case 2 : return (anio % 4 == 0) ? 29 : 28;
    }
    return 30;
}