jQuery(document).ready(function () {

    $('select').select2({placeholder: 'Seleccione'});

    $("#year").datepicker({
        changeYear: true,
        changeMonth: false,
        showButtonPanel: true,
        dateFormat: 'yy',
        closeText: 'Seleccionar',
        currentText: 'Actual',
        onClose: function(dateText, inst) { 
            var year = $("#ui-datepicker-div .ui-datepicker-year :selected").val();
            $(this).datepicker('setDate', new Date(year, 1));
        }
    });

    $("#year").focus(function () {
        $(".ui-datepicker-month").hide();
        $("a.ui-datepicker-prev, a.ui-datepicker-next").hide();
    });

    $("#ver_detalle").click(function (event){
        var periodos = $("#year").val();
        var tipo_plan = $("#slcTipo").val();
        var recalculo = $("#slcRecal").val();
        var empleado = $("#slcEmp").val();
        if( periodos != '' && tipo_plan != '' && recalculo != ''){
            consultarAjax(periodos, tipo_plan, recalculo, empleado);
        }else{
            crear_alerta('error','Error', 'Debe seleccionar la información requerida');
        }
    });

// function() {
    // $("#excel_en").click(function(event){
    //     event.preventDefault();
    //     tipo=$(this).attr('value');
    //     $("#tipo_reporte").val(tipo)
    //     $("#excel").trigger('click');
    // });

    // $("#exportar").val(0);

    $(".exportar").click(function(event){
        event.preventDefault();
        if($("#exportar").val() == 1){
            $("#frm-report").submit();
        }else{
            crear_alerta('error','Información', 'Debe filtrar la información a buscar');
        }
    });

    // $(".fecha").datepicker({
        // dateFormat: 'dd-mm-yy',
        // changeMonth: true, 
        // changeYear: true,
        // showButtonPanel: true,
        // changeMonth: true,
        // changeYear: true,
        // dateFormat: 'dd-mm-yy',
        // monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        // dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        // nextText: "Siguiente",
        // prevText: "Anterior"
    // });
    // $(".fecha").mask("99-99-9999");
    // $(".fecha").attr('placeholder',"dd-mm-yyyy");    

    // $("#txtFechaInicio").change(function (){
    //     if ( $(this).val().substr(0,2) != "01" ){
    //         var fecha = $(this).val().substr(2);
    //         $(this).val("01"+fecha);
    //         crear_alerta('info', 'Fecha de inicio', "La fecha inicio debe ser el primero de cada mes.");
    //     } 
    //     var facha_inicio    = $(this).val();
    //     var fecha_array     = facha_inicio.split('-');
    //     var date            = new Date(fecha_array[1]+"-"+fecha_array[0]+"-"+fecha_array[2]);
    //     var ultimoDia       = new Date(date.getFullYear(), date.getMonth() + 1, 0);     
    //     var dia     = ultimoDia.getDate();
    //     var mes     = ultimoDia.getMonth() + 1;
    //     var year    = ultimoDia.getFullYear();
    //     var hasta   = ('00' + dia).slice(-2) + "-" + ('00' + mes).slice(-2) + "-" + year;         
    //     $("#txtFechaFin").val(hasta);
    //     var meses   = ["Enero", "Febreo", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];    
    // });

    // $("#txtFechaFin").change(function (){
    //     var facha_fin = $(this).val();
    //     var fecha_array  = facha_fin.split('-');
    //     var date         = new Date(fecha_array[2],fecha_array[1], 0).getDate();        
    //     if ( $(this).val().substr(0,2) != date){
    //         var fecha = $(this).val().substr(2);
    //         $(this).val(date+fecha);
    //         crear_alerta('info', 'Fecha fin', "La fecha fin debe ser el último de cada mes.");
    //     } 
    // });
// }
    


}); // End jQuery

function consultarAjax(anio = null, tipo = null, rec = null, emp = null) {
    wait.start();
    $("#acciones").css('display', 'none');
    $("#contenedor_consulta").hide("slide", {
        direction: 'right'
    }, 400, function () {
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'personal/reportes/renta_complementaria',
            data: {
                year: anio, 
                tipo: tipo, 
                recalculo: rec,
                empleado: emp
            },
            success: function (data) {
                $("#contenedor_consulta").html(data.resultado);
                wait.close();
                $("#acciones").css('display', "");
                $("#exportar").val(1);

                $("#filtro_year").val(data.anio);
                $("#filtro_tipo").val(data.tipo_planilla);
                $("#filtro_recalculo").val(data.recalculo);
                $("#filtro_empleado").val(data.empleado);

                $("#contenedor_consulta").show("slide", {
                    direction: 'left'
                }, 500);
            },
            error: function (xhr, status, error) {
                $("#exportar").val(0);
                $("#acciones").css('display', 'none');
                wait.close();
                console.log(xhr);
                console.log(status);
                console.log(error);
                crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
            }
        });
    });
}
