$(document).ready(function () {
    $("#docente, #area, #frecuencia, #proyeccion").select2();
    $("input[type='text']").addClass("todo_mayuscula");
    $("textarea").addClass("todo_mayuscula");



    $("#area").change(function (event) {
        var area = $(this).val();

        if ($(this).val() > 0) {
            $.ajax({
                url: urlj + "registro_academico/procesos/cargar_select_proyeccion",
                type: 'POST',
                data: {area: area},
                dataType: 'json',
                beforeSend: function () {
                    $("#proyeccion").attr("placeholder", "Cargando...");
                    $("#proyeccion").attr('disabled', 'disabled');
                    $("#proyeccion").select2();
                },
                error: function (xhr, status, error) {
                    exportarError(xhr.responseText);
                },
                success: function (json) {
                    wait.close();
                    $('#proyeccion').html(json);
                    $("#proyeccion").attr("placeholder", "Seleccione");
                    $("#proyeccion").removeAttr('disabled');
                    $("#proyeccion").select2();
                }
            });

            $.ajax({
                url: urlj + "registro_academico/procesos/get_frecuencias",
                type: 'POST',
                data: {area: area},
                dataType: 'json',
                beforeSend: function () {
                    $("#frecuencia").attr("placeholder", "Cargando...");
                    $("#frecuencia").attr('disabled', 'disabled');
                    $("#frecuencia").select2();
                },
                error: function (xhr, status, error) {
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $('#frecuencia').html(json);
                    $("#frecuencia").attr("placeholder", "Seleccione");
                    $("#frecuencia").removeAttr('disabled');
                    $("#frecuencia").select2();
                }
            });
        } else {
            $("#proyeccion").val(0);
            $("#proyeccion").select2();
            $("#frecuencia").val();
            $("#frecuencia").select2();
        }
    });

    $("#proyeccion").change(function (event) {
        var proyeccion = $("#proyeccion").val();
        $.ajax({
            url: urlj + "registro_academico/procesos/cargar_proyeccion_nivel",
            type: 'POST',
            data: {proyeccion: proyeccion},
            dataType: 'json',
            beforeSend: function () {
                $("#nivel").attr("placeholder", "Cargando...");
                $("#nivel").attr('disabled', 'disabled');
                $("#nivel").select2();
            },
            error: function (xhr, status, error) {
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                $('#nivel').html(json);
                $("#nivel").attr("placeholder", "Seleccione");
                $("#nivel").removeAttr('disabled');
                $("#nivel").select2();

            }
        });
    });

    $("#nivel").change(function (event) {
        var nivel = $(this).val();
        var area = $("#area").val();
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.gSateliteWhite.baseUrl('registro_academico/mantenimientos/get_horarioxnivel'),
            data: {nivel: nivel, area: area},
            success: function (data) {
                console.log(nivel);
                console.log(area);
                $('#horario').html(data.horarios);
                $("#horario").select2();
            }
        });
    });

    $("#consultar").click(function (event) {
        event.preventDefault();

        var area = $("#area").val();
        var docente = $("#docente").val();
        var frecuencia = $("#frecuencia").val();
        var proyeccion = $("#proyeccion").val();
        var fecha = $("#fecha").val();

        if(docente !=''){
            cargarInfoDocente(docente);
        }

        wait.start();
        $("#contenedor_index").hide("slide", {
            direction: 'right'
        }, 400, function () { //despues de ocultar div enviar el ajax
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('personal/planilla/configuracion_pago_docente'),
                data: {area: area, docente: docente, frecuencia: frecuencia, fecha: fecha, proyeccion: proyeccion},
                success: function (data) {
                    var oTable = $('#datagried1').dataTable();
                    oTable.fnDestroy();
                    $("#consulta_table").html(data);
                    $('#datagried1').dataTable({"iDisplayLength": 5, "sPaginationType": "full_numbers"});
                    var contador = 1;
                    while (contador < 4) {
                        $("#datagried" + contador + "_length select").html("<option value='5'>5</option>");
                        $("#datagried" + contador + "_length select").append("<option value='10'>10</option>");
                        $("#datagried" + contador + "_length select").append("<option value='15'>15</option>");
                        $("#datagried" + contador + "_length select").append("<option value='20'  selected='selected' >20</option>");
                        contador++;
                    }
                    setTimeout(function () {
                        $('#datagried1_length select').trigger('change');
                    }, 200);
                    $('#datagried1').css('width', '100%');
                    wait.close();
                    $("#contenedor_index").show("slide", {
                        direction: 'left'
                    }, 500);
                    $("#btnCrear").removeAttr('disabled');
                    $("#dvAcciones").show(500);

                    if(docente!=''){
                        $("#dvAplicaGeneral").show();
                        $("#chkAplicarGeneral").iButton({
                            'labelOn': 'Si',
                            'labelOff': 'No',
                            change: function (element) {
                                if (element.is(':checked')) {
                                    $("#hdnAplicarGeneral").val(1);
                                } else {
                                    $("#hdnAplicarGeneral").val(0);
                                }
                            }
                        });
                    }
                }
            });
        });
    });
    
    $(".configuracion").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
              var grupo = $(this.element[0]).attr('data-grupo');
              $("#modalConfiguracion_" + grupo + " select").select2();
        },
        beforeClose: function () {
//            $("#hdnElementoOculto").val('');
//            $("#lblSelect").text('');
//            $("#slcMultiCargos").html('');
//            $("#slcMultiCargos").select2('destroy');
        }
    });

    $("body").on('click','.btnCerrarModal', function(){
        $.fancybox.close();
    });

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width: '100%',
            closeBtn: true,
            height: '100%'
        });
    });

    $("#btnCrear").click(function(){

        totalGrupos = $('select[class*="combotipoPlanilla"]').filter(function(){ return  $(this).val() > 0; }).length;

        if($("#hdnAplicarGeneral").val() == 1 && $("#slcTipoPlanilla").val() > 0){

            let totalAgregar = $(".grupo_nuevo").length;
            let totalActualizar = $(".grupo_actualiza").length;
            let comentario = "Se configuraran " + totalAgregar + " grupo(s), se actualizaran " + totalActualizar + " grupo(s) ¿Éstas seguro que deseas continuar?";
            alerta_confirm_ajax(guardar_grupos_general,'','Alerta de Confirmación',comentario);
        }else{
            alerta_confirm_ajax(guardar_grupos,'','Alerta de Confirmación','Se procesaran ' + totalGrupos + ' grupos, ¿Éstas seguro que deseas continuar?');
        }
    });
}); // End jQuery

function cargarInfoDocente(docente){
    $.ajax({
         type: 'post',
         url: window.gSateliteWhite.baseUrl('registro_academico/procesos/get_datos_docente'),
         data: {docente: docente},
         dataType:'json',
         success: function (data) {
            $("#slcTipoPlanilla").html(data.combo_tipo_planilla);
            $("#slcEscalafon").html(data.combo_escalafon);
            $("#slcTipoPlanilla").select2();
            $("#slcEscalafon").select2();

            $("#dvTipoPlanilla").show(500);
            $("#dvEscalafon").show(500);
         }
    });
}

function guardar_grupos(){
    wait.start();
    var oTabla = $("#datagried1").dataTable();
    oTabla.fnDestroy();

    setTimeout(function () {
        $("#frm-configuracion").submit();
    }, 500);
}

function guardar_grupos_general(){
    wait.start();
    let tipoPlanilla = $("#slcTipoPlanilla").val();

    $(".combotipoPlanilla").each(function(){
        $(this).val(tipoPlanilla);
    });

    let escalafon = $("#slcEscalafon").val();
    $(".comboEscalafon").each(function(){
        $(this).val(escalafon);
    });

    guardar_grupos();
}