$(document).ready(function() { 
    $("select").select2();

    $("#afp").validate({
		ignore:"hidden",
		rules: {
            "txt_nombre_afp":{ required:true },      
            "txt_porcentaje_empleado":{ required:true },
            "txt_porcentaje_patrono":{ required:true },
            "slc_actividad_general":{ required:true },
		}, 
		errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
            $("#pes_generales").trigger("click");
		},
		submitHandler: function(form) {			
		    form.submit();
		}
	});
       
    $("body").on("click", "#btn_agragar_finanzas", function(e) {
        e.preventDefault(); 
        var centro_costo        = $("#slc_centro_costo").val();
        var centro_costo_text   = $("#slc_centro_costo option:selected").text();
        var tipo_cuenta         = $("#slc_tipo_cuenta").val();
        var tipo_cuenta_text    = $("#slc_tipo_cuenta option:selected").text();
        var cuenta              = $("#slc_cuenta").val();
        var cuenta_text         = $("#slc_cuenta option:selected").text();

        if ($.trim(centro_costo) == "") {
            crear_alerta("error", "Centro de costo", "Seleccione un centro de costo.");
            return false;
        }
        
        if ($.trim(tipo_cuenta) == "") {
            crear_alerta("error", "Tipo de cuenta", "Seleccione un tipo de cuenta.");
            return false;
        }

        if ($.trim(cuenta) == "") {
            crear_alerta("error", "Cuenta", "Seleccione una cuenta.");
            return false;
        }

        var row = 'row_'+centro_costo+'_'+tipo_cuenta+'_'+cuenta;

        if ( $("."+row).length > 0) {
            crear_alerta("error", "Finanzas", "El grupo seleccionado ya fue agregado.");
            return false;
        }


        var input_centro= '<input type="hidden" id="dtll_centro_costo" name="dtll_centro_costo[]" value="'+centro_costo+'">';
        var input_tipo  = '<input type="hidden" id="dtll_tipo_cuenta" name="dtll_tipo_cuenta[]" value="'+tipo_cuenta+'">';
        var input_cuenta= '<input type="hidden" id="dtll_cuenta" name="dtll_cuenta[]" value="'+cuenta+'">';
        var eliminar    = '<a class="btn btn-danger icon16 icomoon-icon-remove remover_tr" data-id="'+row+'" title="Eliminar" style="margin-right: 1px;cursor:pointer;padding-left: 4px;padding-right: 4px;margin-left: 1px;margin-right: 1px;"></a>';
        var hmtl        = '';        

        hmtl += '<tr class='+row+'>';
            hmtl += '<td>'+centro_costo_text+input_centro+'</td>';
            hmtl += '<td>'+tipo_cuenta_text+input_tipo+'</td>';
            hmtl += '<td>'+cuenta_text+input_cuenta+'</td>';
            hmtl += '<td>'+eliminar+'</td>';
        hmtl += '</tr>';

        $("#tb_finanzas").append(hmtl);
        $("#slc_centro_costo").val("");
        $("#slc_centro_costo").select2({placeholder: "Seleccione"});
        $("#slc_tipo_cuenta").val("");
        $("#slc_tipo_cuenta").select2({placeholder: "Seleccione"});
        $("#slc_cuenta").val("");
        $("#slc_cuenta").select2({placeholder: "Seleccione"});
    });

    $("body").on('click', ".remover_tr",  function(){ 
        alerta_confirm_ajax(eliminar_fila, $(this) ,'Confirmar eliminar detalle','¿Esta seguro de eliminar el detalle seleccionado?');
    });

});

function eliminar_fila(fila) {
    var tr = fila.closest('tr');
    tr.remove();       
}