$(document).ready(function () {
    //gSateliteWhite.jsSelect();
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("body").on("click", ".fancybox_modal", function () {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width: '100%',
            closeBtn: true,
            height: '100%'
        });

    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var area         = $('#slcArea').val();
        var plaza        = $('#slcPlaza').val();
        var solo_editar  = $('#solo_editar').val();
        $("#dv_contenedor").hide('slide', { direction: 'right' }, 400, function () {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('modulo_seleccion_personal/slp_procesos/consultar_concurso'),
                data: {area:area,plaza:plaza,solo_editar:solo_editar},
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    var oTabla = $("#tblListado").dataTable();
                    oTabla.fnDestroy();
                    $("#tbContenedorListado").html(result);
                    $("#dv_contenedor").show("slide", { direction: 'left' }, 500);
                    aplicarDataTable('tblListado');
                }
            });
        });
    });

    $("#btnConsultar").trigger('click');

    $(document).on('change','#slcAreas',function(){
        var area = $(this).val();
        if (area.length > 0) {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('modulo_seleccion_personal/slp_procesos/get_plazas'),
                data: {area:area},
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcPlazas").html(result);

                }
            });
        }else{
            $("#slcPlazas").html('');
            $('#slcPlazas').select2();
        }
    });

    $(document).on('change','#slcPais',function(){
        var pai = $(this).val();
        if (pai.length > 0) {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('modulo_seleccion_personal/slp_procesos/get_deptos'),
                data: {pai:pai},
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcDepartamento").html(result);

                }
            });
        }else{
            $("#slcDepartamento").html('');
            $('#slcDepartamento').select2({placeholder: "Select an option"});
        }
    });

    $(document).on('click','.add_soli',function(e){
        e.preventDefault();
        var opc = '';
        var id = $(this).data("id");
        var name = $("#name_"+id).val();
        var csp = $("#csp_"+id).val();
        var cnp = $("#cnp_"+id).val();
        var obs = $("#obs_"+id).val();
        var cantidad = $("#cantidad_"+id).val();
        var filtro = csp+','+cnp+','+id;
        agregados = $('.ganadoresx').length;
        if (agregados < cantidad) {
            iguales   = $('#con_'+csp).length;
            if (iguales > 0) {
                crear_alerta('info','Solicitante ya ha sido agregado.','')
            } else {
                opc  =  '<tr id="con_'+csp+'"class="ganadoresx" >';
                opc  += '<td>'+name+'</td>';
                opc  += '<td><input type="text" value="'+obs+'" name="observacion[]"/></td>';
                opc  += '<td><a  id="con_'+csp+'"  class="btn btn-danger btn-mini minia-icon-trashcan white del_doc">&nbsp;Eliminar</a>';
                opc  += '<input type="hidden" name="ganadores[]" value="'+filtro+'"> </td>';
                opc  += '</tr>';
                $('#contenedor_detalles').append(opc);
            }
        }else{
            crear_alerta('error','Error, vacantes completas,','Se ha completado la cantidad máxima de ganadores para este concurso.');
        }
    });

    $(document).on('click','.ver_soli',function(e){
        e.preventDefault();
        var id = $(this).data("id");
        var  url = window.gSateliteWhite.baseUrl("modulo_seleccion_personal/slp_procesos/editar_ficha_solicitante/"+id+"/1/1");
        window.open(url,'_blank');
    });

    $(document).on('click','.trasladoxempleadox',function(){
        var cnp = $(this).data('cnpx');
        var csp = $(this).data('cspx');
        var sle = $(this).data('slex');
        var par = cnp+','+csp+','+sle;
        alerta_confirm_ajax(procesarTraslado,par,'Confirmación de traslado','Estas seguro de realizar este traslado?');
    });

    function procesarTraslado(par){
        var partes = par.split(',');
        var cnp    = partes[0];
        var csp    = partes[1];
        var sle    = partes[2];
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: window.gSateliteWhite.baseUrl('modulo_seleccion_personal/slp_procesos/traslado_concurso'),
            data: {cnp:cnp,csp:csp,sle:sle},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();
                if (data.resp == 1) {
                    crear_alerta('success','Traslado de ganador','El traslado se realizo correctamente');
                    $.fancybox.close();
                    var  url = window.gSateliteWhite.baseUrl("expediente_personal/empleado/editar_empleado/"+data.sle+"/1/0/1/"+data.cnp+"");
                    window.open(url,'_blank');
                }else{
                    crear_alerta('error','Error al realizar traslado','No fue posible realizar el traslado, intenta nuevamente');
                }
            }
        });
    }

    $(document).on('click','#definirGanadores',function(event){
        event.preventDefault();
        if ($('.ganadoresx').length > 0) {
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('modulo_seleccion_personal/slp_procesos/definir_ganadores'),
                data: {formulario:$("#aplicaciones").serialize()},
                beforeSend: function () {
                        wait.start();
                    },
                    success: function (result) {
                        wait.close();
                        if (result.resp == true) {
                            crear_alerta('success','Operación realizada correctamente');
                            $.fancybox.close();
                        }else{
                            crear_alerta('error','la operación no fue realizada');
                        }
                    
                    }
                });

        }else{
            var con = $('#concurso_id').val();
            $.ajax({
                    type: 'post',
                    url: window.gSateliteWhite.baseUrl('modulo_seleccion_personal/slp_procesos/definir_ganadores'),
                    data:{ todos:con},
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (result) {
                        wait.close();                       
                        $.fancybox.close();
                    }
                });
        }
    });

    $(document).on('click','.del_doc',function(){
        var id = $(this).attr('id');
        $('#'+id).remove();
    });

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}