window.gSateliteWhite.jsDatePicker();

var pathArray = window.location.pathname.split('/');
var urlj = url_base_proyecto;
var error_encontrado = false;
var id_correlativo_direcciones = 0;


jQuery(document).ready(function ($) {

    $("#form_add").validate({
        ignore: "",
        rules: {
            txtNombre: {required: true},
            slcPlazas: {required: true},
            txtCantidadVacantes: {required: true},
            desde: {required : true},
            hasta: {required : true},
            txtCantidadVacantes: {required:true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').html(error);
        },
        submitHandler: function (form) {
            var emin    = parseInt($('#slcEdadMinima').val()); 
            var emax    = parseInt($('#slcMaxima').val()); 
            var vedades = true;
            var error   = '\n';           
            if ((!isNaN(emin)) && (!isNaN(emax))) {
                if (emin > emax) {
                    vedades = false;
                    error += 'Selecciona un rango de edades válido\n';
                }
            }
            var smin  = parseFloat($('#txtSalarioMin').val()); 
            var smax  = parseFloat($('#txtSalarioMaximo').val());
            var vsalarios = true;
            if ((!isNaN(smin)) && (!isNaN(smax))) {
                if (smin > smax) {
                    vsalarios = false;
                    error += 'Selecciona un rango de salarios válido\n';
                }
            }
            var desde   = $('#desde').val(); 
            var hasta   = $('#hasta').val(); 
            var vfechas = true;
            if ((desde != '') && (hasta != '')) {
                $resp = verifica_fecha(desde,hasta);
                if (!$resp) {
                    vfechas = false;
                    error += 'Selecciona un rango de fechas válido\n';
                }
            }
            if ((vedades) && (vsalarios) && (vfechas)) {
                form.submit();
            }else{
                crear_alerta('error','Error al procesar',error);
            }            
        }
    });

    $('select').select2();

    $(".select-edades").blur(function () {
        verifica_edad();
    });

    $(document).on('click','#cancelar2',function(evento){
        var id_cliente = $('#id_cliente').val();        
        alerta_confirm_ajax(verificar_alert, id_cliente, "Alerta confirmación", "Los datos que insertaste no han sido guardados.<br> ¿Éstas seguro que quieres regresar a la lista?");
    });

    $(document).on('change','#slc_propietario',function(evento){
        if ( $(this).val() != "") {
            $('#id_cliente').val( $(this).val() );
        } else{
            $('#id_cliente').val("");
        }
    });

    function verificar_alert(id) {
        var ruta = 'modulo_seleccion_personal/slp_procesos/concurso_plazas';
        window.location.href = urlj + ruta;        
    }

    $(document).on('change','#slcAreas',function(){
        var area = $(this).val();
        if (area.length > 0) {
            $.ajax({
                type: 'post',
                url: urlj + 'modulo_seleccion_personal/slp_procesos/get_plazas',
                data: {area:area},
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    $('#slcPlazas').select2("destroy");
                    $("#slcPlazas").html(result);
                    $('#slcPlazas').select2({ placeholder: "Seleccione" });
                    wait.close();
                }
            });
        }else{
            $.ajax({
                type:'post',
                data: {depto: 0},
                url: urlj + 'expediente_personal/empleado/get_plazasxdepto',
                beforeSend: function(){
                    wait.start();
                },
                success: function(data){
                    $("#slcPlazas").html(data);
                    $('#slcPlazas').select2({ placeholder: "Seleccione" });
                    wait.close();
                }
            });
        }
    });

    $("body").on('change', '#slcPlazas', function () {
        var plaza = $(this).val();
        if (plaza.length > 0) {
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('modulo_seleccion_personal/slp_procesos/get_datos_plaza'),
                data: { plaza: plaza },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    //console.log(result);
                    $("select").select2("destroy");
                    if (result.puesto != null) {
                        $("#slcPuestos").val(result.puesto);
                    } else {
                        $("#slcPuestos").val('');
                    }
                    if (result.profesion.length > 0) {
                        $("#slcGrado").val(result.profesion);
                    } else {
                        $("#slcGrado").val('');
                        $("#slcGrado option:selected").removeAttr("selected");
                    }
                    if (result.genero != null) {
                        $("#slcGenero").val(result.genero);
                    } else {
                        $("#slcGenero").val('');
                    }
                    if (result.nivel_edu != null) {
                        $("#slcNivel").val(result.nivel_edu);
                    } else {
                        $("#slcNivel").val('');
                        $("#slcNivel option:selected").removeAttr("selected");
                    }
                    if (result.edad_min != null) {
                        $("#slcEdadMinima").val(parseInt(result.edad_min));
                    } else {
                        $("#slcEdadMinima").val('');
                    }
                    if (result.edad_max != null) {
                        $("#slcMaxima").val(parseInt(result.edad_max));
                    } else {
                        $("#slcMaxima").val('');
                    }
                    if (result.area_plz != null) {
                        $("#slcAreas").val(result.area_plz);
                    } else {
                        $("#slcAreas").val('');
                        $("#slcAreas option:selected").removeAttr("selected");
                    }
                    $("select").select2({ placeholder: "Seleccione" });  
                    $("#slcEdadMinima, #slcMaxima").trigger('blur');
                    wait.close();
                }
            });
        }else{
            $('#slcAreas, #slcGenero, #slcPuestos').val(null).trigger('change');
            $("#slcNivel, #slcGrado").val([]).trigger('change');
            $("#slcMaxima, #slcEdadMinima").val('');
        }
    });

    $(document).on('change','#slcPais',function(){
        var pai = $(this).val();
        if (pai.length > 0) {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('modulo_seleccion_personal/slp_procesos/get_deptos'),
                data: {pai:pai},
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcDepartamento").html(result);

                }
            });
        }else{
            $("#slcDepartamento").html('');
            $('#slcDepartamento').select2({placeholder: "Select an option"});
        }
    });

    function verifica_fecha(fecha_ini, fecha_fin){
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if(Date.parse(fecha_i) == Date.parse(fecha_f)){
            $("#fecha_fin_error").text('');
            return true;
        }        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
            return false;
        }
        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
            return true;
        }
    }


});

function verifica_edad() {
    var edadMin = parseInt($("#slcEdadMinima").val());
    var edadMax = parseInt($("#slcMaxima").val());
    var max_prm = parseInt($("#max_age").val());
    var min_prm = parseInt($("#min_age").val());
    if (edadMin != "") {
        if (edadMin < min_prm) {
            crear_alerta('error', 'Rango de Edades', 'La edad mínima no puede ser menor a ' + min_prm);
            $("#slcEdadMinima").val("");
            return false;
        }
    }
    if (edadMax != "") {
        if (edadMax > max_prm) {
            crear_alerta('error', 'Rango de Edades', 'La edad máxima no puede ser mayor a ' + max_prm);
            $("#slcMaxima").val("");
            return false;
        }
    }
    if (edadMin != "" && edadMax != "") {
        if (edadMin > edadMax) {
            crear_alerta('error', 'Rango de Edades', 'Verifique el rango de edades');
            return false;
        }
    }    
}