$(document).ready(function () {
    var titulo = "Presupuesto comprometido";
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $('select').select2();

    $("#slcProyecto").change(function (){
        var proyecto = $(this).val();
        if ( proyecto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {proyecto: proyecto},
                url: urlj + 'modulo_presupuesto/pre_reportes/get_presupuestoxproyecto',
                success: function (data) {
                    $("#slc_presupuesto").html("");
                    $("#slc_presupuesto").html(data);
                    $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_presupuesto").html('<option value=""></option>');
            $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
        }
        $("#slc_presupuesto").trigger("change");
        $("#slc_actividad_general").trigger("change");
    });

    $("#slc_presupuesto").change(function (){
        var presupuesto = $(this).val();
        if ( presupuesto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {presupuesto: presupuesto},
                url: urlj + 'modulo_presupuesto/pre_reportes/get_actividades_generalesxpresupusto',
                success: function (data) {
                    $("#slc_actividad_general").html("");
                    $("#slc_actividad_general").html(data);
                    $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_actividad_general").html('<option value=""></option>');
            $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
        }
        $("#slc_actividad_general").trigger("change");
    });

    $("#slc_actividad_general").change(function (){
        var general     = $(this).val();
        var presupuesto = $("#slc_presupuesto").val();
        if ( general != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {general: general,presupuesto:presupuesto},
                url: urlj + 'modulo_presupuesto/pre_reportes/get_actividades_especificas_x_actividad_general',
                success: function (data) {
                    $("#slc_actividad_espeficifica").html("");
                    $("#slc_actividad_espeficifica").html(data);
                    $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_actividad_espeficifica").html('<option value=""></option>');
            $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
        }
    });

    $("#btn_consultar").click(function () {
        event.preventDefault();
          
        var txtFechaFin                 = $("#txtFechaFin").val();
        var slc_presupuesto             = ($("#slc_presupuesto").val() > 0)?$("#slc_presupuesto").val():'';
        var slc_actividad_general       = ($("#slc_actividad_general").val() > 0)?$("#slc_actividad_general").val():'';
        var slc_actividad_espeficifica  = ($("#slc_actividad_espeficifica").val() > 0)?$("#slc_actividad_espeficifica").val():'';
        var slcProyecto                 = ($("#slcProyecto").val() > 0)?$("#slcProyecto").val():'';
        
        if ( txtFechaFin == "") {
            crear_alerta('error', titulo , 'Por favor ingrese el rango de fechas.');
            $("#txtFechaIni").val("");
            return false;
        } 

        if ( slcProyecto == "") {
            crear_alerta('error', titulo, 'Por favor seleccione un proyecto.');
            return false;
        } 

        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_presupuesto/pre_reportes/presupuesto_comprometido'),
            data: {
                txtFechaFin: txtFechaFin,
                slc_presupuesto:  slc_presupuesto,
                slc_actividad_general: slc_actividad_general,
                slc_actividad_espeficifica: slc_actividad_espeficifica,
                slcProyecto: slcProyecto,
                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });
    });

    $("#frm_reporte").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var txtFechaFin                 = $("#txtFechaFin").val();
            var slc_presupuesto             = ($("#slc_presupuesto").val() > 0)?$("#slc_presupuesto").val():'';
            var slc_actividad_general       = ($("#slc_actividad_general").val() > 0)?$("#slc_actividad_general").val():'';
            var slc_actividad_espeficifica  = ($("#slc_actividad_espeficifica").val() > 0)?$("#slc_actividad_espeficifica").val():'';
            var slcProyecto                 = ($("#slcProyecto").val() > 0)?$("#slcProyecto").val():'';
            
            if ( txtFechaFin == "") {
                crear_alerta('error', titulo , 'Por favor ingrese el rango de fechas.');
                $("#txtFechaIni").val("");
                return false;
            } 
    
            if ( slcProyecto == "") {
                crear_alerta('error', titulo, 'Por favor seleccione un proyecto.');
                return false;
            } 

            form.submit();
        }
    });

});