$(document).ready(function () { 
    var url = url_base_proyecto;
    $('select').select2({placeholder: 'Seleccione una opción'});
    aplicar_datatable('#tblContenedor');

    $("#slcProyecto").change(function (){
        var proyecto = $(this).val();
        if ( proyecto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {proyecto: proyecto},
                url: urlj + 'modulo_presupuesto/pre_reportes/get_presupuestoxproyecto',
                success: function (data) {
                    $("#slc_presupuesto").html("");
                    $("#slc_presupuesto").html(data);
                    $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_presupuesto").html('<option value=""></option>');
            $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
        }
    });

    $(document).on('click','#agregar_traslado',function(event){
        event.preventDefault();        
        var proyecto    = $("#slcProyecto").val();
        var presupuesto = $("#slc_presupuesto").val();
        
        if ( proyecto == "") {
            crear_alerta("error", "Campo requerido", "Seleccione un proyecto.");
            return false;
        }           

        if ( presupuesto == "") {
            crear_alerta("error", "Campo requerido", "Seleccione un prespuesto.");
            return false;
        }            
        
        window.location = urlj + 'modulo_presupuesto/pre_procesos/realizar_traslados/'+presupuesto;

    });

    $("body").on("click", "#btn_consultar", function(event) {
        event.preventDefault();
        var slcProyecto     = $("#slcProyecto").val();
        var slc_presupuesto = $("#slc_presupuesto").val();
        var url_ajax        = url + "modulo_presupuesto/pre_procesos/traslados_fondos";

        if (slcProyecto == "") {
            crear_alerta("error", "Campo requerido", "Seleccione un proyecto.");
            return false;
        }

        if (slc_presupuesto == "") {
            crear_alerta("error", "Campo requerido", "Seleccione un prespuesto.");
            return false;
        }

        $.ajax({
            url: url_ajax,
            type: 'POST',
            data: {slcProyecto: slcProyecto, slc_presupuesto: slc_presupuesto},
            dataType: 'json',
            beforeSend: function () {
                wait.start('Cargando..');
            },
            error: function (xhr, status, error){
            //exportarError(xhr.responseText);
            wait.close();
        },
            success: function (json) {
                $('#tblContenedor').dataTable().fnDestroy();
                $('#tbContenedor').html(json.html);
                $('#tblContenedor').css("width", "100%");
                aplicar_datatable('#tblContenedor');
                wait.close();
        }
        });  
    });  

});
function aplicar_datatable(id){
    $(id).dataTable({
        //"sPaginationType": "full_numbers",
        "bFilter": true,
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 5,        
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}