$(document).ready(function() { 
    $("select").select2();

    $("#chk_habilitar").iButton({
        'labelOn': 'Habilitar',
        'labelOff': 'Inhabilitar',
        change: function (element) {
            if ( element.is(":checked") ) {
                $(".lectura").prop('readonly', false);    
            } else {
                $(".lectura").prop('readonly', true);   
            }
        }
    });
    
    $("#slc_actividad_general_origen").change(function (){
        var general = $(this).val();
        var presupuesto= $("#txt_presupuesto").val();
        if ( general != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {general: general,presupuesto: presupuesto},
                url: urlj + 'modulo_presupuesto/pre_procesos/get_actividades_especificas_x_actividad_general',
                beforeSend:function(){
                    wait.start();
                },
                success: function (data) {
                    $("#slc_rubro_origen").html("");
                    $("#slc_rubro_origen").html(data);
                    $("#slc_rubro_origen").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_rubro_origen").html('<option value=""></option>');
            $("#slc_rubro_origen").select2({placeholder: 'Seleccione una opción'});
        }
        wait.close();
    });

    $("#slc_actividad_general").change(function (e){
        e.preventDefault();

        var general     = $(this).val();
        var presupuesto = $("#txt_presupuesto").val();
        if ( general != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {general: general,presupuesto :presupuesto},
                url: urlj + 'modulo_presupuesto/pre_procesos/get_actividades_especificas_x_actividad_general',
                beforeSend:function(){
                    wait.start();
                },
                success: function (data) {
                    $("#slc_rubro").html("");
                    $("#slc_rubro").html(data);
                    $("#slc_rubro").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_rubro").html('<option value=""></option>');
            $("#slc_rubro").select2({placeholder: 'Seleccione una opción'});
        }
        wait.close();
    });

    $("#slc_rubro_origen").change(function (e){
        e.preventDefault();
        var rubro = $(this).find(':selected').data('presupuesto');
        var valor = $(this).find(':selected').data('valor');
        if ( rubro != "" ) {
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {actividad: rubro, tipo: 1},
                url: urlj + 'modulo_presupuesto/pre_procesos/get_plan_compras',
                beforeSend:function(){
                    wait.start();
                },
                success: function (data) {
                    wait.close();                 
                    if (data.encontrado == 1) {
                        $("#tbl_tabla_trasladar").html(data.html);     
                        $("#txt_monto_presupuesto_origen").val( number_format(valor,"2",".","") ); 
                        $("#txt_detalle_origen").val( rubro );            
                    } else {
                         $("#tbl_tbody_tipo_1").html("");
                         $("#table_foot_1").remove();
                         $("#txt_monto_presupuesto_origen").val("");
                         $("#txt_detalle_origen").val("");  
                    }
                }
            });
        } else {
            $("#tbl_tbody_tipo_1").html("");
            $("#table_foot_1").remove();
            $("#txt_monto_presupuesto_origen").val("");
            $("#txt_detalle_origen").val("");
        }
        wait.close();
    });

    $("#slc_rubro").change(function (e){
        e.preventDefault();
        var rubro = $(this).find(':selected').data('presupuesto');
        var valor = $(this).find(':selected').data('valor');
        if ( $(this).val() == $("#slc_rubro_origen").val() ) {
            crear_alerta("info", "Rubro", "El rubro seleccionado no puede ser el mismo que el rubro de trasladar.");   
            $("#slc_rubro").val("");
            $("#slc_rubro").select2({placeholder:"Seleccione"});
            return false;
        }
        if ( rubro != "" ) {
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {actividad: rubro, tipo: 2},
                url: urlj + 'modulo_presupuesto/pre_procesos/get_plan_compras',
                beforeSend:function(){
                    wait.start();
                },
                success: function (data) {
                    wait.close();                 
                    if (data.encontrado == 1) {
                        $("#tbl_table_aplicar").html(data.html);  
                        $("#txt_monto_presupuesto").val( number_format(valor,"2",".","") );  
                        $("#txt_detalle_destino").val( rubro );
                        tipo_lectura();             
                    } else {
                         $("#tbl_tbody_tipo_2").html("");
                         $("#table_foot_2").remove();
                         $("#txt_monto_presupuesto").val("");
                         $("#txt_detalle_destino").val("");
                    }
                }
            });
        } else {
            $("#tbl_tbody_tipo_2").html("");
            $("#table_foot_2").remove();
            $("#txt_monto_presupuesto").val("");
            $("#txt_detalle_destino").val("");
        }
        wait.close();
    });

    $("body").on("keyup", ".movimiento_tipo_1", function(e) {
        e.preventDefault();
        var movimiento  = $(this).val();
        var tipo        = $(this).data("tipo");
        if ( movimiento != "" ) {
            var fila    = $(this).data("fila");
            if ( parseFloat($("#txt_monto_disponible_"+fila).val()) < parseFloat(movimiento) ) {
                $(this).val("");
                crear_alerta("error", "Disponibilidad", "El valor a trasladar es mayor a los disponible.");               
            }
        }
        sumar_movimientos(tipo);
    }); 

    $("body").on("keyup", ".movimiento_tipo_2", function(e) {
        e.preventDefault();
     
        var movimiento  = $(this).val();
        var tipo        = $(this).data("tipo");
        if ( movimiento != "" ) {                        
            var transferencia       = $( "#txt_total_movimiento_1").val();
            var total_movimientos   = sumar_movimientos(tipo);
            transferencia = (transferencia != "")?transferencia:0;
            if ( parseFloat(transferencia) < parseFloat(total_movimientos) ) {
                $(this).val("");
                crear_alerta("error", "Disponibilidad", 'El valor a aplicar es mayor al monto a trasladar ('+number_format(transferencia,2,".","")+').');
            }
        }
        sumar_movimientos(tipo);
    });

    
    $("#form").validate({
        ignore:"",
        rules: {
          
        },
        ignore: ".select2-container",     
        submitHandler: function(form) {
            event.preventDefault();
            if ( $("#slc_rubro_origen").val() == "" ) {
                crear_alerta("error", "Rugro origen", 'Seleccione un rubro origen.');
                return false;
            }

            if ( $("#slc_rubro").val() == "" ) {
                crear_alerta("error", "Rugro", 'Seleccione un rubro al cual se le hara un traslado.');
                return false;
            }

            if ( $("#txt_total_movimiento_1").val() == 0 ) {
                crear_alerta("error", "Monto a trasladar", 'Agregue una cantidad a trasladar.');
                return false;
            }

            if ( $("#txt_total_movimiento_2").val() == 0 ) {
                crear_alerta("error", "Monto a aplicar", 'Agregue una cantidad a aplicar.');
                return false;
            }

            if ( $("#txt_total_movimiento_1").val() != $("#txt_total_movimiento_2").val() ) {
                crear_alerta("error", "Traslado", 'Monto a traslador y monto a aplicar no son iguales.');
                return false;
            }

            form.submit();
            
        }
    });


});

function sumar_movimientos(tipo) {
    var total = 0;

    $( ".movimiento_tipo_"+tipo ).each(function() {
        if ( $(this).val() ) {
            total += parseFloat($(this).val());
        }
    });

    $( "#lbl_total_movimiento_" +tipo ).text( number_format(total,2,".",""));
    $( "#txt_total_movimiento_" +tipo ).val( number_format(total,2,".","") );

    return total;
}

function tipo_lectura() {
    if ( $("#chk_habilitar").is(":checked") ) {
        $(".lectura").prop('readonly', false);    
    } else {
        $(".lectura").prop('readonly', true);   
    }
} 