var cantidad_decimales         = $("#cantidad_decimales").val();

$(document).ready(function() {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    
    $(".input_fecha").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });    
    
	$("select").select2();
	aplicar_datatable("#dt_table_presupuesto");
	
	$("body").on("change", "#pre_tipo_presupuesto", function(e) {
		e.preventDefault();
		var tipo_pre = $(this).val();	
		if (parseInt(tipo_pre) > 0) {
			$.ajax({
				url: urlj + "modulo_presupuesto/pre_procesos/obtener_presupuestosxtipo",
				data: {id_tipo_presupuesto: tipo_pre},
				type: "POST",
				dataType: 'json',
				beforeSend:function(){
					wait.start();
				},
				success: function (data) {
					wait.close();
					$("#pre_presupuesto").html('');
					$("#pre_presupuesto").html(data.html);
					$("#pre_presupuesto").select2();
				}

			});
			
		} else {
			// Reset select
			$("#pre_presupuesto").html('');
			var select_reset = '<option value=""></option>' + $("#presupuestos_hidden").val();
			$("#pre_presupuesto").html(select_reset);
			$("#pre_presupuesto").val("");
			$("#pre_presupuesto").select2();
		}

		$("#pre_presupuesto").trigger('change');
		$("#slc_actividad_general").trigger('change');
	});

	$("#pre_presupuesto").change(function (){
        var presupuesto	= $(this).val();
        if ( presupuesto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {presupuesto: presupuesto},
                url: urlj + 'modulo_presupuesto/pre_procesos/get_actividad_general_x_presupuesto',
                success: function (data) {
                    $("#slc_actividad_general").html("");
                    $("#slc_actividad_general").html(data);
                    $("#slc_actividad_general").select2({placeholder: 'Seleccione'});
                }
            });
        } else {
            $("#slc_actividad_general").html("");
            $("#slc_actividad_general").html('<option value=""></option>');
            $("#slc_actividad_general").select2({placeholder: 'Seleccione'});
		}
		
		$("#slc_actividad_general").trigger('change');
    });

	$("#slc_actividad_general").change(function (){
		var presupuesto	= $("#pre_presupuesto").val();
        var general     = $(this).val();
        if ( general != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {
					general: general,
					presupuesto:presupuesto
				},
                url: urlj + 'modulo_presupuesto/pre_procesos/get_actividades_especificas_x_actividad_general',
                success: function (data) {
                    $("#slc_actividad_espeficifica").html("");
                    $("#slc_actividad_espeficifica").html(data);
                    $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione'});
                }
            });
        } else {
            $("#slc_actividad_espeficifica").html("");
            $("#slc_actividad_espeficifica").html('<option value=""></option>');
            $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione'});
        }

    });
	
	$("body").on("click", "#btnConsultar", function(e) {
		e.preventDefault();
		
		var tipo_pre    		= $("#pre_tipo_presupuesto").val();
		var presupuesto 		= $("#pre_presupuesto").val();
		var actividad_general	= $("#slc_actividad_general").val();
		var actividad_especifica= $("#slc_actividad_espeficifica").val();
		
		if (parseInt(presupuesto) > 0) {
			
			$.ajax({
				url: urlj + "modulo_presupuesto/pre_procesos/agregar_gastos",
				data: {
					texto: "Plan de compras",
					id_tipo_presupuesto: tipo_pre, 
					presupuesto: presupuesto,
					actividad_general,
					actividad_especifica,
				},
				type: "POST",
				dataType: 'json',
				beforeSend:function(){
					wait.start();
				},
				success: function (data) {
					wait.close();
					$('#dt_table_presupuesto').dataTable().fnDestroy();
					$("#tb_contenido_body").html(data.tabla);
					aplicar_datatable('#dt_table_presupuesto');
					$("#dt_total_actividad_general").text( number_format(data.presupuesto_actividad, cantidad_decimales, ".", ",") );
					$("#dt_total_monto_ejecutado").text( number_format(data.monto_ejecutado, cantidad_decimales, ".", ",") );
					$("#dtll_montoxejecutar").text( number_format(data.montoxejecutar, cantidad_decimales, ".", ",") );
					$("#dt_total_aporte_interno").text( number_format(data.aporte_interno, cantidad_decimales, ".", ",") );
					$("#dt_total_aporte_externo").text( number_format(data.aporte_externo, cantidad_decimales, ".", ",") );
				}

			});
			
		} else {
			crear_alerta("error", "Error", "El Campo Presupuesto es requerido.");
		}
	});
	
	$("body").on("click", ".agregar_gasto", function(e) {
		e.preventDefault();
		if ( $(this).data("permiso") == 0) {
			crear_alerta("info", "Permisos de sucursal", "Su usuario no pertenece a la sucursal de presupuesto asignado.");
			return false;
		}
		
		var fila 		= $(this).data("id");
		var actividad 	= $("#tmp_id_gasto"+fila).val();
		$.ajax({
			url: urlj + "modulo_presupuesto/pre_procesos/plan_compras",
			data: { actividad: actividad },
			type: "POST",
			dataType: 'json',
			beforeSend:function(){
				wait.start();
			},
			success: function (data) {
				wait.close();
				$("#txt_detalle").val(data.actividad);
				$("#lbl_rubro").text(data.rubro);
				$("#lbl_presupuesto_actividad").text("$"+number_format(data.presupuesto, cantidad_decimales, '.', ','));
				$("#lbl_presupuesto_actividad_hdn").text(number_format(data.presupuesto, cantidad_decimales, '.', ''));
				$("#lbl_desde").text(data.desde);
				$("#lbl_hasta").text(data.hasta);
				$("#tb_contenido_plan_body").html(data.html);

				var total = sumar_montos();
				$("#total_plan").text( number_format(total, cantidad_decimales, ".", ",") );
			}
		});
		
        $.fancybox({
            href    : $(this).attr('href'),
            autoSize: false,
            height  : '600',
            width   : '90%',
			closeBtn: true,
			afterClose: function () {
                $("#txt_detalle").val("");
				$("#lbl_rubro").text("");
				$("#lbl_presupuesto_actividad").text("");
				$("#lbl_presupuesto_actividad_hdn").text("");
				$("#lbl_desde").text("");
				$("#lbl_hasta").text("");
				$("#tb_contenido_plan_body").html("");
				$("#total_plan").text("");
            }
        });
        
	});
	
	$("#frm_agregar_gastos").on("click", "#crear_plan", function(e) {
		e.preventDefault();
		var montos 		= sumar_montos();
		var presupuesto = parseFloat( $("#lbl_presupuesto_actividad_hdn").text() );

		if ( montos > presupuesto) {
			var presupuesto_real = $("#lbl_presupuesto_actividad").text();
			crear_alerta("error", "Plan de compras", "La suma de los montos supera el presupuesto asignado ("+presupuesto_real+")");
			return false;
		}

		var monto 		= $("input[name='txt_monto[]']").map(function(){return $(this).val();}).get();
		var descripcion = $("textarea[name='txt_descripcion[]']").map(function(){return $(this).val();}).get();
		var periodo 	= $("input[name='txt_periodo[]']").map(function(){return $(this).val();}).get();

		$.ajax({
			url: urlj + "modulo_presupuesto/pre_procesos/guardar_plan_compras",
			data: { 
				gasto: $("#txt_detalle").val(),
				monto: monto,
				descripcion: descripcion,
				periodo:periodo
			},
			type: "POST",
			dataType: 'json',
			beforeSend:function(){
				wait.start();
			},
			success: function (data) {
				if (data.realizado == 1) {
					$("#btnConsultar").trigger("click");
					crear_alerta("success", "Plan de compras", "Se guardo el plan de compras");					 
				} else{
					$("#btnConsultar").trigger("click");
					crear_alerta("success", "Plan de compras", "No se  y/o creo un plan de compras");
				}
				$.fancybox.close();
				wait.close();
			}

		});
		
	});

	function sumar_montos(){
		var total = 0;
		$(".montos").each(function() {
			if ($(this).val() != "") {
				total += parseFloat($(this).val());
			}
		});
		return total;
	}
	
	$("#frm_agregar_gastos").on("keyup",".montos", function() {
		var total = sumar_montos();
		$("#total_plan").text( number_format(total, cantidad_decimales, ".", ",") );
	});
    
});

function aplicar_datatable(id){
    $(id).dataTable({
        //"sPaginationType": "full_numbers",
        "bFilter": true,
        "bJQueryUI": false,
        "bAutoWidth": true,
        "iDisplayLength": 5,        
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
