var cantidad_decimales         = $("#cantidad_decimales").val();

$(document).ready(function() {
    $("select").select2({ placeholder: 'Seleccione' });
    // aplicar_datatable("#dt_table_presupuesto");
    
    if (parseInt($("#id_pre").val()) > 0) {
        setTimeout(function() {
            calcular_montos();
        }, 500);
    }
    
    $(".input_fecha").mask("99-99-9999");
    $(".input_fecha").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    
    $("#frm_contenedor").validate({
        ignore: [],
        rules: {
            pre_codigo              : {required: true},
            pre_tipo_presupuesto    : {required: true},
            pre_nombre              : {required: true},
            pre_fecha_desde         : {required: true},
            pre_fecha_hasta         : {required: true},
            pre_presupuesto_total   : {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            $("#id_generales").trigger("click");
        },
        submitHandler: function (form) {
            //if ($('#tbProductos .trProducto').length == 0) {
            //    crear_alerta('error', 'Envío Parcial', 'Debe seleccionar al menos un producto.');
            //    return false;
            //}
            var validacion = validar_presupuesto(0);
            if ( validacion == false ) {
                return false;
            }
            $("select").select2("enable",true);
            $('select').prop("disabled", false);
            form.submit();
        }
    });    

    $("body").on('change', '#pre_proyecto',  function(event) { 
        validar_presupuesto_proyecto();
    });

    $("body").on('keyup', '#pre_presupuesto_total',  function(event) { 
        validar_presupuesto_proyecto();
    });

    

    $("#slcProducto_ajax").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_presupuesto/pre_procesos/get_articulos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (articulo_servicio) {
                return {
                    articulo_servicio: articulo_servicio
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.id,
                        'text': item.codigo+' - '+item.nombre
                    });
                });
                return {
                    results: myResults
                };
    
            }
        }
    });
    
    // Para obtener las subcategorias
    $("body").on('change', '.dinamic', function () {
        menor = Number($(this).attr('id')) + 2;

        padre = $("select[class='dinamic']").last().val();
        $(".dinamic").each(function (index, el) {
            if ($(el).attr('id') > menor) {
                $(el).parent('div').siblings('label').remove();
                $(el).siblings('select').remove();
                $(el).parent('div').parent('div').parent('div').remove();
                $(el).remove();
            }
        });
        
        $(".plus:last").remove();
        $(this).next().append('<button class="btn plus">+</button>');
    });

    // Evento clic para obtener las sub actividades
    $("body").on('click', '.plus', function (event) {
        event.preventDefault();

        var padre        = $("select[class*='dinamic']").last().val();
        var esp_general  = $("#dt_actividad_general option:selected").val();
        
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'modulo_presupuesto/pre_procesos/get_dependencias_actividad_especifica',
            data: {padre: padre, actividad_general: esp_general},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();
                
                // Variables
                var especificas = data.drop;
                
                $i = 0;
                $(".plus").last().remove();
                if (especificas.length > 0) {
                    numero = $('#div_actividad_especifica select').last().length + 1;
                    //<div class="form-row row-fluid"></div>
                    linea = $("#div_actividad_especifica").append(''
                            + '<div class="span12" style="margin-bottom: 10px;">'
                            + '<div class="row-fluid">'
                            + '<label class="span4">Pda. Presup. / Rubro:<b style="color:red">*</b></label>'
                            + '<div class="span6 controls">'
                            + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                            + '</div></div></div>');
                    linea2 = $('select[class="dinamic"]').last().html();
                    nueva = linea2.replace(/#/g, numero);
                    $('#div_actividad_especifica').append(nueva);
                    $('select[class="dinamic"]').last().html(especificas);
                    $('select[class="dinamic"] option[value="0"]').last().text('');
                    $('select[class="dinamic"] option[value="0"]').last().val('');
                    $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
                } else {
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: 'No se encontraron mas dependencias.',
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }

                $('.dinamic').each(function (index, el) {
                    $(this).attr('id', index);
                });
            }
        });
    });
    
    var row = 0;
    if ($('#tb_contenido_body .pre_detalle_tr').length > 0) {
        row = $("#tb_contenido_body .pre_detalle_tr").length;
    }
   
    $("body").on("click", "#btnAgregar_dt_presupuesto", function(e) {
        e.preventDefault();
        var area_servicio              = $("#dt_area_servicio").val();
        var area_servicio_text         = $("#dt_area_servicio option:selected").text();
        var actividad_general          = $("#dt_actividad_general").val();
        var actividad_general_txt      = $("#dt_actividad_general option:selected").text();
        var actividad_especifica       = $("select[class*='dinamic']").last().val();
        var actividad_especifica_txt   = $.trim($("select[class*='dinamic'] option:selected").last().text());
        var fuente_financiamiento      = $("#dt_fuente_financiamiento").val();
        var dt_fecha_desde             = $("#dt_fecha_desde").val();
        var dt_fecha_hasta             = $("#dt_fecha_hasta").val();
        var dt_objetivo                = $("#dt_objetivo").val();
        var dt_presupuesto_actividad   = $("#dt_presupuesto_actividad").val();
        var dt_aporte_externo          = $("#dt_aporte_externo").val();
        var dt_aporte_interno          = $("#dt_aporte_interno").val();
        var dt_fuente_verificacion     = $("#dt_fuente_verificacion").val();
        var dt_fuente_verificacion_txt = $("#dt_fuente_verificacion option:selected").text();
        var procesar_ingreso           = true;
        
        actividad_especifica           = ($.trim(actividad_especifica) != "") ? actividad_especifica : $("select[class*='dinamic']").first().val();
        actividad_especifica_txt       = ($.trim(actividad_especifica_txt) != "") ? actividad_especifica_txt : $("select[class*='dinamic'] option:selected").text();
        
        if (validar_monto_total()) {
        	crear_alerta("error", "Presupuesto Total", "El total del presupuesto de las actividades sobrepasa al presupuesto total.");
        	return false;
        }
        
        if (!parseInt(actividad_especifica) > 0) {
            $('#dt_actividad_especifica_error').text('Campo Requerido');
            procesar_ingreso = false;
        }
        
        if (!parseFloat(dt_presupuesto_actividad) > 0) {
            $('#dt_presupuesto_actividad_error').text('Campo Requerido');
            procesar_ingreso = false;
        }
        
        if ($.trim(dt_fecha_desde) == "") {
            $('#dt_fecha_desde_error').text('Campo Requerido');
            procesar_ingreso = false;
        }
        
        if ($.trim(dt_fecha_hasta) == "") {
            $('#dt_fecha_hasta_error').text('Campo Requerido');
            procesar_ingreso = false;
        }

        if (!parseInt(actividad_general) > 0) {
            $('#dt_actividad_general_error').text('Campo Requerido');
            procesar_ingreso = false;
        }

        //if (!parseInt(area_servicio) > 0) {
            //  $('#dt_area_servicio_error').text('Campo Requerido');
            // procesar_ingreso = false;
        //}

        if ( !validarPeriodo(dt_fecha_desde, dt_fecha_hasta) ) {
            crear_alerta('error', 'Detalles Del Presupuesto', 'Verifique el período de las fechas.');
            $("#dt_fecha_hasta").focus()
            return false;
        }
        
        if(validar_campo_repetido((actividad_especifica), ".dtll_actividad_especifica_validar", "#tb_contenido_body")){
            crear_alerta("info", "Aviso", 'El registro ya existe.');
            return false;
        }        
        
        if (procesar_ingreso) {
            pre_conf            = '<input type="hidden" class="dtll_actividad_especifica_validar" value="'+(actividad_especifica)+'">' +
                                '<input type="hidden" id="tmp_objetivo'+row+'" name="dt_objetivo[]" value="'+dt_objetivo+'">' +
                                '<input type="hidden" id="tmp_detalle_pre'+row+'" name="detalle_pre[]" value="">' +
                                '<input type="hidden" id="tmp_permitir_eliminar'+row+'" name="permitir_eliminar[]" value="0">' +
                                '<input type="hidden" id="tmp_fnt_financiamiento'+row+'" name="dt_fuente_financiamiento[]" value="'+fuente_financiamiento+'">';

            pre_area_servicio   = '<input type="hidden" id="tmp_area_servicio'+row+'" name="dtll_area_servicio[]" value="'+area_servicio+'">'+
                                '<input type="text" id="lbl_area_servicio'+row+'" class="text tables-input" style="padding: 6px 4px;" value="' + area_servicio_text + '" readonly>';
                        
            pre_actividad_gen   = '<input type="hidden" id="tmp_actividad_general'+row+'" name="dtll_actividad_general[]" value="'+actividad_general+'">'+
                                '<label id="lbl_actividad_general'+row+'" style="padding: 6px 4px;">'+actividad_general_txt+'</label>';
                        
            pre_actividad_esp   = '<input type="hidden" id="tmp_actividad_especifica'+row+'" name="dtll_actividad_especifica[]" value="'+actividad_especifica+'">'+
                                '<label id="lbl_actividad_especifica'+row+'" style="padding: 6px 4px;">'+actividad_especifica_txt+'</label>';

            pre_fecha_desde     = '<input type="hidden" id="tmp_fecha_desde'+row+'" name="dtll_fecha_desde[]" value="'+dt_fecha_desde+'">'+
                                '<label id="lbl_fecha_desde'+row+'" style="padding: 6px 4px;">'+dt_fecha_desde+'</label>';
    
            pre_fecha_hasta     = '<input type="hidden" id="tmp_fecha_hasta'+row+'" name="dtll_fecha_hasta[]" value="'+dt_fecha_hasta+'">'+
                                '<label id="lbl_fecha_hasta'+row+'" style="padding: 6px 4px;">'+dt_fecha_hasta+'</label>';
    
            pre_actividad       = '<input type="hidden" id="tmp_act_pre'+row+'" class="dtll_pre_actividad" name="dtll_pre_actividad[]" value="'+dt_presupuesto_actividad+'">'+
                                '<label id="lbl_act_pre'+row+'" style="padding: 6px 4px;">'+number_format(dt_presupuesto_actividad, cantidad_decimales, '.', ',')+'</label>';
                        
            pre_monto_ej        = '<label id="lbl_monto_eje'+row+'" style="padding: 6px 4px;">0.00</label>';

            monto_x_ejecutar    = '<label id="lbl_monto_x_ejecutar'+row+'" style="padding: 6px 4px;" class="monto_x_ejecutar">'+ number_format(dt_presupuesto_actividad, cantidad_decimales, '.', ',') +'</label>';
            
            pre_aporte_ext      = '<input type="hidden" id="tmp_aporte_ext'+row+'" class="dtll_aporte_externo" name="dtll_aporte_externo[]" value="'+dt_aporte_externo+'">'+
                                '<label id="lbl_aporte_ext'+row+'" style="padding: 6px 4px;">'+number_format(dt_aporte_externo, cantidad_decimales, '.', ',')+'</label>';
                        
            pre_aporte_int      = '<input type="hidden" id="tmp_aporte_int'+row+'" class="dtll_aporte_interno" name="dtll_aporte_interno[]" value="'+dt_aporte_interno+'">'+
                                '<label id="lbl_aporte_int'+row+'" style="padding: 6px 4px;">'+number_format(dt_aporte_interno, cantidad_decimales, '.', ',')+'</label>';
                        
            pre_fnt_verificacion= '<input type="hidden" id="tmp_fnt_verificacion'+row+'" name="dtll_fuente_verificacion[]" value="'+dt_fuente_verificacion+'">'+
                                '<label id="lbl_fnt_verificacion'+row+'" style="padding: 6px 4px;">'+dt_fuente_verificacion_txt+'</label>'; 
            
            pre_articulos       = '<input type="hidden" id="tmp_articulos_'+row+'" name="dtll_articulos[]" value="">';
                                
            pre_usuario_permitidos = '<input type="hidden" id="tmp_fnt_usuaios_permitidos_'+row+'" name="dtll_usuarios_permitidos[]" value="">';

            articulos   = '<a class="btn btn-warning icon16 icomoon-icon-license brn_articulos" data-id="'+row+'" href="#frm_articulos" title="Artículos" style="margin-right: 1px;cursor:pointer;padding-left: 4px;padding-right: 4px;margin-left: 1px;margin-right: 1px;"></a>';
            editar      = '<a class="btn btn-success icon16 icomoon-icon-pencil-5 editar" data-id="'+row+'" href="#frm_editar" title="Editar" style="margin-right: 1px;cursor:pointer;padding-left: 4px;padding-right: 4px;margin-left: 1px;margin-right: 1px;"></a>';
            eliminar    = '<a class="btn btn-danger icon16 icomoon-icon-remove remover_tr" data-id="'+row+'" title="Eliminar" style="margin-right: 1px;cursor:pointer;padding-left: 4px;padding-right: 4px;margin-left: 1px;margin-right: 1px;"></a>';
            permisos    = '<a class="btn btn-info icon16 icomoon-icon-user permisos" data-id="'+row+'" href="#frm_permisos" title="Permisos" style="margin-right: 1px;cursor:pointer;padding-left: 4px;padding-right: 4px;margin-left: 1px;margin-right: 1px;"></a>';
            pre_acciones= editar + permisos + articulos + eliminar;
 
            $("#tb_contenido_body").append('<tr id="pre_detalle_tr'+row+'" data-id="' + row + '" class="pre_detalle_tr">'+
                '<td style="display:none;">'+ pre_conf + pre_area_servicio +'</td>'+
                '<td width="20%">'+ pre_actividad_gen +'</td>'+
                '<td width="20%">'+ pre_actividad_esp +'</td>'+
                '<td width="9%">'+ pre_fecha_desde +'</td>'+
                '<td width="9%">'+ pre_fecha_hasta +'</td>'+
                '<td width="10%">'+ pre_actividad +'</td>'+
                '<td width="10%">'+ pre_monto_ej +'</td>'+
                '<td width="10%">'+ monto_x_ejecutar +'</td>'+
                '<td style="display:none;">'+ pre_aporte_ext +'</td>'+
                '<td style="display:none;">'+ pre_aporte_int +'</td>'+
                '<td style="display:none;">'+ pre_fnt_verificacion +'</td>'+
                '<td style="display:none;">'+ pre_articulos +'</td>'+
                '<td style="display:none;">'+ pre_usuario_permitidos +'</td>'+
                '<td width="12%" style="text-align: center;padding-left: 1px;padding-right: 1px;">'+pre_acciones+'</td>'+
            '</tr>');
    
            $("#dt_table_presupuesto").css("width", "100%");
            
            calcular_montos();
            get_usuarios_permitidos_generales(actividad_general,row);
            
            row = row + 1;
    
            $("#dt_area_servicio").val(0);
            $("#dt_area_servicio").select2();
            
            $("#dt_actividad_general").val(0);
            $("#dt_actividad_general").select2();
            
            $("#div_actividad_especifica .span12").remove();
            $("select[class*='dinamic']").last().val(0);
            $("select[class*='dinamic']").last().select2();
            $("select[class*='dinamic'] option:selected").last().text('');
                        
            $("#dt_fuente_financiamiento").val(0);
            $("#dt_fuente_financiamiento").select2();
            
            $("#dt_fecha_desde").val($("#pre_fecha_desde").val());
            $("#dt_fecha_hasta").val($("#pre_fecha_hasta").val());
            $("#dt_objetivo").val('');
            $("#dt_presupuesto_actividad").val('');
            $("#dt_aporte_externo").val('');
            $("#dt_aporte_interno").val('');
            
            $("#dt_fuente_verificacion").val(0);
            $("#dt_fuente_verificacion").select2();

        }
        
    });
    
    $("body").on('click', ".remover_tr",  function(){ //elimina el componente agregado
        alerta_confirm_ajax(eliminar_fila, $(this) ,'Confirmar eliminar detalle','¿Esta seguro de eliminar el detalle seleccionado?');
    });

    function eliminar_fila(fila) {
        var tr = fila.closest('tr');
        tr.remove();       
        calcular_montos(); 
    }

    $("body").on('click', '.brn_articulos',  function(event) {
        event.preventDefault();
        var html            = "";
        var id              = $(this).data('id');
        var json_permisos   = $("#tmp_articulos_"+id).val();
        var eliminar        = '<a class="btn btn-danger icon16 icomoon-icon-remove remover_articulo" title="Eliminar" style="margin-right: 1px;cursor:pointer;padding-left: 4px;padding-right: 4px;margin-left: 1px;margin-right: 1px;"></a>';
        
        $("#tbody_articulos").html("");
        $("#tmp_id_row3").val(id);

        if (json_permisos != "") {
            var obj_permisos = jQuery.parseJSON( json_permisos );            
            $.each(obj_permisos, function(i, obj) {
                var cheque = (obj.valor == 1)?'checked="checked"':'';
               html += '<tr class="tr_articulos tr_'+obj.id+'" data-id="'+obj.id+'">';
                    html += '<td id="articulo_id_'+obj.id+'" style="display:none;">'+obj.id+'</td>';
                    html += '<td id="articulo_nombre_'+obj.id+'">'+obj.nombre+'</td>';
                    html += '<td><input type="checkbox" class="nostyle articulo_chequeado" '+cheque+' data-id="'+obj.id+'"></td>';
                    html += '<td id="articulo_valor_'+obj.id+'" style="display:none;" class="articulo_valor">'+obj.valor+'</td>'
                    html += '<td>'+eliminar+'</td>';
                html += '</tr>';
            });
        }
        
        $("#tbody_articulos").html(html);

        $.fancybox({
            href    : $(this).attr('href'),
            autoSize: false,
            height  : '400',
            width   : '60%',
            closeBtn: true
        });

        var chequeado   = true;

        $('.articulo_valor').each(function() {     
            if ( $(this).text() == 0 ) {
                chequeado   = false;  
            }
        }); 
        
        $("#articulo_general").attr('checked',chequeado); 
    });

    $("body").on('click', '#btn_agregar_articulos',  function(event) {
        event.preventDefault();

        if ( $("#slcProducto_ajax").val() == "") {
            crear_alerta('error', 'Artículo / Servicio', 'Se debe agregar un Artículo o Servicio.');
            return false;
        }

        var id      = $("#slcProducto_ajax").select2('data').id;
        var texto   = $("#slcProducto_ajax").select2('data').text;

        if ( $('#tbody_articulos .tr_'+id).length > 0) {
            crear_alerta('error', 'Artículo / Servicio', 'Artículo o Servicio ya fue agregado.');
            return false;
        }
       
        var eliminar= '<a class="btn btn-danger icon16 icomoon-icon-remove remover_articulo" title="Eliminar" style="margin-right: 1px;cursor:pointer;padding-left: 4px;padding-right: 4px;margin-left: 1px;margin-right: 1px;"></a>';
        var html    = "";

        html = '<tr class="tr_'+id+' tr_articulos"  data-id="'+id+'">';
                html += '<td id="articulo_id_'+id+'" style="display:none;">'+id+'</td>';
                html += '<td id="articulo_nombre_'+id+'">'+texto+'</td>';
                html += '<td><input type="checkbox" class="nostyle articulo_chequeado" checked data-id="'+id+'"></td>';
                html += '<td id="articulo_valor_'+id+'" style="display:none;" class="articulo_valor">1</td>'
                html += '<td>'+eliminar+'</td>';
            html += '</tr>';

        $("#tbody_articulos").append(html);
        $("#slcProducto_ajax").select2('data', null);
    });

    $("body").on("click", "#btn_editar_articulos", function (event) {
        var resultado   = new Array();
        var fila        = $("#tmp_id_row3").val();
        if ( $(".tr_articulos").length > 0 ) { 
            $(".tr_articulos").each(function( index ) { 
                var linea   = $(this).data("id");
                var id      = $("#articulo_id_"+linea).text();
                var nombre  = $("#articulo_nombre_"+linea).text();
                var valor   = $("#articulo_valor_"+linea).text();
              
                array_permisos = {
                    id:     id,
                    nombre: nombre,
                    valor:  valor
                }
                
                resultado.push(array_permisos);
            });
        }
        
        $("#tmp_articulos_"+fila).val( JSON.stringify(resultado));
        $("#tmp_id_row3").val("");
        $("#tbody_permiso3").html("");
        $.fancybox.close();
    });

    $("body").on("click",".articulo_chequeado_general",function(e) {
        var chequeado   = false;
        var valor       = 0;
        if ( $(this).is(":checked")) {
            chequeado = true;
            valor   = 1;
        }

        $('.articulo_chequeado').each(function() {            
            $(this).attr('checked',chequeado); 
        }); 
    
        $('.articulo_valor').each(function() {            
            $(this).text(valor); 
        }); 
    });

    $("body").on("click",".articulo_chequeado",function(e) { 
        var codigo      = $(this).data('id');         
        if ( $(this).is(":checked")) {
            $("#articulo_valor_"+codigo).text(1);    
        } else{
            $("#articulo_valor_"+codigo).text(0);    
            $("#articulo_general").attr('checked',false); 
        }
    });  

    $("body").on("click",".remover_articulo",function(e) {         
        var tr = $(this).closest('tr');
        tr.remove();       
    });  
    
    $("body").on('click', '.editar',  function(event) {
            event.preventDefault();
            var id = $(this).data('id');
            
            var tmp_objetivo            = $("#tmp_objetivo"+id).val();
            var tmp_fnt_financiamiento  = $("#tmp_fnt_financiamiento"+id).val();
            var tmp_area_servicio       = $("#tmp_area_servicio"+id).val();
            var tmp_actividad_general   = $("#tmp_actividad_general"+id).val();
            var tmp_actividad_especifica= $("#tmp_actividad_especifica"+id).val();
            var tmp_fecha_desde         = $("#tmp_fecha_desde"+id).val();
            var tmp_fecha_hasta         = $("#tmp_fecha_hasta"+id).val();
            var tmp_act_pre             = $("#tmp_act_pre"+id).val();
            var tmp_aporte_ext          = $("#tmp_aporte_ext"+id).val();
            var tmp_aporte_int          = $("#tmp_aporte_int"+id).val();
            var tmp_fnt_verificacion    = $("#tmp_fnt_verificacion"+id).val();
        
            $("#dt_area_servicio_ed").val(tmp_area_servicio);
            $("#dt_area_servicio_ed").select2();

            $("#dt_actividad_general_ed").val(tmp_actividad_general);
            $("#dt_actividad_general_ed").select2();

            $("#dt_actividad_especifica_ed").val(tmp_actividad_especifica);
            $("#dt_actividad_especifica_ed").select2();

            $("#dt_fuente_financiamiento_ed").val(tmp_fnt_financiamiento);
            $("#dt_fuente_financiamiento_ed").select2();

            $("#dt_fecha_desde_ed").val(tmp_fecha_desde);
            $("#dt_fecha_hasta_ed").val(tmp_fecha_hasta);
            $("#dt_objetivo_ed").val(tmp_objetivo);
            $("#dt_presupuesto_actividad_ed").val(number_format(tmp_act_pre, cantidad_decimales, '.', ''));
            $("#dt_aporte_externo_ed").val(number_format(tmp_aporte_ext, cantidad_decimales, '.', ''));
            $("#dt_aporte_interno_ed").val(number_format(tmp_aporte_int, cantidad_decimales, '.', ''));

            $("#dt_fuente_verificacion_ed").val(tmp_fnt_verificacion);
            $("#dt_fuente_verificacion_ed").select2();
            
            $("#tmp_id_row").val(id);
            $("#tmp_valor_antiguo").val(tmp_act_pre);            
        
            $.fancybox({
                href    : $(this).attr('href'),
                autoSize: false,
                height  : '600',
                width   : '85%',
                closeBtn: true
            });
    });

    $("body").on('click', '.permisos',  function(event) {
        event.preventDefault();
        var html        = "";
        var id          = $(this).data('id');
        var json_permisos= $("#tmp_fnt_usuaios_permitidos_"+id).val();
        $("#tbody_permiso").html('');
        $("#tmp_id_row2").val(id);

       
        if (json_permisos != "") {
            var obj_permisos = jQuery.parseJSON( json_permisos );            
            $.each(obj_permisos, function(i, obj) {
                var cheque = (obj.valor == 1)?'checked="checked"':'';
               html += '<tr class="tr_permisos" data-id="'+obj.codigo+'">';
                    html += '<td id="permiso_codigo_'+obj.codigo+'" style="display:none;">'+obj.codigo+'</td>';
                    html += '<td id="permiso_nombre_'+obj.codigo+'">'+obj.nombre+'</td>';
                    html += '<td><input type="checkbox" class="nostyle permiso_chequeado" '+cheque+' data-codigo="'+obj.codigo+'"></td>';
                    html += '<td id="permiso_valor_'+obj.codigo+'" style="display:none;" class="permiso_valor">'+obj.valor+'</td>'
                html += '</tr>';
            });
        }

        $("#tbody_permiso").html(html);

        $.fancybox({
            href    : $(this).attr('href'),
            autoSize: false,
            height  : '500',
            width   : '60%',
            closeBtn: true
        });

        var chequeado   = true;

        $('.permiso_valor').each(function() {     
            if ( $(this).text() == 0 ) {
                chequeado   = false;  
            }
        }); 
        
        $("#permiso_chequeado_general").attr('checked',chequeado); 
        
    });

    $("body").on('click', '#btn_editar_permisos',  function(event) {        
        var resultado   = new Array();
        var fila        = $("#tmp_id_row2").val();
        if ( $(".tr_permisos").length ) {
            $( ".tr_permisos" ).each(function( index ) {
                var linea   = $(this).data("id");
                var codigo  = $("#permiso_codigo_"+linea).text();
                var nombre  = $("#permiso_nombre_"+linea).text();
                var valor   = $("#permiso_valor_"+linea).text();
              
                array_permisos = {
                    codigo: codigo,
                    nombre: nombre,
                    valor: valor
                }
                
                resultado.push(array_permisos);
              });    
        }

        $("#tmp_fnt_usuaios_permitidos_"+fila).val( JSON.stringify(resultado));
        $("#tmp_id_row2").val("");
        $("#tbody_permiso").html("");
        $.fancybox.close();
    });

    $("body").on("click",".permiso_chequeado_general",function(e) {
        var chequeado   = false;
        var valor       = 0;
        if ( $(this).is(":checked")) {
            chequeado = true;
            valor   = 1;
        }

        $('.permiso_chequeado').each(function() {            
            $(this).attr('checked',chequeado); 
        }); 
    
        $('.permiso_valor').each(function() {            
            $(this).text(valor); 
        }); 
    });

    $("body").on("click",".permiso_chequeado",function(e) { 
        var codigo      = $(this).data('codigo');         
        if ( $(this).is(":checked")) {
            $("#permiso_valor_"+codigo).text(1);    
        } else{
            $("#permiso_valor_"+codigo).text(0);    
            $("#permiso_chequeado_general").attr('checked',false); 
        }

    });
  
    $("body").on("click", ".select2-search-choice-close", function(e) {
        $(".plus:last").remove();
    });
    
    $("body").on("click", "#btnEditar_dt_presupuesto", function(e) {
        e.preventDefault();
            var valor_antiguo              = parseFloat($("#tmp_valor_antiguo").val());
            var area_servicio              = $("#dt_area_servicio_ed").val();
            var area_servicio_text         = $("#dt_area_servicio_ed option:selected").text();
            var actividad_general          = $("#dt_actividad_general_ed").val();
            var actividad_general_txt      = $("#dt_actividad_general_ed option:selected").text();
            var actividad_especifica       = $("#dt_actividad_especifica_ed").val();
            var actividad_especifica_txt   = $.trim($("#dt_actividad_especifica_ed option:selected").text());
            var fuente_financiamiento      = $("#dt_fuente_financiamiento_ed").val();
            var dt_fecha_desde             = $("#dt_fecha_desde_ed").val();
            var dt_fecha_hasta             = $("#dt_fecha_hasta_ed").val();
            var dt_objetivo                = $("#dt_objetivo_ed").val();
            var dt_presupuesto_actividad   = $("#dt_presupuesto_actividad_ed").val();
            var dt_aporte_externo          = $("#dt_aporte_externo_ed").val();
            var dt_aporte_interno          = $("#dt_aporte_interno_ed").val();
            var dt_fuente_verificacion     = $("#dt_fuente_verificacion_ed").val();
            var dt_fuente_verificacion_txt = $("#dt_fuente_verificacion_ed option:selected").text();
            var procesar_ingreso           = true;
            var tmp_id_row                 = $("#tmp_id_row").val();            
            var valor_calculado            = parseFloat(dt_presupuesto_actividad - valor_antiguo);
            var validacion                 = validar_presupuesto(valor_calculado);
            if ( validacion == false ) {
                return false;
            }

            if (!parseInt(actividad_especifica) > 0) {
                $('#dt_actividad_especifica_ed_error').text('Campo Requerido');
                procesar_ingreso = false;
            }
            
            if (!parseFloat(dt_presupuesto_actividad) > 0) {
                $('#dt_presupuesto_actividad_ed_error').text('Campo Requerido');
                procesar_ingreso = false;
            }
            
            if ($.trim(dt_fecha_desde) == "") {
                $('#dt_fecha_desde_ed_error').text('Campo Requerido');
                procesar_ingreso = false;
            }
            
            if ($.trim(dt_fecha_hasta) == "") {
                $('#dt_fecha_hasta_ed_error').text('Campo Requerido');
                procesar_ingreso = false;
            }        
            
            if (procesar_ingreso) {
                $("#tmp_objetivo"+tmp_id_row).val(dt_objetivo);
                $("#tmp_fnt_financiamiento"+tmp_id_row).val(fuente_financiamiento);
                
                $("#tmp_area_servicio"+tmp_id_row).val(area_servicio);
                $("#lbl_area_servicio"+tmp_id_row).val(area_servicio_text);
                
                $("#tmp_actividad_general"+tmp_id_row).val(actividad_general);
                $("#lbl_actividad_general"+tmp_id_row).text(actividad_general_txt);    
                
                $("#tmp_actividad_especifica"+tmp_id_row).val(actividad_especifica);
                $("#lbl_actividad_especifica"+tmp_id_row).text(actividad_especifica_txt);
                
                $("#tmp_fecha_desde"+tmp_id_row).val(dt_fecha_desde);
                $("#lbl_fecha_desde"+tmp_id_row).text(dt_fecha_desde);
                
                $("#tmp_fecha_hasta"+tmp_id_row).val(dt_fecha_hasta);
                $("#lbl_fecha_hasta"+tmp_id_row).text(dt_fecha_hasta);
                
                $("#tmp_act_pre"+tmp_id_row).val(dt_presupuesto_actividad);
                $("#lbl_act_pre"+tmp_id_row).text(number_format(dt_presupuesto_actividad, cantidad_decimales, ".", ","));
                
                $("#tmp_aporte_ext"+tmp_id_row).val(dt_aporte_externo);
                $("#lbl_aporte_ext"+tmp_id_row).text(number_format(dt_aporte_externo, cantidad_decimales, ".", ","));
                
                $("#tmp_aporte_int"+tmp_id_row).val(dt_aporte_interno);
                $("#lbl_aporte_int"+tmp_id_row).text(number_format(dt_aporte_interno, cantidad_decimales, ".", ","));
                
                $("#tmp_fnt_verificacion"+tmp_id_row).val(dt_fuente_verificacion);
                $("#lbl_fnt_verificacion"+tmp_id_row).text(dt_fuente_verificacion_txt);
                
                calcular_montos();
                
                $.fancybox.close();
            }
    });
    
    $("body").on("change", "#pre_fecha_desde", function() {
        validar_fecha_inicio_fin("pre_fecha_desde", "pre_fecha_hasta");
        
        $("#dt_fecha_desde").val( $(this).val() );
        $("#dt_fecha_hasta").val( $("#pre_fecha_hasta").val() );
    });
    
    $("body").on("change", "#pre_fecha_hasta", function() {
        validar_fecha_inicio_fin("pre_fecha_desde", "pre_fecha_hasta");
        $("#dt_fecha_hasta").val( $(this).val() );
        $("#dt_fecha_desde").val( $("#pre_fecha_desde").val() );
    });
    
    $("body").on("change", "#pre_fecha_desde_ed", function() {
        validar_fecha_inicio_fin("pre_fecha_desde", "pre_fecha_hasta");
    });
    
    $("body").on("change", "#pre_fecha_hasta_ed", function() {
        validar_fecha_inicio_fin("pre_fecha_desde", "pre_fecha_hasta");
    });
    
    $("body").on("change, keyup", "#dt_aporte_externo", function() {
        evaluar_presupuesto_actividad();
    });
    
    $("body").on("change, keyup", "#dt_aporte_interno", function() {
        evaluar_presupuesto_actividad();
    });
    
    $("#crear").on("click", function(e) {
        e.preventDefault();
        var mensaje = "";
        if ($("#frm_contenedor").valid() == true) {
            var cantidad_tr_body = $("#tb_contenido_body tr").length;
            if (!cantidad_tr_body > 0) {
                mensaje = "Debe agregar un detalle de Presupuesto.";
            } else {
                var validacion = validar_presupuesto(0);
                if ( validacion == false ) {
                    return false;
                }
                wait.start();                  
                $("select").select2("enable",true);
                $('select').prop("disabled", false);
                $("#frm_contenedor").submit();
            }
        } else {
            mensaje = "Campos con * son requeridos";
        }
        if (mensaje != "") {
                $.pnotify({
                    type: 'error',
                    title: 'Aviso',
                    text: mensaje,
                    icon: 'ui-icon ui-icon-info white',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
        }
    });

    $("body").on('change', '#slc_moneda', function () {
        if ( $(this).val() != "" ) {
            var valor = $(this + "option:selected").data( "valor");
            $("#taza_cambio").val(valor);
        } else {
            $("#taza_cambio").val("");
        }
    });

    $("#dt_actividad_general").change(function (){
        var general     = $(this).val();
        if ( general != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {general: general},
                url: urlj + 'modulo_presupuesto/pre_procesos/get_rubros',
                beforeSend: function () {
                    wait.start();
                    $("#dt_actividad_especifica").select2({ placeholder: 'Cargando...' });
                },
                success: function (data) {
                    $("#dt_actividad_especifica").html("");
                    $("#dt_actividad_especifica").html(data);
                    $("#dt_actividad_especifica").select2({placeholder: 'Seleccione'});
                    wait.close();
                }
            });
        } else {
            $("#dt_actividad_especifica").html("");
            $("#dt_actividad_especifica").html('<option value=""></option>');
            $("#dt_actividad_especifica").select2({placeholder: 'Seleccione'});
        }

    });

    validar_presupuesto_proyecto();
  
});

function validar_campo_repetido(valor, campo, padre){
    var validar_unico = false;
    var validacion = $(padre + ' tr input'+campo+'[value="'+valor+'"]').length;
    if(validacion != 0){
        validar_unico = true;
    }
    return validar_unico;
}

function aplicar_datatable(id){
    $(id).dataTable({
        //"sPaginationType": "full_numbers",
        "bFilter": false,
        "bJQueryUI": false,
        "bAutoWidth": true,
        "iDisplayLength": 5,        
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function calcular_montos() {
    if ($(".dtll_pre_actividad").length > 0) {
        var cantidad_total_act = 0;
        $(".dtll_pre_actividad").each(function(e) {
            cantidad_total_act += (!isNaN(parseFloat($(this).val()))) ? parseFloat($(this).val()) : 0;
        });    
    }
    $("#dt_total_actividad_general").text(number_format(cantidad_total_act, cantidad_decimales, ".", ","));
    
    if ($(".dtll_aporte_externo").length > 0) {
        var cantidad_total_ext = 0;
        $(".dtll_aporte_externo").each(function(e) {
            cantidad_total_ext += (!isNaN(parseFloat($(this).val()))) ? parseFloat($(this).val()) : 0;
        });    
    }
    $("#dt_total_aporte_externo").text(number_format(cantidad_total_ext, cantidad_decimales, ".", ","));
    
    if ($(".dtll_aporte_interno").length > 0) {
        var cantidad_total_int = 0;
        $(".dtll_aporte_interno").each(function(e) {
            cantidad_total_int += (!isNaN(parseFloat($(this).val()))) ? parseFloat($(this).val()) : 0;
        });    
    }
    $("#dt_total_aporte_interno").text(number_format(cantidad_total_int, cantidad_decimales, ".", ","));
    
    if ($(".dtll_aporte_interno").length > 0) {
        var cantidad_total_monto_eje = 0;
        $(".dtll_monto_eje").each(function(e) {
        	cantidad_total_monto_eje += (!isNaN(parseFloat($(this).val()))) ? parseFloat($(this).val()) : 0;
        });    
    }    
    $("#dt_total_monto_ejecutado").text(number_format(cantidad_total_monto_eje, cantidad_decimales, ".", ","));   
    
     
    if ($(".monto_x_ejecutar").length > 0) {
        var monto_x_ejecutar = 0;
        $(".monto_x_ejecutar").each(function(e) {
        	monto_x_ejecutar += (!isNaN(parseFloat($(this).text()))) ? parseFloat($(this).text().replace(/,/gi, "")) : 0;
        });    
    }    
    $("#dt_totao_monto_ejecutado").text(number_format(monto_x_ejecutar, cantidad_decimales, ".", ","));   
    
}

function getOpcionesSelect(idElemento) {

    var opciones = "";
    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        opciones += this.outerHTML;
    });

    return opciones;
}

function evaluar_presupuesto_actividad() {
    var presupuesto = parseFloat($("#dt_presupuesto_actividad").val());
    var externo     = parseFloat($("#dt_aporte_externo").val());
    var interno     = parseFloat($("#dt_aporte_interno").val());
    
    suma = externo + interno;
    
    if (suma > presupuesto) {
        crear_alerta("error", "Error", "Aporte Externo e Interno no debe ser mayor al Presupuesto de la Actividad");
        $("#dt_aporte_externo").val('');
        $("#dt_aporte_interno").val('');
    }
}

function validar_montos_totales() {

    var cantidad_total_act = 0;
    var cantidad_total_ext = 0;
    var cantidad_total_int = 0;
    if ($(".dtll_pre_actividad").length > 0) {
        $(".dtll_pre_actividad").each(function(e) {
            cantidad_total_act += parseFloat($(this).val());
        });
    }
    
    if ($(".dtll_aporte_externo").length > 0) {
        $(".dtll_aporte_externo").each(function(e) {
            cantidad_total_ext += parseFloat($(this).val());
        });
    }
    
    if ($(".dtll_aporte_interno").length > 0) {        
        $(".dtll_aporte_interno").each(function(e) {
            cantidad_total_int += parseFloat($(this).val());
        });
    }
    
    var sumaTotal = cantidad_total_ext + cantidad_total_int;
    
    if (sumaTotal > cantidad_total_act) {
        return true;
    } else {
        return false;
    }

}

function validar_monto_total() {
	// Obtener total
	var total 		= $("#dt_total_actividad_general").text().replace(/,/gi, "");
	total     		= parseFloat(total);
	// presupuesto total
	var pre_total 	= parseFloat($("#pre_presupuesto_total").val());
	// Valor agregado
	var add_cantidad = parseFloat($("#dt_presupuesto_actividad").val());
	// Totalidad para verificar si procede
	var suma = parseFloat(total + add_cantidad);
	if (suma > pre_total) {
		return true;
	} else {
		return false;
	}
}

function get_usuarios_permitidos_generales(actividad_general, correlativo) {
    if ( actividad_general != "" ) {
        $.ajax({
            dataType: 'json',
            type: 'post',
            data: {actividad_general: actividad_general},
            url: urlj + 'modulo_presupuesto/pre_procesos/get_usuarios_permitidos_generales',
            success: function (obj) {
               // if (obj.length > 0 ) {
                    $("#tmp_fnt_usuaios_permitidos_"+correlativo).val(JSON.stringify(obj));
                //} 
            }
        });
    } 
}

function validar_presupuesto( valor_antiguo ){
    var suma_detalles   = 0;
    var result          = true;
    var monto_global    = parseFloat($("#pre_presupuesto_total").val());
    $(".dtll_pre_actividad").each(function(e) {
        suma_detalles += parseFloat($(this).val());
    });

    suma_detalles += parseFloat(valor_antiguo);

    if ( suma_detalles > monto_global) {
        result          = false;
        var sobre_giro  = number_format((suma_detalles - monto_global), cantidad_decimales, ".", ",");
        crear_alerta("error", "Presupuesto total", "El presupuesto de $" + number_format(monto_global, cantidad_decimales, ".", ",") + " ha sido superado por $"+sobre_giro+".");
    }

    return result;
}

function validar_presupuesto_proyecto() {
    if ( $("#pre_presupuesto_total").val() != "" && $("#pre_proyecto").val() ) {
        var valor_proyecto      = $('#pre_proyecto').find(':selected').data('presupuesto');
        var valor_presupuesto   = $("#pre_presupuesto_total").val();
        valor_proyecto          = (valor_proyecto != "")?valor_proyecto:0;
        valor_presupuesto       = (valor_presupuesto != "")?valor_presupuesto:0;

        if ( parseFloat(valor_presupuesto) > parseFloat(valor_proyecto) ) {
            crear_alerta("error", "Presupuesto del proyecto", "Monto del proyecto es insuficiente para el proyecto.("+valor_proyecto+")");
            $("#pre_presupuesto_total").val("");
        }
    }
}