var cantidad_decimales         = $("#cantidad_decimales").val();

$(document).ready(function() {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    
    //$(".input_fecha").mask("99-99-9999");
    $(".input_fecha").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });    
    
	$("select").select2();
	aplicar_datatable("#dt_table_presupuesto");
	
	$("body").on("change", "#pre_tipo_presupuesto", function(e) {
		e.preventDefault();
		var tipo_pre = $(this).val();	
		if (parseInt(tipo_pre) > 0) {
			$.ajax({
				url: urlj + "modulo_presupuesto/pre_procesos/obtener_presupuestosxtipo",
				data: {id_tipo_presupuesto: tipo_pre},
				type: "POST",
				dataType: 'json',
				beforeSend:function(){
					wait.start();
				},
				success: function (data) {
					wait.close();
					$("#pre_presupuesto").html('');
					$("#pre_presupuesto").html(data.html);
					$("#pre_presupuesto").select2();
				}

			});
			
		} else {
			// Reset select
			$("#pre_presupuesto").html('');
			var select_reset = '<option value=""></option>' + $("#presupuestos_hidden").val();
			$("#pre_presupuesto").html(select_reset);
			$("#pre_presupuesto").val("");
			$("#pre_presupuesto").select2();
		}

		$("#pre_presupuesto").trigger('change');
		$("#slc_actividad_general").trigger('change');
	});

	$("#pre_presupuesto").change(function (){
        var presupuesto	= $(this).val();
        if ( presupuesto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {presupuesto: presupuesto},
                url: urlj + 'modulo_presupuesto/pre_procesos/get_actividad_general_x_presupuesto',
                success: function (data) {
                    $("#slc_actividad_general").html("");
                    $("#slc_actividad_general").html(data);
                    $("#slc_actividad_general").select2({placeholder: 'Seleccione'});
                }
            });
        } else {
            $("#slc_actividad_general").html("");
            $("#slc_actividad_general").html('<option value=""></option>');
            $("#slc_actividad_general").select2({placeholder: 'Seleccione'});
		}
		
		$("#slc_actividad_general").trigger('change');
    });

	$("#slc_actividad_general").change(function (){
		var presupuesto	= $("#pre_presupuesto").val();
        var general     = $(this).val();
        if ( general != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {
					general: general,
					presupuesto:presupuesto
				},
                url: urlj + 'modulo_presupuesto/pre_procesos/get_actividades_especificas_x_actividad_general',
                success: function (data) {
                    $("#slc_actividad_espeficifica").html("");
                    $("#slc_actividad_espeficifica").html(data);
                    $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione'});
                }
            });
        } else {
            $("#slc_actividad_espeficifica").html("");
            $("#slc_actividad_espeficifica").html('<option value=""></option>');
            $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione'});
        }

    });
	
	$("body").on("click", "#btnConsultar", function(e) {
		e.preventDefault();
		
		var tipo_pre    		= $("#pre_tipo_presupuesto").val();
		var presupuesto 		= $("#pre_presupuesto").val();
		var actividad_general	= $("#slc_actividad_general").val();
		var actividad_especifica= $("#slc_actividad_espeficifica").val();
		
		if (parseInt(presupuesto) > 0) {
			
			$.ajax({
				url: urlj + "modulo_presupuesto/pre_procesos/agregar_gastos",
				data: {
					id_tipo_presupuesto: tipo_pre, 
					presupuesto: presupuesto,
					actividad_general,
					actividad_especifica
				},
				type: "POST",
				dataType: 'json',
				beforeSend:function(){
					wait.start();
				},
				success: function (data) {
					wait.close();
					$('#dt_table_presupuesto').dataTable().fnDestroy();
					$("#tb_contenido_body").html(data.tabla);
					aplicar_datatable('#dt_table_presupuesto');
					$("#dt_total_actividad_general").text( number_format(data.presupuesto_actividad, cantidad_decimales, ".", ",") );
					$("#dt_total_monto_ejecutado").text( number_format(data.monto_ejecutado, cantidad_decimales, ".", ",") );
					$("#dtll_montoxejecutar").text( number_format(data.montoxejecutar, cantidad_decimales, ".", ",") );
					$("#dt_total_aporte_interno").text( number_format(data.aporte_interno, cantidad_decimales, ".", ",") );
					$("#dt_total_aporte_externo").text( number_format(data.aporte_externo, cantidad_decimales, ".", ",") );
					//calcular_montos();
				}

			});
			
		} else {
			crear_alerta("error", "Error", "El Campo Presupuesto es requerido.");
			//$("#pre_presupuesto_error").text("Campo Requerido");
		}
	});
	
	$("body").on("click", ".agregar_gasto", function(e) {
		e.preventDefault();
		if ( $(this).data("permiso") == 0) {
			crear_alerta("info", "Permisos de sucursal", "Su usuario no pertenece a la sucursal de presupuesto asignado.");
			return false;
		}
		// ID 
		var id_actividad = $(this).data("id");
		$("#id_hiiden_gasto").val(id_actividad);
		var id_gasto 	 = $("#tmp_id_gasto"+id_actividad).val();
		$("#id_gasto").val($("#tmp_id_gasto"+id_actividad).val());
		
		$.ajax({
			url: urlj + "modulo_presupuesto/pre_procesos/obtener_detalles_gastos",
			data: { id_gasto: id_gasto },
			type: "POST",
			dataType: 'json',
			beforeSend:function(){
				wait.start();
			},
			success: function (data) {
				wait.close();
				//$('#dt_table_presupuesto').dataTable().fnDestroy();
				$("#tb_contenido_gastos_body").html(data.tabla);
				calcular_monto_ejecutado_total();
		        calcular_monto_disponible();	
				//aplicar_datatable('#dt_table_presupuesto');
				//calcular_montos();
			}

		});
		
		// Reset
		// $("#ag_fecha_gasto").val('');
		
		var actividad_general 	  = $("#tmp_actividad_general"+id_actividad).val();
		var actividad_especifica  = $("#tmp_actividad_especifica"+id_actividad).val();
		var presupuesto_actividad = $("#tmp_act_pre"+id_actividad).val();
		
		$("#ag_actividad_general").val(actividad_general);
		$("#ag_actividad_general").select2();
		
		$("#ag_actividad_especifica").val(actividad_especifica);
		$("#ag_actividad_especifica").select2();
		
		$("#ag_presupuesto_actividad").val(number_format(presupuesto_actividad, cantidad_decimales, '.', ''));

		$("#ag_desde").val( $("#lbl_fecha_desde"+id_actividad).text() );		
		$("#ag_hasta").val( $("#lbl_fecha_hasta"+id_actividad).text() );
		
        $.fancybox({
            href    : $(this).attr('href'),
            autoSize: false,
            height  : '600',
            width   : '90%',
			closeBtn: true,
			afterClose: function () {
                $("#ag_fecha_gasto").val('');
				$("#ag_tipo_gasto").val(0);
				$("#ag_tipo_gasto").select2();
				$("#ag_descripcion").val('');
				$("#ag_referencia").val('');
				$("#ag_monto").val('');
				$("#ag_cantidad").val('');
				$("#ag_total_gasto").val('');
				remove_selected_selectMultiple("#slc_impuestos");
				remove_selected_selectMultiple("#slc_retenciones");
            }
        });
        
	});
	
	$("#frm_agregar_gastos").on("change", "#ag_fecha_gasto", function(e) {
		e.preventDefault();
		var id_actividad = $("#id_hiiden_gasto").val(); 
		var fecha_gasto  = $(this).val();
		
		var fechaInicio  = $("#tmp_fecha_desde"+id_actividad).val();
		var fechaFin     = $("#tmp_fecha_hasta"+id_actividad).val();
		
		if (validar_fechaMayorQue(fechaInicio, fechaFin, fecha_gasto)) {
			$("#ag_fecha_gasto").val('');
	    	crear_alerta("error", "Error Fecha", "Fecha fuera de rango");
		}
	});
	
    var row = 0;
    if ($('#tb_contenido_gastos_body .gst_detalle_tr').length > 0) {
        row = $("#tb_contenido_gastos_body .gst_detalle_tr").length;
    }
	
	$("#frm_agregar_gastos").on("click", "#btnAgregarGasto", function(e) {
		e.preventDefault();

		var fecha_gasto 	 = $("#ag_fecha_gasto").val();
		var tipo_gasto  	 = $("#ag_tipo_gasto").val();
		var tipo_gasto_text  = $("#ag_tipo_gasto option:selected").text();
		var descripcion 	 = $("#ag_descripcion").val();
		var referencia 	 	 = $("#ag_referencia").val();
		var monto			 = $("#ag_monto").val();
		var cantidad		 = $("#ag_cantidad").val();
		var id_gasto 		 = $("#id_gasto").val();
		var total_gasto	     = $("#ag_total_gasto").val();
		var sucursal_txt     = $("#ag_sucursal_txt").val();
		var sucursal	     = $("#ag_sucursal").val();
		var validar 		 = false;
		var campo_validar    = fecha_gasto+"_"+tipo_gasto+"_"+cantidad+"_"+total_gasto;
		if ( sucursal <= 0) {
			validar = true;
			mensaje = "Verifique los datos de la sucursal";
		}

		if ($.trim(fecha_gasto) == "") {
			// console.log("fecha de Gasto");
			// $("#ag_fecha_gasto_error").text("Campo Requerido");
			validar = true;
			mensaje = "Verifique la fecha del gasto";
		}

		if (!parseInt(tipo_gasto) > 0) {
			// console.log("Tipo de Gasto");
			// $("#ag_tipo_gasto_error").text("Campo Requerido");
			validar = true;
			mensaje = "Verifique el tipo de gasto";
		}

		if (!parseFloat(monto) > 0) {
			// console.log("Monto de Gasto");
			//$("#ag_monto_error").text("Campo Requerido");
			validar = true;
			mensaje = "Verifique el monto de gasto";
		}

		if (!parseFloat(cantidad) > 0) {
			// console.log("Monto de Gasto");
			//$("#ag_monto_error").text("Campo Requerido");
			validar = true;
			mensaje = "Verifique la cantidad ingresada";
		}

		if (validar) {
			crear_alerta("error", "Error en Campos", "Los campos con (*) son requeridos. " + mensaje);
			return false;
		}

		if (!parseFloat(total_gasto) > 0) {
			crear_alerta("error", "Error", "EL total de gastos debe ser mayor a cero.");
			return false;
		}
		
        if(validar_campo_repetido((campo_validar), ".dtll_gasto_validar", "#tb_contenido_gastos_body")){
            crear_alerta("info", "Aviso", 'El registro ya fue ingresado.');
            return false;
        }
        
        if (validar_monto_pre_actividad() > 0) {
        	crear_alerta("info", "Aviso", 'El monto del gasto no debe sobrepasar al monto de presupuesto de la actividad.');
            return false;
		}
		
		var sub_total   		= monto * cantidad;
		var impuestos 			= getOpcionesSelectResult("slc_impuestos",cantidad,sub_total);	
		var retenciones 		= getOpcionesSelectResult("slc_retenciones",cantidad,sub_total);

		var gst_slc_impuestos	=  get_selected("#slc_impuestos");
		var gst_slc_retenciones	=  get_selected("#slc_retenciones");

		var gst_porcentajes_impuestos	=  get_porcentajes("#slc_impuestos");
		var gst_porcentajes_retenciones	=  get_porcentajes("#slc_retenciones");

		gst_conf            = '<input type="hidden" class="dtll_gasto_validar" value="'+(campo_validar)+'">' ;
		
		gst_indice 		    = '<label id="lbl_indice'+row+'" style="padding: 6px 4px;">'+number_format(row+1)+'</label>';
		
		gst_fecha_gasto     = '<input type="hidden" id="tmp_fecha_gasto'+row+'" name="tmp_fecha_gasto[]" value="'+fecha_gasto+'">'+
		'<input type="text" id="lbl_fecha_gasto'+row+'" class="text tables-input" style="padding: 6px 4px;" value="' + fecha_gasto + '" readonly>';

		gst_tipo_gasto      = '<input type="hidden" id="tmp_tipo_gasto'+row+'" name="tmp_tipo_gasto[]" value="'+tipo_gasto+'">'+
		'<label id="lbl_tipo_gasto'+row+'" style="padding: 6px 4px;">'+tipo_gasto_text+'</label>';

		gst_descripcion     = '<input type="hidden" id="tmp_descripcion'+row+'" name="tmp_descripcion[]" value="'+descripcion+'">'+
		'<label id="lbl_descripcion'+row+'" style="padding: 6px 4px;">'+descripcion+'</label>';
		
		gst_referencia      = '<input type="hidden" id="tmp_referencia'+row+'" name="tmp_referencia[]" value="'+referencia+'">'+
		'<label id="lbl_referencia'+row+'" style="padding: 6px 4px;">'+referencia+'</label>';
		
		gst_origen_gasto    = '<input type="hidden" id="tmp_origen_gasto'+row+'" name="tmp_origen_gasto[]" value="">'+
		'<label id="lbl_origen_gasto'+row+'" style="padding: 6px 4px;"></label>';		

		gst_cantidad	    = '<input type="hidden" id="tmp_cantidad'+row+'" class="tmp_cantidad" name="tmp_cantidad[]" value="'+cantidad+'">'+
		'<label id="lbl_tmp_cantidad'+row+'" style="padding: 6px 4px;">'+number_format(cantidad, cantidad_decimales, ".", ",")+'</label>';

		gst_monto_gasto     = '<input type="hidden" id="tmp_sub_monto_gasto'+row+'" class="tmp_sub_monto_gasto" name="tmp_sub_monto_gasto[]" value="'+sub_total+'">'+
		'<label id="lbl_sub_monto_gasto'+row+'" style="padding: 6px 4px;">'+number_format(sub_total, cantidad_decimales, ".", ",")+'</label>';

		gst_impuesto		= '<input type="hidden" name="slc_impuestos[]" value="'+gst_slc_impuestos+'">'+
		'<input type="hidden" name="porcentaje_impuestos[]" value="'+gst_porcentajes_impuestos+'">'+
		'<input type="hidden" id="tmp_impuesto'+row+'" class="tmp_impuesto" name="tmp_impuesto[]" value="'+impuestos+'">'+
		'<label id="lbl_impuesto'+row+'" style="padding: 6px 4px;">'+number_format(impuestos, cantidad_decimales, ".", ",")+'</label>';
		
		gst_retenciones		= '<input type="hidden" name="slc_retenciones[]" value="'+gst_slc_retenciones+'">'+
		'<input type="hidden" name="porcentaje_retenciones[]" value="'+gst_porcentajes_retenciones+'">'+
		'<input type="hidden" id="tmp_retenciones'+row+'" class="tmp_retenciones" name="tmp_retenciones[]" value="'+retenciones+'">'+
		'<label id="lbl_retencion'+row+'" style="padding: 6px 4px;">'+number_format(retenciones, cantidad_decimales, ".", ",")+'</label>';
		
		gst_total_gasto     = '<input type="hidden" id="tmp_monto_gasto'+row+'" class="tmp_monto_gasto" name="tmp_monto_gasto[]" value="'+total_gasto+'">'+
		'<label id="lbl_monto_gasto'+row+'" style="padding: 6px 4px;">'+number_format(total_gasto, cantidad_decimales, ".", ",")+'</label>';
		
		eliminar = '<a class="btn btn-danger icon16 icomoon-icon-remove remover_tr" data-id="'+row+'" title="Eliminar" style="margin-right: 5px;cursor:pointer;font-size:12px;width: 61%;">Eliminar</a>';
		
		gst_acciones = eliminar;

		gst_sucursal	     = '<input type="hidden" id="tmp_sucursal_'+row+'" class="tmp_sucursal" name="tmp_sucursal[]" value="'+sucursal+'">'+
		'<label id="lbl_sucursal_'+row+'" style="padding: 6px 4px;">'+sucursal_txt+'</label>';
		
        $("#tb_contenido_gastos_body").append('<tr id="gst_detalle_tr'+row+'" data-id="' + row + '" class="gst_detalle_tr">'+
                '<td width="3%">'+ gst_conf + gst_indice +'</td>'+
                '<td width="6%">'+ gst_fecha_gasto +'</td>'+
                '<td width="8%">'+ gst_tipo_gasto +'</td>'+
                '<td width="15%">'+ gst_descripcion +'</td>'+
				'<td width="10%">'+ gst_referencia +'</td>'+
				'<td width="6%">'+ gst_cantidad +'</td>'+
				'<td width="9%">'+ gst_monto_gasto +'</td>'+
				'<td width="9%">'+ gst_impuesto +'</td>'+
				'<td width="10%">'+ gst_retenciones +'</td>'+
				'<td width="10%">'+ gst_total_gasto +'</td>'+
				'<td width="10%">'+ gst_origen_gasto +'</td>'+
				'<td width="10%">'+ gst_sucursal +'</td>'+
                '<td width="4%" style="text-align: center;">'+gst_acciones+'</td>'+
		'</tr>');
        
        $("#dt_table_gastos").css("width", "100%");
        
        calcular_monto_ejecutado_total();
        calcular_monto_disponible();
        
        row = row + 1;
        
        $("#ag_fecha_gasto").val('');
        $("#ag_tipo_gasto").val(0);
        $("#ag_tipo_gasto").select2();
        $("#ag_descripcion").val('');
        $("#ag_referencia").val('');
		$("#ag_monto").val('');
		$("#ag_cantidad").val('');
		$("#ag_total_gasto").val('');
		remove_selected_selectMultiple("#slc_impuestos");
		remove_selected_selectMultiple("#slc_retenciones");
	});
	
    $("body").on('click', ".remover_tr",  function(){ //elimina el componente agregado
        var tr = $(this).closest('tr');
        var body = $(this).closest('tbody');
        var tabla = $(this).closest('table').attr('id');
        //$('#'+tabla).dataTable().fnDestroy();
        tr.remove();
        calcular_monto_ejecutado_total();
        calcular_monto_disponible();
        //aplicar_datatable('#'+tabla);
        //if(!(body.find('tr.tr_body_direccion_tbl').length > 0)){}
	});
	
	$("body").on("change",".total_gasto", function() {
		var total = calcular_total_gasto();
		$("#ag_total_gasto").val(total);
	});

	$("body").on("click","#crear_gasto", function() {
		if ( $("#dt_table_gastos > tbody > tr").length > 0 ) {
			var id_gasto 				= $("#id_gasto").val();
			var tmp_fecha_gasto 		= $("input[name='tmp_fecha_gasto[]']").map(function(){return $(this).val();}).get();
			var tmp_tipo_gasto 			= $("input[name='tmp_tipo_gasto[]']").map(function(){return $(this).val();}).get();
			var tmp_descripcion 		= $("input[name='tmp_descripcion[]']").map(function(){return $(this).val();}).get();
			var tmp_referencia 			= $("input[name='tmp_referencia[]']").map(function(){return $(this).val();}).get();
			var tmp_monto_gasto 		= $("input[name='tmp_monto_gasto[]']").map(function(){return $(this).val();}).get();
			var tmp_origen_gasto 		= $("input[name='tmp_origen_gasto[]']").map(function(){return $(this).val();}).get();
			var tmp_sub_monto_gasto 	= $("input[name='tmp_sub_monto_gasto[]']").map(function(){return $(this).val();}).get();
			var tmp_impuesto 			= $("input[name='tmp_impuesto[]']").map(function(){return $(this).val();}).get();
			var tmp_retenciones 		= $("input[name='tmp_retenciones[]']").map(function(){return $(this).val();}).get();
			var tmp_cantidad 			= $("input[name='tmp_cantidad[]']").map(function(){return $(this).val();}).get();
			var slc_impuestos 			= $("input[name='slc_impuestos[]']").map(function(){return $(this).val();}).get();
			var slc_retenciones 		= $("input[name='slc_retenciones[]']").map(function(){return $(this).val();}).get();
			var porcentaje_impuestos 	= $("input[name='porcentaje_impuestos[]']").map(function(){return $(this).val();}).get();
			var porcentaje_retenciones	= $("input[name='porcentaje_retenciones[]']").map(function(){return $(this).val();}).get();
			var tmp_sucursal			= $("input[name='tmp_sucursal[]']").map(function(){return $(this).val();}).get();

			$.ajax({
				url: urlj + "modulo_presupuesto/pre_procesos/guardar_gasto",
				data: { 
					id_gasto: id_gasto,
					tmp_fecha_gasto: tmp_fecha_gasto,
					tmp_tipo_gasto: tmp_tipo_gasto,
					tmp_descripcion: tmp_descripcion,
					tmp_referencia: tmp_referencia,
					tmp_monto_gasto: tmp_monto_gasto,
					tmp_origen_gasto: tmp_origen_gasto,
					tmp_sub_monto_gasto: tmp_sub_monto_gasto,
					tmp_impuesto: tmp_impuesto,
					tmp_retenciones: tmp_retenciones,
					tmp_cantidad: tmp_cantidad,
					slc_impuestos: slc_impuestos,
					slc_retenciones: slc_retenciones,
					porcentaje_impuestos: porcentaje_impuestos,
					porcentaje_retenciones: porcentaje_retenciones,
					tmp_sucursal: tmp_sucursal
				},
				type: "POST",
				dataType: 'text',
				beforeSend:function(){
					wait.start();
				},
				success: function (data) {
					$("#btnConsultar").trigger("click");
					crear_alerta("success", "Gastos", "Se agregaron los gastos");
					$.fancybox.close();
					wait.close();
				}
	
			});
		} else {
			crear_alerta("info", "Gasto", "Favor agregue gastos.");
		}
	});
    
});

function aplicar_datatable(id){
    $(id).dataTable({
        //"sPaginationType": "full_numbers",
        "bFilter": true,
        "bJQueryUI": false,
        "bAutoWidth": true,
        "iDisplayLength": 5,        
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function calcular_montos() {
    if ($(".dtll_pre_actividad").length > 0) {
        var cantidad_total_act = 0;
        $(".dtll_pre_actividad").each(function(e) {
            cantidad_total_act += (!isNaN(parseFloat($(this).val()))) ? parseFloat($(this).val()) : 0;
        });    
    }
    $("#dt_total_actividad_general").text(number_format(cantidad_total_act, cantidad_decimales, ".", ","));
    
    if ($(".dtll_aporte_externo").length > 0) {
        
        var cantidad_total_ext = 0;
        $(".dtll_aporte_externo").each(function(e) {
            cantidad_total_ext += (!isNaN(parseFloat($(this).val()))) ? parseFloat($(this).val()) : 0;
        });    
    }
    $("#dt_total_aporte_externo").text(number_format(cantidad_total_ext, cantidad_decimales, ".", ","));
    
    if ($(".dtll_aporte_interno").length > 0) {
        
        var cantidad_total_int = 0;
        $(".dtll_aporte_interno").each(function(e) {
            cantidad_total_int += (!isNaN(parseFloat($(this).val()))) ? parseFloat($(this).val()) : 0;
        });    
    }
    $("#dt_total_aporte_interno").text(number_format(cantidad_total_int, cantidad_decimales, ".", ","));
    
    if ($(".dtll_aporte_interno").length > 0) {
        
        var cantidad_total_monto_eje = 0;
        $(".dtll_monto_eje").each(function(e) {
        	cantidad_total_monto_eje += (!isNaN(parseFloat($(this).val()))) ? parseFloat($(this).val()) : 0;
        });    
    }    
    $("#dt_total_monto_ejecutado").text(number_format(cantidad_total_monto_eje, cantidad_decimales, ".", ","));

    if ($(".dtll_montoxejecutar").length > 0) {
        
        var cantidad_montoxejecutar = 0;
        $(".dtll_montoxejecutar").each(function(e) {
        	cantidad_montoxejecutar += (!isNaN(parseFloat($(this).val()))) ? parseFloat($(this).val()) : 0;
        });    
    }    
    $("#dtll_montoxejecutar").text(number_format(cantidad_montoxejecutar, cantidad_decimales, ".", ","));
}

function validar_fechaMayorQue(fechaInicial, fechaFinal, fechaEvaluar)
{
    valuesInicio = fechaInicial.split("-");
    valuesFin    = fechaFinal.split("-");
    valuesActual = fechaEvaluar.split("-");

    // Verificamos que la fecha no sea posterior a la actual
    var dateInicio   = new Date(valuesInicio[2],(valuesInicio[1]-1),valuesInicio[0]);
    var dateFin 	 = new Date(valuesFin[2],(valuesFin[1]-1),valuesFin[0]);
    var dateEvaluar	 = new Date(valuesActual[2],(valuesActual[1]-1),valuesActual[0]);
    
    if(dateEvaluar >= dateInicio && dateEvaluar <= dateFin) {
    	return false;
    } else {
    	return true;
    }
    
}

function calcular_monto_disponible() {
	var id_actividad 		  = $("#id_hiiden_gasto").val();
	var presupuesto_actividad = $("#tmp_act_pre"+id_actividad).val();
	var monto_ejecutado 	  = $("#ag_monto_ejecutado").val();
	var restaTotal			  = parseFloat(presupuesto_actividad - monto_ejecutado);
	// Neto 
	$("#ag_disponible").val(number_format(restaTotal, cantidad_decimales, ".", ""));
	
}

function validar_campo_repetido(valor, campo, padre){
    var validar_unico = false;
    var validacion = $(padre + ' tr input'+campo+'[value="'+valor+'"]').length;
    if(validacion != 0){
        validar_unico = true;
    }
    return validar_unico;
}

function calcular_monto_ejecutado_total() {
	var total = 0;
	$(".tmp_monto_gasto").each(function() {
		total += parseFloat($(this).val());
	});
	$("#ag_monto_ejecutado").val(number_format(total, cantidad_decimales, ".", ""));
	$("#ag_total_monto_gasto").text(number_format(total, cantidad_decimales, ".", ","));
}

function validar_monto_pre_actividad() {
	var monto_pre_act 	= parseFloat($("#ag_presupuesto_actividad").val());
	var monto		  	= parseFloat($("#ag_monto").val());
	var total_gasto		= parseFloat($("#ag_total_gasto").val());
	var neto 		  	= 0;
	
	if ( $("#sobre_giro").val() == 0 ) {
		return 0;
	}

	$(".tmp_monto_gasto").each(function() {
		neto += parseFloat($(this).val());
	});
	
	var sumatoria = neto + total_gasto;
	if (sumatoria <= monto_pre_act) {
		return 0;
	} else {
		return 1;
	}
}

function getOpcionesSelectResult(idElemento, cantidad, sub_total) {
	var porcentaje_impuesto = 0;
	var valor_impuesto		= 0;
	var total				= 0;

    $("#" + idElemento + "  option:selected").each(function () {
        if ( $(this).data('tipo') == 1 ) {
			porcentaje_impuesto += parseFloat( $(this).data('porcentaje') );
        } else  {
			valor_impuesto += parseFloat($(this).data('porcentaje')) * parseFloat(cantidad);
		} 
	});
	
	total = parseFloat( ((sub_total * porcentaje_impuesto)/100)+valor_impuesto);
    return total;
}

function calcular_total_gasto() {
	var cantidad 	= ( $("#ag_cantidad").val() != "" )? parseFloat($("#ag_cantidad").val()):0;
	var monto	 	= ( $("#ag_monto").val() != "" )? parseFloat($("#ag_monto").val()):0;
	var sub_total	= cantidad * monto
	var impuestos 	= getOpcionesSelectResult("slc_impuestos",cantidad,sub_total);	
	var retenciones = getOpcionesSelectResult("slc_retenciones",cantidad,sub_total);
	var total = (sub_total + parseFloat(impuestos) - parseFloat(retenciones));
	return number_format(total,cantidad_decimales,'.','');
}

function remove_selected_selectMultiple(select){
	$(select + " option:selected").each(function () {
		$(this).removeAttr("selected");
   });
   $(select).select2();
}


function get_selected(select){
	var selected = "";
	$(select + " option:selected").each(function () {
		selected += $(this).val() + ",";
   });
   selected = selected.substring(0,selected.length-1);
   return selected
}

function get_porcentajes(select){
	var porcentaje = "";
	$(select + " option:selected").each(function () {
		porcentaje += $(this).data('porcentaje') + ",";
   });
   porcentaje = porcentaje.substring(0,porcentaje.length-1);
   return porcentaje
}