$(document).ready( function(){
    $("select").select2();

    $("#slcArea").select2({
        placeholder: "Buscar Área",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'estructura_organizativa/procesos/get_areas_ajax',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (area) {
                return {
                    area: area
                }
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.are_id,
                        'text': item.are_nombre
                    });
                });

                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $(document).on('change','#slcMatriz',function(){
        $("#slcMatriz_error").html("");
    });
    
    $("#form_filtro").validate({
        ignore:"",
        rules: {
            slcMatriz:{required: true}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    
        
});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
