$(document).ready(function () {
    $('select').select2({placeholder: "Seleccione"});

    luz_alerta();

    $(".datepicker").datepicker({
        dateFormat: 'dd-mm-yy',
        changeMonth: true,
        changeYear: true,
        maxDate: 0
    });
    $(".datepicker").mask("99-99-9999");
    $(".datepicker").attr('placeholder', "dd-mm-yyyy");

    $(document).on('click', '#bHlkRegresar', function(e){
        e.preventDefault();
        url = $('#bHlkRegresar').attr('href');
        alerta_confirm_ajax(go_back, url, 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados y si sales, se perderán. ¿Éstas seguro que quieres regresar a la lista?');
    });

    $("#slc_detalles").change(function() {
        var indic = $(this).val();
        if (indic != "") {
            var avanc = $("#slc_detalles option:selected").data("avance");
            $("#txt_porcent, #min_porc").val(number_format(avanc, 2));
        } else {
            $("#txt_porcent, #min_porc").val("");
        }
    });

    $('#agregar').live('click', function (event) {
        event.preventDefault();
        var indi = $("#slc_detalles").val();
        var fech = $("#txt_fecha_act").val();
        var logr = $("#txt_logro").val();
        var limi = $("#txt_limitante").val();
        var stat = $("#slc_state_lgr").val();
        var porc = $("#txt_porcent").val();
        var minp = $("#min_porc").val();
        if (indi > 0 && stat > 0 && porc != "") {
            if (parseFloat(minp) >= 100) {
                crear_alerta('info', 'No se puede agregar', 'La acción ya fue registrada como completada.');
                return false;    
            }
            if (parseFloat(porc) > 100) {
                crear_alerta('error', 'Error', 'El porcentaje no debe exceder el 100%');
                $("#txt_porcent").val('');
                return false; 
            }
            if (parseFloat(porc) < parseFloat(minp)) {
                crear_alerta('info', 'Porcentaje', 'El porcentaje no debe ser menor a lo almacenado.');
                return false; 
            }
            if ($("#tr_inr_" + indi).length > 0) {
                crear_alerta('error', 'Error', 'La acción ya ha sido ingresada');
                return false;
            }
            var ind_txt = $("#slc_detalles option:selected").text();
            var stt_txt = $("#slc_state_lgr option:selected").text();
            var tr = '<tr id="tr_inr_' + indi + '"><td><input type="hidden" name="indicador[]" id="indicador_' + indi + '" value="' + indi + '">';
            tr += '<input type="hidden" name="estado[]" id="estado_' + indi + '" value="' + stat + '"><input type="hidden" name="id_ixs[]" id="id_ixs_' + indi + '" value="0">';
            tr += '<input type="hidden" name="min_porc[]" id="min_porc_' + indi + '" value="' + minp + '">';
            tr += '<textarea id="indica_' + indi + '" class="text tables-input-show tables-input" rows="2">' + ind_txt + '</textarea></td>';
            tr += '<td><textarea name="logros[]" id="logro_' + indi + '" class="text tables-input-show tables-input" rows="2">' + logr + '</textarea></td>';
            tr += '<td><textarea name="limitante[]" id="limit_' + indi + '" class="text tables-input-show tables-input" rows="2">' + limi + '</textarea></td>';
            tr += '<td><textarea id="estado_txt_' + indi + '" class="text tables-input-show tables-input" rows="2">' + stt_txt + '</textarea></td>';
            tr += '<td><input type="text" class="datepicker text tables-input-show tables-input" name="fecha_logro[]" id="fecha_logro_' + indi + '" value="' + fech + '" ></td>';
            tr += '<td><input type="text" class="soloNumeros tables-input-show tables-input" extras="." maxlength="6" name="porc[]" id="porc_'+indi+'" value="'+number_format(porc, 2)+'"></td>';
            tr += '<td><button type="button" id="save_'+indi+'" class="btn btn-info save_fac btn-mini" title="Guardar" corre="'+indi+'" style="display: none;"><span class="icon-ok white"></span></button>';
            tr += '<button type="button" id="edit_'+indi+'" class="btn btn-info edit_fac btn-mini" title="Editar" corre="'+indi+'"><span class="icon-pencil white"></span></button><span>&nbsp;</span>';
            tr += '<button type="button" id="del_'+indi+'" class="btn btn-danger del_fac btn-mini" title="Eliminar" corre="'+indi+'"><span class="icon-trash white"></span></button></td></tr>';
            $("#contenedor_detalle").append(tr);
            $("#txt_logro, #txt_limitante, #txt_fecha_act, #txt_porcent").val("");
            $("#slc_detalles option").removeAttr('selected');
            $("#slc_state_lgr option").removeAttr('selected');
            $("#slc_detalles, #slc_state_lgr").select2({placeholder: "Seleccione"});
        } else {
            crear_alerta('error', 'Detalles de Acción', 'Verifique los campos requeridos.');
            return false;
        }
    });

    $(document).on('click', '.del_fac', function(e){
        var row = $(this).attr('corre');
        $("#tr_inr_" + row).remove();
    });

    $(document).on('click', '.edit_fac', function(e){
        var i = $(this).attr('corre');
        $("#del_" + i).hide();
        $("#edit_" + i).hide();
        $("#porc_" + i).removeClass('tables-input-show tables-input');
        $("#logro_" + i).removeClass('tables-input-show tables-input');
        $("#limit_" + i).removeClass('tables-input-show tables-input');
        $("#fecha_logro_" + i).removeClass('tables-input-show tables-input');
        $("#fecha_logro_" + i).datepicker({
            dateFormat: 'dd-mm-yy',
            changeMonth: true,
            changeYear: true,
            maxDate: 0
        }).mask("99-99-9999").attr('placeholder', "dd-mm-yyyy");
        $("#save_" + i).show();
    });

    $(document).on('click', '.save_fac', function(e){
        var i = $(this).attr('corre');
        var valor = $("#porc_" + i).val().trim();
        if (valor != "") {
            if (valor > 100) {
                crear_alerta('warning', 'Atención', 'El porcentaje no debe exceder el 100%');
                return false;
            } else {
                var n_val = parseFloat(valor);
                var minimo = parseFloat($("#min_porc_"+i).val());
                if (n_val < minimo) {
                    crear_alerta('warning', 'Atención', 'Este porcentaje no debe menor al '+minimo+'%');
                    return false;
                }
                $("#porc_" + i).val(number_format(valor, 2));
                $("#porc_" + i).addClass('tables-input-show tables-input');
                $("#logro_" + i).addClass('tables-input-show tables-input');
                $("#limit_" + i).addClass('tables-input-show tables-input');
                $("#fecha_logro_" + i).removeAttr('placeholder').removeClass('datepicker');
                $("#fecha_logro_" + i).addClass('tables-input-show tables-input');
            }
        } else {
            $("#porc_" + i).focus();
            crear_alerta('warning', 'Atención', 'Valor numérico requerido en el avance de la acción');
            return false;
        }
        $("#save_" + i).hide();
        $("#del_" + i).show();
        $("#edit_" + i).show();
    });

    $("#frm-datos").validate({
        ignore: [],
        rules: {
            slc_residual: {required: true, min: 1}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#contenedor_detalle tr').length > 0) {
                var pendientes = 0;
                $(".save_fac").each(function (index) {
                    pendientes += ($(this).is(":visible")) ? 1 : 0;
                });
                if (pendientes > 0) {
                    crear_alerta('info', 'Atención', 'Tiene detalles pendientes de guardar');
                    return false;
                }
                form.submit();
            } else {
                crear_alerta('error', 'Debe ingresar al menos un detalle');
                return false;
            }
        }
    });

    $(document).keydown(function(tecla) {
        if (tecla.keyCode == 13) {
            $('#agregar').trigger('click');
        }
    });
    
    //SECCION DE ANEXOS
    var anx = 0;
    var ruta_anx = urlj + 'inicio/guardar_gral/anx_temporales'; 
    new FUload('btnAnexo', ruta_anx, {
        start: function (file) {
            wait.start();
        },
        sucess: function (data) {
            wait.close();
            if ($.trim(data) !== "") {
                var a_exten = $.trim(data).split('.');
                var tipo    = a_exten[(a_exten.length - 1)];
                var exten   = "." + tipo;
                var preview = "<tr id='preview" + anx + "' style='display:none;' class='preview_documento'>";
                if (tipo == 'png' || tipo == 'jpg' || tipo == 'jpeg' || tipo == 'pdf') {
                    preview += '<td><a  title="Ver Anexo" class="ver_en_modal fancybox-buttons" data-fancybox-group="button" href="' + urlj 
                    + 'public/temp/anx_temporales/' + $.trim(data) + '">';
                } else {
                    preview += '<td><a target="_blank" title="Ver Anexo" class="" data-fancybox-group="button" href="' + urlj 
                    + 'public/temp/anx_temporales/' + $.trim(data) + '">';
                }
                preview += '<img id="pre' + anx + '" src="" width="88" height="88" class="imagen_documento"></a></td>';
                preview += '<td><input maxlength="75" style="width:50%;" class="titulo_documento" type="text" name="titulo_doc[]" value="' + $.trim(data).replace(exten, '') + '">';
                preview += '<span style="display:none;font-size:11px;color:red;margin-top:-10%" class="texto" id="titulo_doc'+ anx + '"></span><br>';
                preview += '<small style="text-align:left;">Nombre del documento</small></td><td style="vertical-align:middle !important; width:30px !important;">';
                preview += '<img style="display:none;" src="' + urlj + 'media/editar_documento.png" title="Editar" value="titulo_doc' + anx + '" class="editar_documento"/></td>';
                preview += '<td style="background:#E1E7F0!important;"><a href="javascript: void(0);" title="Eliminar Anexo" class="eliminar_imagen" id="delete' + anx + '" custom="" custom_id="">';
                preview += '<img class="quitar_documento" src="' + urlj + 'media/eliminar_documento.png" title="Eliminar documento"></a>';
                preview += '<input type="hidden" name="ruta[]" id="ruta' + anx + '"  value="' + $.trim(data) + '" readonly></td></tr>';
                $("#previews").append(preview).show(500);
                $("#awesome_form").append("<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></div>");
                $("#preview" + anx).fadeIn(500);
                document.getElementById('pre' + anx).src = urlj + "media/imagenes/sistema/" + tipo + ".png";
                document.getElementById('ruta' + anx).value = $.trim(data);
                document.getElementById('delete' + anx).custom = $.trim(data);
                document.getElementById('delete' + anx).custom_id = i;
                valor = document.getElementById('pre' + anx).src;
                anx++;
                $(".eliminar_imagen, .verAnexo").tooltip();
            } else {
                //el formato es incorrecto
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });

    $(".eliminar_imagen").live("click", function (event) {
        event.preventDefault();
        url = this.custom;
        id_key = this.custom_id;
        id = this.id;
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/anx_temporales',
            data: {url: url},
            success: function (data) {
                $("#ruta" + id_key).val("");
                $("#" + id).parent().parent().remove().delay(300);
            }
        });
    });
    
    $(".delete_anexo").live('click', function(event){
        event.preventDefault();        
        var anexo = $(this).data('anexo');
        $("#anexo_"+anexo).remove().delay(500);
    });

    $(".verAnexo").fancybox({
        openEffect  : 'elastic',
        closeEffect : 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        helpers : {
            title : {
                type : 'inside'
            }
        }
    });

});

function go_back(url){
    window.location.href = url;
}

function luz_alerta() {
    var id_evalua = $("#id_evt").val();
    var color_smf = $("#color_semaf").val();
    if (id_evalua > 0 && color_smf != "") {
        $("#dvTipoAlerta").css({'background': color_smf});
        $("#dvTipoAlerta").addClass('luz_alerta');
    } else {
        $("#dvTipoAlerta").css({'background':''});
        $("#dvTipoAlerta").removeClass('luz_alerta');
    }
}

function luz_alerta_2() {//en desuso?
    var imp = $("#hdn_imr").val();
    var prb = $("#hdn_prb").val();
    if (imp > 0 && prb > 0) {
        $.ajax({
            url: urlj + 'modulo_planificacion/pla_riesgos/get_evaluacion_riesgo',
            type: 'POST',
            dataType: 'json',
            data: {
                impact: imp,
                probab: prb
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                if (data.filas > 0) {
                    $("#txt_evaluation").val(data.texto);
                    $("#dvTipoAlerta").css({'background': data.color});
                    $("#dvTipoAlerta").addClass('luz_alerta');
                } else {
                    $("#txt_evaluation").val("");
                    $("#dvTipoAlerta").css({'background':''});
                    $("#dvTipoAlerta").removeClass('luz_alerta');
                    crear_alerta('warning', '', 'No hay una evaluación de riesgo para esta combinación de probabilidad e impacto');
                }
                wait.close();
            }
        });
    } else {
        $("#txt_evaluation").val("");
        $("#dvTipoAlerta").css({'background':''});
        $("#dvTipoAlerta").removeClass('luz_alerta');
    }
}