$(document).ready(function () {
    var i = $('#contenedor_indicador tr').length;
    $('select').select2({placeholder: "Seleccione"});

    if ($("#es_lectura").val() > 0) {
        $('select').select2("disable");
    }
    
    $(document).on('click', '#bHlkRegresar', function(e){
        e.preventDefault();
        var leer = $("#es_lectura").val();
        url = $('#bHlkRegresar').attr('href');
        if (leer > 0) {
            go_back(url);
        } else {
            alerta_confirm_ajax(go_back, url, 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados y si sales, se perderán. ¿Éstas seguro que quieres regresar a la lista?');
        }
    });

    $("#slcMatUnidad").change(function(){
        var matriz = $(this).val();
        if (matriz > 0) {
            $.ajax({
                url: urlj + 'modulo_planificacion/pla_riesgos/get_areas_por_matriz',
                type: 'POST',
                data: {
                    matriz: matriz
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (response) {
                    $("#tipo_objetivo").val('');
                    $("#slcAreaMatriz").html(response);
                    $("#slcAreaMatriz").select2();
                    $("#slcAreaMatriz").trigger('change');
                    wait.close();
                }
            });
        } else {
            $("#slcAreaMatriz, #slcObjetivo, #slcResponsable").html('<option value=""></option>');
            $("#slcAreaMatriz, #slcObjetivo, #slcResponsable").select2();
            $("#tipo_objetivo").val('');
        }
    });

    $("#slcAreaMatriz").change(function(){
        var area = $(this).val();
        if (area > 0) {
            var matriz = $("#slcMatUnidad").val();
            $.ajax({
                url: urlj + 'modulo_planificacion/pla_riesgos/get_objetivos_mxu',
                type: 'POST',
                data: {
                    matriz: matriz,
                    area: area
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (response) {
                    $("#tipo_objetivo").val('');
                    $("#slcObjetivo").html(response);
                    $("#slcObjetivo").select2();
                    $("#slcObjetivo").trigger('change');
                    wait.close();
                }
            });
        } else {
            $("#slcObjetivo, #slcResponsable").html('<option value=""></option>');
            $("#slcObjetivo, #slcResponsable").select2();
            $("#tipo_objetivo").val('');
        }
    });

    $("#slcObjetivo").change(function(){
        var objetivo = $(this).val();
        if (objetivo != "") {
            var area = $("#slcAreaMatriz").val();
            var tipo = $("#slcObjetivo option:selected").data('tipo');
            $("#tipo_objetivo").val(tipo);
            $.ajax({
                url: urlj + 'modulo_planificacion/pla_riesgos/get_responsable_obj',
                type: 'POST',
                data: {
                    objetivo: objetivo,
                    area: area,
                    tipo: tipo
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (response) {
                    $("#slcResponsable").html(response);
                    $("#slcResponsable").select2();
                    wait.close();
                    generar_codigo();
                }
            });
        } else {
            $("#slcResponsable").html('<option value=""></option>');
            $("#slcResponsable").select2();
            $("#tipo_objetivo").val('');
        }
    });

    $("#slc_tipo_factor").change(function(){
        var tipo = $(this).val();
        if (tipo > 0) {
            $.ajax({
                url: urlj + 'modulo_planificacion/pla_riesgos/get_factores',
                type: 'POST',
                data: {
                    tipo: tipo
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (response) {
                    $("#slc_factor").html(response);
                    $("#slc_factor").select2();
                    wait.close();
                }
            });
        } else {
            $("#slc_factor").html('<option value=""></option>');
            $("#slc_factor").select2();
            $("#txtDescripcion").val('');
        }
    });

    $('#add_factor').live('click', function (event) {
        event.preventDefault();
        var tpo = $("#slc_tipo_factor").val();
        var fac = $("#slc_factor") .val();
        var factor_selected = $("#slc_factor option:selected").text();
        var tipofc_selected = $("#slc_tipo_factor option:selected").text();
        var detalles = $("#txtDescripcion").val();
        if ($('#tr_factor_' + tpo + '_' + fac).length > 0) {
            crear_alerta('error', 'Factores de Riesgo', 'El factor ya fue agregado.');
            return false;
        }
        if (tpo > 0 && fac > 0) {
            var h_factor = '<input type="hidden" id="hdn_tipo_' + tpo + '_' + fac + '" name="tipo_fac[]" value="' + tpo + '" />';
            h_factor += '<input type="hidden" id="ids_fxr_' + tpo + '_' + fac + '" name="ids_fxr[]" value="0">';
            h_factor += '<input type="hidden" id="ids_fac_' + tpo + '_' + fac + '" name="ids_fac[]" value="' + fac + '" />';
            h_factor += '<input type="text" id="txt_fac_' + tpo + '_' + fac + '" class="text tables-input-show tables-input" value="' + factor_selected + '" readonly />';
            var t_factor = '<input type="text" id="txt_tpf_' + tpo + '_' + fac + '" class="text tables-input-show tables-input" value="' + tipofc_selected + '" readonly />';  
            var h_det = '<textarea id="txt_detalles_' + tpo + '_' + fac + '" style="resize: none;" name="desc_fac[]" class="text tables-input-show tables-input" rows="2" maxlenght="1000" readonly>';
            h_det += detalles + '</textarea>';
            var boton = '<button class="btn btn-danger del_fac" corre="' + tpo + '_' + fac + '"><span class="cut-icon-trashcan"></span></button>';
            $("#contenedor_factor").append('<tr id="tr_factor_' + tpo + '_' + fac + '"><td>' + t_factor + '</td><td>' + h_factor + '</td><td>' + h_det + '</td><td>'+boton+'</td></tr>');
            $("#txtDescripcion").val('');
            $("#slc_factor").val('').trigger('change');
        } else {
            crear_alerta('error', 'Factores de Riesgo', 'Verifique los campos requeridos.');
            return false;
        }
    });

    $(document).on('click', '.del_fac', function(e){
        var row = $(this).attr('corre');
        $("#tr_factor_" + row).remove();
    });

    $(document).on('change', '.semaforo_a', function(e){
        var imp = $("#slc_impact_a").val();
        var prb = $("#slc_probability_a").val();
        if (imp > 0 && prb > 0) {
            $.ajax({
                url: urlj + 'modulo_planificacion/pla_riesgos/get_evaluacion_riesgo',
                type: 'POST',
                dataType: 'json',
                data: {
                    impact: imp,
                    probab: prb
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    if (data.filas > 0) {
                        $("#evr_antes").val(data.id);
                        $("#dvTipoAlerta_a").css({'background': data.color});
                        $("#dvTipoAlerta_a").addClass('luz_alerta');
                    } else {
                        $("#evr_antes").val("");
                        $("#dvTipoAlerta_a").css({'background':''});
                        $("#dvTipoAlerta_a").removeClass('luz_alerta');
                        crear_alerta('warning', '', 'No hay un análisis de riesgo para esta combinación de probabilidad y consecuencia');
                    }
                    wait.close();
                    riesgo_final();
                }
            });
        } else {
            $("#evr_antes").val("");
            $("#dvTipoAlerta_a").css({'background':''});
            $("#dvTipoAlerta_a").removeClass('luz_alerta');
            riesgo_final();
        }
    });

    $(document).on('change', '.semaforo_d', function(e){
        var imp = $("#slc_impact_d").val();
        var prb = $("#slc_probability_d").val();
        if (imp > 0 && prb > 0) {
            $.ajax({
                url: urlj + 'modulo_planificacion/pla_riesgos/get_evaluacion_riesgo',
                type: 'POST',
                dataType: 'json',
                data: {
                    impact: imp,
                    probab: prb
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    if (data.filas > 0) {
                        $("#evr_despu").val(data.id);
                        $("#dvTipoAlerta_d").css({'background': data.color});
                        $("#dvTipoAlerta_d").addClass('luz_alerta');
                    } else {
                        $("#evr_despu").val("");
                        $("#dvTipoAlerta_d").css({'background':''});
                        $("#dvTipoAlerta_d").removeClass('luz_alerta');
                        crear_alerta('warning', '', 'No hay un análisis de riesgo para esta combinación de probabilidad y consecuencia');
                    }
                    wait.close();
                    riesgo_final();
                }
            });
        } else {
            $("#evr_despu").val("");
            $("#dvTipoAlerta_d").css({'background':''});
            $("#dvTipoAlerta_d").removeClass('luz_alerta');
            riesgo_final();
        }        
    });
    $("#slc_probability_a").trigger("change");
    $("#slc_probability_d").trigger("change");

    $(".datepicker").datepicker({
        dateFormat: 'dd-mm-yy',
        changeMonth: true,
        changeYear: true
    });
    $(".datepicker").mask("99-99-9999");
    $(".datepicker").attr('placeholder', "dd-mm-yyyy");

    $(document).on('change', '.datepicker', function(){
        if ($("#txtFechaInicio").val() != "" && $("#txtFechaFin").val() != "") {
            fecha_valida($("#txtFechaInicio").val(), $("#txtFechaFin").val());
        }
    });

    $('#add_indicator').live('click', function (event) {
        event.preventDefault();
        var indica = $("#txtIndicador").val();
        if (indica != "") {
            var html = '<tr id="tr_' + i + '" ><td><input type="hidden" value="0" name="inr_ids[]" id="inr_ids_' + i + '">';
            html += '<textarea id="txt_indica_' + i + '" style="resize: none;" name="indicadores[]" class="text tables-input-show tables-input" rows="2" maxlenght="1000" readonly>';
            html += indica + '</textarea></td><td><button class="btn btn-danger del_ind" corre="' + i + '"><span class="cut-icon-trashcan"></span></button></td></tr>';
            $("#contenedor_indicador").append(html);
            $("#txtIndicador").val('');
            i++;
        } else {
            crear_alerta('info', 'Detalle de Acción', 'Verifique la información ingresada.');
            return false;
        }
    });

    $(document).on('click', '.del_ind', function(e){
        var row = $(this).attr('corre');
        $("#tr_" + row).remove();
    });

    $("#frm-datos").validate({
        ignore: [],
        rules: {
            slcMatUnidad: {required: true, min: 1},
            slcAreaMatriz: {required: true, min: 1},
            slcResponsable: {required: true, min: 1},
            slcClasificiacion: {required: true, min: 1},
            txtNombre: {required: true},
            txtConsecuencia: {required: true},
            txt_evaluation: {required: true},
            slc_probability: {required: true, min: 1},
            slc_impact: {required: true, min: 1}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#contenedor_factor tr').length > 0) {
                if (fecha_valida($("#txtFechaInicio").val(), $("#txtFechaFin").val())) {
                    if ($('#contenedor_indicador tr').length > 0) {
                        form.submit();
                    } else {
                        crear_alerta('error', 'Debe ingresar al menos un indicador');
                        return false;        
                    }
                } else {
                    return false;    
                }
            } else {
                crear_alerta('error', 'Debe ingresar al menos un factor');
                return false;
            }
        }
    });    

});

function fecha_valida(fecha_ini, fecha_fin) {
    var start = fecha_ini.split("-").reverse().join("-");
    var final = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(start) > Date.parse(final)) {
        crear_alerta('error', 'Verifique las fechas del período', '');
        return false;
    } else {
        return true;
    }    
}

function generar_codigo() {
    var original = $("#code_org").val();
    var matriz   = $("#slcMatUnidad").val();
    var area_mat = $("#slcAreaMatriz").val();
    var tipo_obj = ($("#tipo_objetivo").val() != "") ? $("#tipo_objetivo").val() : $("#slcObjetivo option:selected").data('tipo');
    if (matriz > 0 && area_mat > 0 && tipo_obj != "") {
        $.ajax({
            url: urlj + 'modulo_planificacion/pla_riesgos/get_codigo_riesgo',
            type: 'POST',
            dataType: 'json',
            data: {
                matriz: matriz,
                area_mat: area_mat,
                tipo_obj: tipo_obj
            },
            success: function (data) {
                $("#txtCodigo").val(data.codigo);
            }
        });
    } else {
        $("#txtCodigo").val(original);
    }
}

function go_back(url){
    window.location.href = url;
}



function riesgo_final() {
    var antes = $("#evr_antes").val();
    var despu = $("#evr_despu").val();
    var contr = $("#slc_ctrl_act").val();
    $("#txt_evaluation").removeClass('error');
    $("#txt_evaluation_error").html("");
    if (antes != "" && despu != "" && contr != "") {
        $.ajax({
            url: urlj + 'modulo_planificacion/pla_riesgos/get_evaluacion_riesgo_final',
            type: 'POST',
            dataType: 'json',
            data: {
                ctrl: contr,
                antes: antes,
                despues: despu
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                console.log(data);
                    if (data.filas > 0) {
                        $("#txt_eval_id").val(data.id);
                        $("#txt_evaluation").val(data.texto);
                        $("#borde").css({'background': data.color});
                    } else {
                        $("#txt_eval_id").val("");
                        $("#txt_evaluation").val("");
                        $("#borde").css({'background': ''});
                        crear_alerta('warning', '', 'No hay una evaluación de riesgo para esta combinación de análisis');
                    }
                    wait.close();
                }
            });
    } else {
        $("#txt_eval_id").val("");
        $("#txt_evaluation").val("");
        $("#borde").css({'background': ''});
    }
    
}