$(document).ready( function(){
    $("select").select2();

    $("#slcArea").select2({
        placeholder: "Buscar Área",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'estructura_organizativa/procesos/get_areas_ajax',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (area) {
                return {
                    area: area
                }
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.are_id,
                        'text': item.are_nombre
                    });
                });

                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#btnConsultar").click(function(){
        var plan_operativo = $("#slcPlanOperativo").val();
        var area = $("#slcArea").val();

        if(plan_operativo==''){
            crear_alerta('error','Reporte Cumplimiento Mensual','Debe espeficiar un Plan Operativo');
            return false;
        }

        $("#dv_contenedor").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                    url: window.gSateliteWhite.baseUrl('modulo_planificacion/pla_reporte_poa/reporte_cumplimiento_mensual/1'),
                    data: {
                        plan_operativo: plan_operativo,
                        area: area
                    },
                    type: "post",
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (result) {
                        $("#dv_contenedor").html(result);
                        $("#dv_contenedor").show("slide", {
                            direction: 'left'
                        }, 500);
                        wait.close();
                    }
                });
            }
        );

    });
});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
