$(document).ready( function(){
    $("select").select2();

    $("#slcPlan").change(function() {
        var plan = $(this).val();
        if (plan > 0) {
            $.ajax({
                url: urlj + 'modulo_planificacion/pla_reporte_pei/get_pie_x_pes',
                type: "post",
                data: {
                    plan: plan
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    $("#slc_pie").html(result);
                    $("#slc_pie").select2();            
                    wait.close();
                }
            });
        } else {
            $("#slc_pie").html('<option value=""></option>');
            $("#slc_pie").select2();
            $("#slc_pie").trigger('change');
        }
    });

    $("#slc_pie").change(function() {
        var pie = $(this).val();
        if (pie > 0) {
            $.ajax({
                url: urlj + 'modulo_planificacion/pla_reporte_pei/get_obe_x_pie',
                type: "post",
                data: {
                    pie: pie
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    $("#slc_obe").html(result);
                    $("#slc_obe").select2();            
                    wait.close();
                }
            });
        } else {
            $("#slc_obe").html('<option value=""></option>');
            $("#slc_obe").select2();
            $("#slc_obe").trigger('change');
        }
    });

    $("#slc_obe").change(function() {
        var obe = $(this).val();
        if (obe > 0) {
            $.ajax({
                url: urlj + 'modulo_planificacion/pla_reporte_pei/get_aca_x_obe',
                type: "post",
                data: {
                    obe: obe
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    $("#slc_aca").html(result);
                    $("#slc_aca").select2();            
                    wait.close();
                }
            });
        } else {
            $("#slc_aca").html('<option value=""></option>');
            $("#slc_aca").select2();
            $("#slc_aca").trigger('change');
        }
    });

    $("#slc_aca").change(function() {
        var aca = $(this).val();
        if (aca > 0) {
            $.ajax({
                url: urlj + 'modulo_planificacion/pla_reporte_pei/get_aco_x_aca',
                type: "post",
                data: {
                    aca: aca
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    $("#slc_aco").html(result);
                    $("#slc_aco").select2();            
                    wait.close();
                }
            });
        } else {
            $("#slc_aco").html('<option value=""></option>');
            $("#slc_aco").select2();
        }
    });
    

    $("#btnConsultar").click(function(){
        var plan = $("#slcPlan").val();
        if(plan == ''){
            crear_alerta('error', 'Reporte de Formulación PEI', 'Debe espeficiar un Plan Estratégico');
            return false;
        }
        $("#dv_contenedor").hide('slide',{ direction:'right' }, 400,function(){
            var pie = $("#slc_pie").val();
            var obe = $("#slc_obe").val();
            var aca = $("#slc_aca").val();
            var aco = $("#slc_aco").val();
            $.ajax({
                url: window.gSateliteWhite.baseUrl('modulo_planificacion/pla_reporte_pei/reporte_formulacion_pei/1'),
                type: "post",
                dataType: "json",
                data: {
                    plan: plan,
                    pie: pie,
                    obe: obe,
                    aca: aca,
                    aco: aco
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    console.log(result);
                    $("#dv_contenedor").html(result.tabla);
                    if (!result.puede_ver) {
                        crear_alerta('info', '', 'Solo se muestran resultados donde usted es responsable o participante');
                    }
                    $("#dv_contenedor").show("slide", { direction: 'left' }, 500);
                    wait.close();
                }
            });
        });
    });
    
});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
