$(document).ready( function(){
    $("select").select2({placeholder:"Seleccione una opción"});

    $("#slcArea").select2({
        placeholder: "Buscar Área",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'estructura_organizativa/procesos/get_areas_ajax',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (area) {
                return {
                    area: area
                }
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.are_id,
                        'text': item.are_nombre
                    });
                });

                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#btnConsultar").click(function(){
        var plan_operativo = $("#slcPlanOperativo").val();
        var area = $("#slcArea").val();
        var mes = $("#slcMes").val();

        if(plan_operativo=='' || area == '' || mes==''){
            crear_alerta('error','Indicadores Operativos - Seguimiento Mensuall','Debe completar los filtros');
            return false;
        }

        $("#dv_contenedor_documentos").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                    type:'post',
                    url:window.location.pathname,
                    data:{plan_operativo:plan_operativo,area:area, mes: mes},
                    dataType: 'json',
                    beforeSend:function(){
                        wait.start();
                    },
                    success:function(result){
                        wait.close();
                        console.log(result);
                        var oTabla = $("#tblDocumentos").dataTable();

                        oTabla.fnDestroy();
                        $("#tbContenedorDocumentos").html(result.html);

                        $("#dv_contenedor_documentos").show("slide", {
                            direction: 'left'
                        }, 500);
                        aplicarDataTable('#tblDocumentos');
                    }
                });
            }
        );

    });
});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
